/***************************************************************************
  fixedspinbox.cpp
  -------------------
  description   A spinbox for fixed numbers
  -------------------
  begin         September 28th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999, 2001, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include "fixedspinbox.h"

#include <cmath>
#include <qvalidator.h>

//////////////////////////////////////////////////////////////////////////////
// Construction, Destruction                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// FixedSpinBox()
// --------------
// Constructor

FixedSpinBox::FixedSpinBox(double minValue, double maxValue, double step,
                           unsigned fix, QWidget* parent, const char* name)
    : QSpinBox(0, 1, 1, parent, name), validator_(0), fixed_(fix), divisor_(0),
      tinyval_(0)
{
    validator_ = new QDoubleValidator(minValue, maxValue, fixed_+1, this,
                                      QString(name) + "Validator" );
    setValidator(validator_);
    // set the appropriate integers values in the base class
    divisor_ = int(pow(10.0, double(fixed_)));
    tinyval_ = 1.0 / pow(10.0, double(fixed_+1));
    QSpinBox::setMaxValue(int(divisor_ * maxValue));
    QSpinBox::setMinValue(int(divisor_ * minValue));
    QSpinBox::setLineStep(int(divisor_ * step));
}

//////////////////////////////////////////////////////////////////////////////
// ~FixedSpinBox()
// ---------------
// Destructor

FixedSpinBox::~FixedSpinBox() { delete validator_; }

//////////////////////////////////////////////////////////////////////////////
// Implementation                                                           //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// valueChange()
// -------------
// QSpinBox override, the value of the spinbox has changed

void FixedSpinBox::valueChange()
{
    QSpinBox::valueChange();
    emit valueChanged( QSpinBox::value() / double(divisor_) );
}
