/***************************************************************************
  hops.cpp
  -------------------
  A hops class
  -------------------
  begin         October 20th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999-2002, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include "hops.h"

#include <cmath>

#include <qstringlist.h>

//////////////////////////////////////////////////////////////////////////////
// Construction, Destruction                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// Hops()
// ------
// default constructor

Hops::Hops()
    : name_(""), weight_(), form_(""), alpha_(0.0), time_(0)
{ ; }

//////////////////////////////////////////////////////////////////////////////
// Hops()
// ------
// full constructor

Hops::Hops(const QString &name, const Weight &weight, const QString &form,
           const double &alpha, const unsigned &time)
    : name_(name), weight_(weight), form_(form), alpha_(alpha), time_(time)
      
{
    hbu_ = 0.75 * alpha * weight_.amount(Weight::ounce);
}

//////////////////////////////////////////////////////////////////////////////
// Hops(const Hops &)
// ------------------
// Copy constructor

Hops::Hops(const Hops &h)
    : name_(h.name_), weight_(h.weight_), form_(h.form_), alpha_(h.alpha_),
      time_(h.time_), hbu_(h.hbu_)
{ ; }

Hops::~Hops() { ; }

//////////////////////////////////////////////////////////////////////////////
// Operators                                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// operator=()
// -----------
// Assignment operator

Hops Hops::operator=(const Hops &h)
{
    if (this != &h) {
        name_ = h.name_;
        weight_ = h.weight_;
        form_ = h.form_;
        alpha_ = h.alpha_;
        time_ = h.time_;
        hbu_ = h.hbu_;
    }
    return *this;
}

//////////////////////////////////////////////////////////////////////////////
// operator==()
// ------------
// Equivalence operator

bool Hops::operator==(const Hops &h)
{
    return (name_ == h.name_)
        && (weight_ == h.weight_)
        && (form_ == h.form_)
        && (alpha_ == h.alpha_)
        && (time_ == h.time_);
}

//////////////////////////////////////////////////////////////////////////////
// HopsListItem Class                                                       //
//////////////////////////////////////////////////////////////////////////////

HopsListItem::HopsListItem(QListView * parent, QString a, QString b, QString c,
                           QString d, QString e, QString f, QString g, QString h)
    : QListViewItem(parent, a, b, c, d, e, f, g, h), hit_(0) { ; }

void HopsListItem::setToIterator()
{
    setText(0, (*hit_).name());
    setText(1, QString::number((*hit_).weight().amount(), 'f', 2));
    setText(2, (*hit_).form());
    setText(3, QString::number((*hit_).alpha()) + '%');
    setText(4, QString::number((*hit_).time()));
}
