/***************************************************************************
  ingredientpage.cpp
  -------------------
  Generic dialog page for an ingredient type
  -------------------
  begin         October 8th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999-2002, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include "ingredientpage.h"

#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "controller.h"
#include "fixedspinbox.h"
#include "model.h"
#include "view.h"

//////////////////////////////////////////////////////////////////////////////
// IngredientPage()
// ----------------
// Constructor

IngredientPage::IngredientPage(Model *model, View* view,
                                Controller *controller, const char* name)
    : QWidget(view, name), model_(model), view_(view), controller_(controller),
      pagelayout_(0), rowonelayout_(0), rowtwolayout_(0), itemslistview_(0),
      itemlabel_(0), itemcombo_(0), quantitylabel_(0), quantityspin_(0),
      addbutton_(0), applybutton_(0), removebutton_(0), spacer_(0)
{
    // TODO: need to use small/large icons according to prefs
    QString smallicon = controller_->dataBase() + "icons/16x16/actions/";
    QString largeicon = controller_->dataBase() + "icons/22x22/actions/";

    itemslistview_ = new QListView(this, "itemslistview_");
    itemslistview_->addColumn("Item");
    itemslistview_->addColumn("Quantity");
    itemslistview_->setColumnAlignment(0, AlignLeft);
    itemslistview_->setColumnAlignment(1, AlignRight);
    itemslistview_->setSorting(0);
    itemslistview_->setSorting(1);
    itemslistview_->setShowSortIndicator(true);

    itemlabel_ = new QLabel("Item", this, "itemlabel_");
    itemcombo_ = new QComboBox(true, this, "itemcombo_");
    quantitylabel_ = new QLabel("Quantity", this, "quantitylabel_");
    quantityspin_ = new FixedSpinBox(0.00, 100.00, 0.25, 2, this, "quantityspin_");

    addbutton_ = new QPushButton(this, "addbutton_");
    addbutton_->setPixmap(QPixmap(smallicon + "add.png"));
    addbutton_->setAccel(CTRL+Key_Insert);
    QToolTip::add(addbutton_, "Add Ingredient");
    QWhatsThis::add(addbutton_,
                    "Click the button to add the current ingredient to the recipe\n\n"
                    "You can also type Ctrl+Insert to apply an ingredient");
    applybutton_ = new QPushButton(this, "applybutton_");
    applybutton_->setPixmap(QPixmap(smallicon + "apply.png"));
    applybutton_->setAccel(CTRL+Key_Enter);
    QToolTip::add(applybutton_, "Apply/Change Ingredient");
    QWhatsThis::add(applybutton_,
                    "Click the button to apply the current ingredient to the recipe\n\n"
                    "You can also type Ctrl+Enter to apply an ingredient");
    removebutton_ = new QPushButton(this, "removebutton_");
    removebutton_->setPixmap(QPixmap(smallicon + "remove.png"));
    removebutton_->setAccel(CTRL+Key_Delete);
    QToolTip::add(removebutton_, "Remove Ingredient");
    QWhatsThis::add(removebutton_,
                    "Click the button to remove the current ingredient from the recipe\n\n"
                    "You can also type Ctrl+Delete to remove an ingredient");

    spacer_ = new QWidget(this, "spacer_");

    // setup layout
    pagelayout_ = new QVBoxLayout(this, 6, 3, "pagelayout_");
    rowonelayout_ = new QHBoxLayout(6, "rowonelayout_");
    rowtwolayout_ = new QHBoxLayout(6, "rowtwolayout_");

    pagelayout_->addWidget(itemslistview_, 0);
    pagelayout_->addLayout(rowonelayout_, 1);
    pagelayout_->addLayout(rowtwolayout_, 0);

    rowonelayout_->addWidget(itemlabel_, 0);
    rowonelayout_->addWidget(itemcombo_, 1);
}

//////////////////////////////////////////////////////////////////////////////
// ~IngredientPage()
// -----------------
// Destructor

IngredientPage::~IngredientPage() { ; }
