/***************************************************************************
  miscingredient.cpp
  -------------------
  A miscellaneous ingredient class
  -------------------
  begin         October 20th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999-2002, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include "miscingredient.h"

#include <cmath>

#include <qstringlist.h>

//////////////////////////////////////////////////////////////////////////////
// Construction, Destruction                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// MiscIngredient()
// ----------------
// default constructor

MiscIngredient::MiscIngredient()
    : name_(""), quantity_(), notes_("")
{ ; }

//////////////////////////////////////////////////////////////////////////////
// MiscIngredient()
// ----------------
// full constructor

MiscIngredient::MiscIngredient(const QString &name, const Quantity &quantity,
                               const QString &notes)
    : name_(name), quantity_(quantity), notes_(notes)
{ ; }

//////////////////////////////////////////////////////////////////////////////
// MiscIngredient()
// ----------------
// copy constructor

MiscIngredient::MiscIngredient(const MiscIngredient &m)
    : name_(m.name_), quantity_(m.quantity_), notes_(m.notes_)
{ ; }

MiscIngredient::~MiscIngredient() {}

//////////////////////////////////////////////////////////////////////////////
// Operators                                                                //
//////////////////////////////////////////////////////////////////////////////

MiscIngredient MiscIngredient::operator=(const MiscIngredient &m)
{
    if (this != &m) {
        name_ = m.name_;
        quantity_ = m.quantity_;
        notes_ = m.notes_;
    }
    return *this;
}

bool MiscIngredient::operator==(const MiscIngredient &m)
{
    return (name_ == m.name_)
        && (quantity_ == m.quantity_)
        && (notes_ == m.notes_);
}

//////////////////////////////////////////////////////////////////////////////
// MiscIngredientListItem Class                                             //
//////////////////////////////////////////////////////////////////////////////

MiscIngredientListItem::MiscIngredientListItem(QListView * parent, QString a, QString b,
    QString c, QString d, QString e, QString f, QString g, QString h)
    : QListViewItem(parent, a, b, c, d, e, f, g, h), mit_(0) { ; }

MiscIngredientListItem::~MiscIngredientListItem() { ; }

void MiscIngredientListItem::setToIterator()
{
    setText(0, (*mit_).name());
    setText(1, QString::number((*mit_).quantity().amount(), 'f', 2));
    setText(2, (*mit_).notes());
}
