/***************************************************************************
  hop.h
  -------------------
  A hop class
  -------------------
  Copyright 1999-2005, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef HOP_H
#define HOP_H

#include <qlistview.h>
#include <qstring.h>
#include <qvaluelist.h>

#include "quantity.h"

//////////////////////////////////////////////////////////////////////////////
// Hop

class Hop {
public:
    // default constructor
    Hop();
    // full constructor
    Hop(const QString &nam, const Weight &weight,
        const QString &form, const double &alpha,
        const unsigned &time);
    // copy constructor
    Hop(const Hop &h);
    // assignment operator
    Hop operator=(const Hop &h);
    // comparison operator
    bool operator==(const Hop &h);
    // destructor
    ~Hop();

    // get/set name
    QString name() const;
    void setName(const QString &name);
    // get/set weight
    Weight &weight();
    void setWeight(const Weight &weight);
    // get/set form
    QString form();
    void setForm(const QString &form);
    // get/set alpha content
    void setAlpha(double alpha);
    double alpha();
    //get/ set boil time
    unsigned time();
    void setTime(unsigned time);
    
    // return precalculated values for bitterness
    double HBU();

private:
    QString name_;
    Weight weight_;
    QString form_;
    double alpha_;
    unsigned time_;
    double hbu_;
};

typedef QValueList<Hop> HopList;
typedef QValueList<Hop>::Iterator HopIterator;

//////////////////////////////////////////////////////////////////////////////
// Inlined Operators

inline void Hop::setName(const QString &name) { name_ = name; }

inline QString Hop::name() const { return name_; }

inline void Hop::setWeight(const Weight &weight) { weight_ = weight; }

inline Weight &Hop::weight() { return weight_; }

inline void Hop::setForm(const QString &form) { form_ = form; }

inline QString Hop::form() { return form_; }

inline void Hop::setAlpha(double alpha) { alpha_ = alpha; }

inline double Hop::alpha() { return alpha_; }

inline void Hop::setTime(unsigned time) { time_ = time; }

inline unsigned Hop::time() { return time_; }

inline double Hop::HBU() { return hbu_; }

//////////////////////////////////////////////////////////////////////////////
// HopItem

enum {
    HITEM_NAME = 0,
    HITEM_QUANTITY,
    HITEM_ALPHA,
    HITEM_FORM,
    HITEM_TIME
};

class HopItem : public QListViewItem {
public:
    // constructor
    HopItem(QListView * parent);
    // destructor
    ~HopItem();

    // get the iterator
    HopIterator iterator();
    // set the iterator
    void setIterator(HopIterator &it);
    // refresh text from iterator
    void refresh();

    // custom sorting (to get numerical sort order)
    int compare(QListViewItem* item, int col, bool asc) const;

private:
    HopIterator hit_; // iterator to hop in database
};

//////////////////////////////////////////////////////////////////////////////
// Inlined Operators

inline HopIterator HopItem::iterator() { return hit_; }

inline void HopItem::setIterator(HopIterator &it) { hit_ = it; }

#endif // HOP_H
