/***************************************************************************
  miscingredient.cpp
  -------------------
  A miscellaneous ingredient class
  -------------------
  Copyright 1999-2005, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include <qregexp.h>
#include <qstringlist.h>

#include "miscingredient.h"

//////////////////////////////////////////////////////////////////////////////
// MiscIngredient                                                           //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// MiscIngredient()
// ----------------
// constructor

MiscIngredient::MiscIngredient()
    : name_("Generic"), quantity_(), notes_("")
{ ; }

MiscIngredient::MiscIngredient(const QString &name, const Quantity &quantity,
                               const QString &notes)
    : name_(name), quantity_(quantity), notes_(notes)
{ ; }

MiscIngredient::~MiscIngredient() { ; }

//////////////////////////////////////////////////////////////////////////////
// MiscIngredient()
// ----------------
// copy constructor

MiscIngredient::MiscIngredient(const MiscIngredient &m)
    : name_(m.name_), quantity_(m.quantity_), notes_(m.notes_)
{ ; }

//////////////////////////////////////////////////////////////////////////////
// operator=()
// -----------
// Assignment operator

MiscIngredient MiscIngredient::operator=(const MiscIngredient &m)
{
    if (this != &m) {
        name_ = m.name_;
        quantity_ = m.quantity_;
        notes_ = m.notes_;
    }
    return *this;
}

//////////////////////////////////////////////////////////////////////////////
// operator==()
// -----------
// Equivalence operator

bool MiscIngredient::operator==(const MiscIngredient &m)
{
    return (name_ == m.name_)
        && (quantity_ == m.quantity_)
        && (notes_ == m.notes_);
}

//////////////////////////////////////////////////////////////////////////////
// MiscItem Class                                                           //
//////////////////////////////////////////////////////////////////////////////

MiscItem::MiscItem(QListView * parent) : QListViewItem(parent), mit_(0) { ; }

MiscItem::~MiscItem() { ; }

void MiscItem::refresh()
{
    setText(MITEM_NAME, (*mit_).name());
    setText(MITEM_QUANTITY,
            QString::number((*mit_).quantity().amount(), 'f', 2)
            + " " + (*mit_).quantity().unit().symbol());
    setText(MITEM_NOTES, (*mit_).notes());
}

// reimplemented for numerical sorting
int MiscItem::compare(QListViewItem* item, int column, bool asc) const
{
    switch (column) {
      case MITEM_QUANTITY: { // remove suffixes and decimals in these fields
          QRegExp regex("[0-9.]+");
          regex.search(text(column));
          int first = (int) regex.cap(0).toDouble() * 1000;
          regex.search(item->text(column));
          int second = (int) regex.cap(0).toDouble() * 1000;
          return (first - second);
      }

      default:
          return QListViewItem::compare(item, column, asc);
    }
}
