/***************************************************************************
  miscingredient.h
  -------------------
  A miscellaneous ingredient class
  -------------------
  Copyright 1999-2005, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
     this list of conditions and the following disclaimer in the documentation
     and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef MISCINGREDIENT_H
#define MISCINGREDIENT_H

#include <qlistview.h>
#include <qstring.h>
#include <qvaluelist.h>

#include "quantity.h"

//////////////////////////////////////////////////////////////////////////////
// MiscIngredient

class MiscIngredient {
public:
    // default constructor
    MiscIngredient();
    // full constructor
    MiscIngredient(const QString &name, const Quantity &quantity,
                   const QString &notes);
    // copy constructor
    MiscIngredient(const MiscIngredient &m);
    // assignment operator
    MiscIngredient operator=(const MiscIngredient &m);
    // comparison operator
    bool operator==(const MiscIngredient &m);
    // destructor
    ~MiscIngredient();

    //get/ set name
    QString name() const;
    void setName(const QString &name);
    // get/set quantity
    Quantity &quantity();
    void setQuantity(const Quantity &quantity);
    // get/set notes
    QString notes();
    void setNotes(const QString &notes);

private:
    QString name_;
    Quantity quantity_;
    QString notes_;
};

typedef QValueList<MiscIngredient> MiscIngredientList;
typedef QValueList<MiscIngredient>::Iterator MiscIngredientIterator;

//////////////////////////////////////////////////////////////////////////////
// Inlined Methods

inline void MiscIngredient::setName(const QString &name) { name_ = name; }

inline QString MiscIngredient::name() const { return name_; }

inline void MiscIngredient::setQuantity(const Quantity &quantity) { quantity_ = quantity; }

inline Quantity &MiscIngredient::quantity() { return quantity_; }

inline void MiscIngredient::setNotes(const QString &notes) { notes_ = notes; }

inline QString MiscIngredient::notes() { return notes_; }

//////////////////////////////////////////////////////////////////////////////
// MiscItem

enum {
    MITEM_NAME = 0,
    MITEM_QUANTITY,
    MITEM_NOTES
};

class MiscItem : public QListViewItem {
 public:
    // constructor
    MiscItem(QListView * parent);
    // destructor
    ~MiscItem();

    // get the iterator
    MiscIngredientIterator iterator();
    // set the iterator
    void setIterator(MiscIngredientIterator &it);
    // refresh text from iterator
    void refresh();

    // custom sorting (to get numerical sort order)
    int compare(QListViewItem* item, int col, bool asc) const;

private:
    MiscIngredientIterator mit_; // iterator to ingredient in database
};

//////////////////////////////////////////////////////////////////////////////
// Inlined Methods

inline MiscIngredientIterator MiscItem::iterator()
    { return mit_; }

inline void MiscItem::setIterator(MiscIngredientIterator &it)
    { mit_ = it; }

#endif // MISCINGREDIENT_H
