/***************************************************************************
  style.h
  -------------------
  AHA-like style class
  -------------------
  Copyright 1999-2005, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef STYLE_H
#define STYLE_H

#include <qlistview.h>
#include <qvaluelist.h>

class QString;

//////////////////////////////////////////////////////////////////////////////
// Style

class Style {
  public:
    // full constructor
    Style(const QString name="Generic Ale",
          const double &oglow=0.0, const double &oghi=0.0,
          const double &fglow=0.0, const double &fghi=0.0,
          const int &ibulow=0, const int &ibuhi=100,
          const int &srmlow=0, const int &srmhi=40);
    // copy constructor
    Style(const Style &s);
    // assignment operator
    Style operator=(const Style &s);
    // equivalence operator
    bool operator==(const Style &s) const;
    // destructor
    ~Style();

    // return name of style
    const QString &name() const;
    // return high end of OG
    double OGHi() const;
    // return low end of OG
    double OGLow() const;
    // return high end of FG
    double FGHi() const;
    // return low end of FG
    double FGLow() const;
    // return high end of IBU
    int IBUHi() const;
    // return low end of IBU
    int IBULow() const;
    // return high end of SRM
    int SRMHi() const;
    // return low end of SRM
    int SRMLow() const;
    
  private:
    QString name_;
    double oglow_;
    double oghi_;
    double fglow_;
    double fghi_;
    int ibulow_;
    int ibuhi_;
    int srmlow_;
    int srmhi_;
};

typedef QValueList<Style> StyleList;
typedef QValueList<Style>::Iterator StyleIterator;

//////////////////////////////////////////////////////////////////////////////
// Inlined Methods

inline const QString &Style::name() const { return name_; }

inline double Style::OGHi() const { return oghi_; }

inline double Style::OGLow() const { return oglow_; }

inline double Style::FGHi() const { return fghi_; }

inline double Style::FGLow() const { return fglow_; }

inline int Style::IBUHi() const { return ibuhi_; }

inline int Style::IBULow() const { return ibulow_; }

inline int Style::SRMHi() const { return srmhi_; }

inline int Style::SRMLow() const { return srmlow_; }

//////////////////////////////////////////////////////////////////////////////
// StyleItem

enum {
    SITEM_NAME = 0,
    SITEM_OGLOW,
    SITEM_OGHI,
    SITEM_FGLOW,
    SITEM_FGHI,
    SITEM_IBULOW,
    SITEM_IBUHI,
    SITEM_SRMLOW,
    SITEM_SRMHI
};

class StyleItem : public QListViewItem {
public:
    // constructor
    StyleItem(QListView * parent);
    // destructor
    ~StyleItem();

    // get the iterator
    StyleIterator iterator();
    // set the iterator
    void setIterator(StyleIterator &it);

    // refresh text from iterator
    void refresh();

    // custom sorting (to get numerical sort order)
    int compare(QListViewItem* item, int col, bool asc) const;

private:
    StyleIterator sit_; // iterator to style in database
};

//////////////////////////////////////////////////////////////////////////////
// Inlined Methods

inline StyleIterator StyleItem::iterator() { return sit_; }

inline void StyleItem::setIterator(StyleIterator &it) { sit_ = it; }

#endif // STYLE_H
