/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef USERSTATISTICS_H
#define USERSTATISTICS_H

#include <QString>

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/

class UserStatistics
{
  private:
    QString m_os;
    qint32  m_uptime;
    quint32 m_chatTime;

  public:
    UserStatistics();
    ~UserStatistics();

    static QString OsString();
    static qint32 getUptime();

    static QString time2string(quint64);

    void setOs(const QString & value){m_os = value;}
    const QString & os() const {return m_os;}

    void setUptime(qint32 value){m_uptime = value;}
    qint32 uptime() const {return m_uptime;}
    QString uptimeString() const {return time2string(m_uptime);}

    void setChatTime(quint32 value){m_chatTime = value;}
    quint32 chatTime() const {return m_chatTime;}
    QString chatTimeString() const {return time2string(m_chatTime);}
};

#endif
