#ifndef __IMLIBLOADER_H
#define __IMLIBLOADER_H

/*! \file imlibloader.h */

#include <qthread.h>
#include <qstringlist.h>

namespace QComicBook
{
	//! Thread-based image loader.
	class ImlibLoaderThread: public QThread
	{
		protected:
			volatile QThread::Priority prio; //!<thread priority
			QMutex mtx; //!<mutex for serialization of class attributes
			QStringList requests; //!<the list of requested pages
			volatile bool stopped;

			virtual void run();

		public:
			ImlibLoaderThread();
			virtual ~ImlibLoaderThread();
			
			virtual void setPriority(QThread::Priority p);

			virtual void request(const QString &file);

			//! Stops processing requests and exits thread execution.
			virtual void stop();
	};
}

#endif

