/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

/*	Carles Pina i Estany <carles@pinux.info> 2005, 2006
	GPL Licensed
*/

#include "configura.h"
#include "about.h"
#include "StructureParser.h"
#include "worddata.h"
#include "connection.h"
#include "suggeriment.h"
#include <qfile.h>
#include <qxml.h>
#include <stdio.h>
#include <qsettings.h>
#include <qdialog.h>
#include <qmessagebox.h>

int idioma_actiu;
int pdebug=0;
int showList=0;
QString searched;
HTTPConnection *http;

//idioma==1 -> catal -> angls
//idioma==2 -> angls - >catal
QString directori_usuari;
int numberFound=0;

void Main::setPdebug(int i) {
	pdebug=i;
}

void Main::editUndo()
{

}


void Main::editRedo()
{

}


void Main::editCut()
{

}


void Main::editCopy()
{

}


void Main::editPaste()
{

}


void Main::editFind()
{

}


void Main::helpIndex()
{

}


void Main::helpContents()
{

}


void Main::helpAbout()
{

}


void Main::buscar()
{
	showList=0;
	treballaBuscar();
}

void Main::treballaBuscar() {
	StructureParser handler;
	QString buscar = paraula->text();
	QString buscar_orig = paraula->text();
	char lletra;

	QString idioma;
	
	//posa_idioma();
	posarApunt(0);

	//per preparar el path
	if (idioma_actiu==1) {
		idioma="cateng";
	}
	else {
		idioma="engcat";
	}

	if (!validar_paraula(buscar) || buscar.length()==0) {
		actiu->setText(tr("<CENTER><FONT COLOR='red'>You have to write a word. The word has to start with a letter.</FONT></CENTER>"));
		actiu->show();
		definicio->setText(""); //not valid input
	}
	else {  //TODO: clean this crazy if-else!

	//paraula->setText(buscar);
	lletra=lletra_buscar(buscar);
	QFile xmlFile(directori_usuari+"/"+idioma+"/"+lletra+".dic");
	if (!xmlFile.exists()) {
		actiu->setText("<CENTER><FONT COLOR='red'>Cannot open Dictionary file. Check configuration directory and permission</FONT></CENTER>");
		actiu->show();
	}
	else{
		if (pdebug) printf("Directori utilitzat: %s\n",(const char*)directori_usuari);
		if (pdebug) printf("Obro fitxer: %c\n",lletra);
		if (pdebug) printf("Idioma actiu: %s\n",(const char*)idioma);
		
		QXmlInputSource source( &xmlFile );
		QXmlSimpleReader reader;
		reader.setFeature("http://trolltech.com/xml/features/report-whitespace-only-CharData",FALSE);	//if we don't use it, we get more entries because spaces...
		reader.setContentHandler( &handler );

		//printf("ACTUAR SOBRE: %s\n",(const char*)buscar_orig);
		//printf("Buscar arrels:");
		//arrels_cat(buscar);

		handler.setParaula(buscar_orig);

		reader.parse(source);

		WordData d=handler.getWordData();

		definicio->setText("");
		if (showList==0) {
			definicio->show();
			llistat->hide();
			//buscar == 0: we show what we have found
			for (int i=0;i<d.getNum();i++) {
				definicio->setText(definicio->text()+d.getEntry(i)+"<BR>");
			}
		}
		if (d.getNum()==0 || showList==1) {
			//No word found or buscar == 1: we show the list
			//definicio->setText(tr("<FONT COLOR='red'>Word not found</FONT>"));
			definicio->setText("");
			definicio->hide();
			llistat->show();
			loadList(handler);
			searched=buscar_orig;
			selectItem();
			if (d.getNum()==0) {
				actiu->setText(tr("<CENTER><FONT COLOR=\"red\">Exact match not found</FONT></CENTER>"));
				actiu->show();
				//report->setText(tr("Report \""+buscar+"\" as new word"));
				report->setText(tr("Report as new entry"));
				report->show();
			}
		}
		if (d.getNum()>0 && showList==0) {
			report->setText(tr("Send comment(s)"));
			report->show();
		}
		paraula->selectAll();
		numberFound=d.getNum();
	}
	}
}

void Main::cat_engf()
{
	idioma_actiu=1;
	posa_idioma();
}


void Main::eng_catf()
{
	idioma_actiu=2;
	posa_idioma();
}


void Main::copiar_definicio()
{
	portapapers->setText(paraula->text()+"<P>"+definicio->text());
	portapapers->selectAll(TRUE);
	portapapers->copy();
	//definicio->selectAll(TRUE);
	//definicio->copy();
}

void Main::obrir_about()
{
	About *c; 
	c=new About();
	c->exec();          
	delete c;
}

void Main::carrega_config(int all)
{
	QSettings qs;
	int xsize,ysize,xpos,ypos;
	int configurat;

	qs.setPath( "Dacco", "QDacco" );
	directori_usuari = qs.readEntry( "/dacco/directori", "" );
	
	configurat = qs.readNumEntry("/dacco/configurat",0);

	if (configurat==0) {
		//We will open the same settings file with read and then write mode
		//be careful!
		QMessageBox::information( this, "QDacco",
	    tr("There is no configuration. A configuration dialog will now open"));	
		obrir_configuracio();		
		carrega_config(1); //correct but little recursive rare call
	}
	else {
		idioma_actiu = qs.readNumEntry("/dacco/diccionari_per_defecte",1);

		if (pdebug) printf("Carregar config\n");
		if (pdebug) printf("Directori : %s\n",(const char*)directori_usuari);
		if (pdebug) printf("Idioma actiu: %d\n",idioma_actiu);

		posa_idioma();
		
		if (all==1) {
			xpos = qs.readNumEntry("/dacco/xpos",0);
			ypos = qs.readNumEntry("/dacco/ypos",0);
			xsize = qs.readNumEntry("/dacco/xsize",234);
			ysize = qs.readNumEntry("/dacco/ysize",355);
	
			this->move(xpos,ypos);
		
			//resize( QSize(xsize, ysize).expandedTo(minimumSizeHint()) );
			resize(QSize(xsize,ysize));
		}
	}
}


void Main::obrir_configuracio()
{
	Configure *c; 
	c=new Configure();
	c->carregar_config();
	c->exec();          
	delete c;

	//carrega_config(0);
	carrega_config(0);
}

void Main::init() {
	setMinimumSize( QSize( 251, 260) );
	carrega_config(1);
	portapapers->hide();
	posarApunt(1);
}

void Main::changeDictionaryf() {
	//carrega_config(1);

	if (idioma_actiu==1) {
		idioma_actiu=2;
	}
	else {
		idioma_actiu=1;
	}
	posa_idioma();
	posarApunt(0);
}

int Main::validar_paraula(QString &q) {
	QChar first;
	//We transform the word to not-capital
	//We check that first letter is a letter
	//We delete space before word

	q=q.lower();
	q=q.stripWhiteSpace();
	
	
	if (pdebug) printf("Validar_paraula: _%s_\n",(const char*)q);
	first=q.at(0);
	return (first.isLetter());
}


void Main::enganxar() {
	paraula->setText("");
	paraula->paste();
}


void Main::destroy() {
	QSettings settings;
	QSize q;

	settings.setPath( "Dacco", "QDacco" );
	
	settings.writeEntry("/Dacco/xpos",this->x());
	settings.writeEntry("/Dacco/ypos",this->y());

	q=this->size();

	settings.writeEntry("/Dacco/xsize",q.width());
	settings.writeEntry("/Dacco/ysize",q.height());

}

char Main::lletra_buscar(QString q) {
	QChar a;

	if (q.at(0)=='' || q.at(0)=='' || q.at(0)=='' || q.at(0)=='') return 'a';
	if (q.at(0)=='' || q.at(0)=='' || q.at(0)=='' || q.at(0)=='') return 'e';
	if (q.at(0)==''  || q.at(0)=='' || q.at(0)=='' || q.at(0)=='') return 'i';
	if (q.at(0)=='' || q.at(0)=='' || q.at(0)=='' || q.at(0)=='') return 'o';
	if (q.at(0)=='' || q.at(0)=='' || q.at(0)=='' || q.at(0)=='') return 'u';

	if (q.at(0)=='') return 'c';

	a=q.at(0);
	
	return ((char)a);
}


void Main::posa_idioma() {
	posarApunt(0);

	if (idioma_actiu==1) {
		//idioma="cateng";
		//actiu->setText(tr("Catalan -> English"));
		cat_eng->setOn(TRUE);
		eng_cat->setOn(FALSE);
	}
	else {
		//idioma="engcat";
		//actiu->setText(tr("English -> Catalan"));
		eng_cat->setOn(TRUE);
		cat_eng->setOn(FALSE);
	}
}

//Unusued function
void Main::arrels_cat(QString q) {
	QString arrels[2];
	int ll=q.length();
	arrels[0]="";
	arrels[1]="";

	if (q.right(4)=="ques") {
		arrels[0]=q.left(ll-4)+"ca";
		arrels[1]=q.left(ll-4)+"c";
	}

	if (q.right(3)=="des") {
		arrels[0]=q.left(ll-3)+"t";
		arrels[1]=q.left(ll-3)+"a";
	}
	
	if (q.right(2)=="es") {
		arrels[0]=q.left(ll-2)+"a";
		arrels[1]=q.left(ll-2);
	}

	if (q.right(2)=="da") {
		arrels[0]=q.left(ll-2)+"t";
	}

	if (q.right(1)=="a") {
		arrels[0]=q.left(ll-1);
	}

	printf("Arrels[0]: %s\n",(const char*)arrels[0]);
	printf("Arrels[1]: %s\n",(const char*)arrels[1]);
}

void Main::loadList(StructureParser handler) {
	while (!handler.esBuida()) {
		llistat->insertItem(handler.seguent());
		//printf("Paraula22: %s\n",(const char*)handler.seguent());
	}
}

void Main::posarParaula()
{
	paraula->setText(llistat->currentText());
	llistat->clear();
	llistat->hide();
	definicio->show();
	showList=0;
	treballaBuscar();
}

void Main::posarApunt(int all)
{
	llistat->clear();
	llistat->hide();
	definicio->show();

	if (all) {
		paraula->setText("");
	}
	definicio->setText(""); 
	
	actiu->hide();
	actiu->setText("");
	report->hide();
	paraula->selectAll();
	paraula->setFocus();
}


void Main::doList()
{
	showList=1;
	treballaBuscar();
}

void Main::selectItem()
{
	int i;
	int surt=0;

	for (i=0;i<(int)llistat->count() && !surt;i++) {
		if (llistat->text(i).compare(searched)==0) {
			llistat->setSelected(i,TRUE);
			surt=1;
		}
	}
}


void Main::layout7_destroyed( QObject * )
{

}


void Main::to_report()
{
	QSettings qs;
	QString nom,email;
	int okay;
	
	QString userWord,userTranslations,userExamples,userNotes;


	qs.setPath("Dacco","QDacco");
	nom = qs.readEntry("/dacco/name","");
	email = qs.readEntry("/dacco/email","");
		
	http = new HTTPConnection(this);
	

	if (numberFound==0) {
		//We just send a new word
		http->sendNewWord(searched,nom,email,idioma_actiu);
		actiu->setText(tr("<CENTER>Sending...</CENTER>"));	
		actiu->show();
		report->hide();
	}
	else {
		//We send a suggestion of word...

		suggeriment *s; 
		s=new suggeriment();
		//c->carregar_config();
		s->setWord(paraula->text());
		s->exec();    
		s->getOkay(okay);

		if (okay==1) {
			s->getUserWord(userWord);
			s->getUserTranslations(userTranslations);
			s->getUserExamples(userExamples);
			s->getUserNotes(userNotes);

			if (userTranslations.length()==0 && 
				userExamples.length()==0 &&
				userNotes.length()==0) {
				actiu->setText(tr("<CENTER><FONT COLOR=\"red\">You must type something</FONT></CENTER>"));
				actiu->show();
			}
			else {
				http->sendSuggestion(userWord,userTranslations,userExamples,userNotes,nom,email,idioma_actiu);
				
				actiu->setText(tr("<CENTER>Sending...</CENTER>"));	
				actiu->show();
				report->hide();
			}
		}
		else {
			actiu->setText(tr("<CENTER>Action cancelled</CENTER>"));
			actiu->show();
		}

		delete s;
	}
}


void Main::canviarActiu(int a, bool b)
{
	if ((*http->getStateError()).compare("")==0) {
		actiu->setText(tr("<CENTER>Correctly sent!</CENTER>"));
	}
	else {
		actiu->setText(tr("<CENTER><FONT COLOR=\"red\">Problem sending:</FONT> ")+*http->getStateError()+"</FONT></CENTER>");
	}
	actiu->show();

	delete http;
}


void Main::statusBar()
{

}
