#include <stdio.h>
#include "worddata.h"

/*	Carles Pina i Estany <carles@pinux.info> 2005
	GPL Licensed
*/

void WordData::setPdebug(int i) {
	pdebug_=i;
}

WordData::WordData() {
	num=0;
}

void WordData::putDefinition(QString q) {
	if (num<MAX_WORDS) {
		definition[num]=q;
	}
	else {
		printf("ERROR: we don't save definition because we have lot of");
	}
}

void WordData::putGender(QString q) {
	if (num<MAX_WORDS) {
		gender[num]=q;
	}
	else {
		printf("ERROR: we don't save gender because we have lot of");
	}

}

void WordData::putCatexamp(QString q) {
	if (num<MAX_WORDS) {
		catexamp[num]=q;
	}
	else {
		printf("ERROR: we don't save catexamp because we have lot of");
	}
}

void WordData::putEngexamp(QString q) {
	if (num<MAX_WORDS) {
		engexamp[num]=q;
	}
	else {
		printf("ERROR: we don't save engexamp because we have lot of");
	}
}

void WordData::putTipus(QString q) {
	if (num<MAX_WORDS) {
		tipus[num]=q;
	}
	else {
		if (pdebug_) printf("ERROR: we don't save type because we have lot of");
	}

}

void WordData::putExample(QString q) {
	if (num<MAX_WORDS) {
		example[num]+=q+"<P>";
	}
	else {
		printf("ERROR: we don't save example because we have lot of");
	}

}

//---------------end put

QString WordData::getDefinition(int i) {
	if (pdebug_) printf("getDefinition %d %s\n",i,(const char*)definition[i]);
	return (definition[i]);
}

QString WordData::getGender(int i) {
	return(gender[i]);
}

QString WordData::getCatexamp(int i) {
	if (pdebug_) printf("getCatexamp %d %s\n",i,(const char*)catexamp[i]);
	return (catexamp[i]);
}

QString WordData::getEngexamp(int i) {
	if (pdebug_) printf("getEngexamp %d %s\n",i,(const char*)engexamp[i]);
	return (engexamp[i]);
}

QString WordData::getTipus(int i) {
	return (tipus[i]);
}

QString WordData::getExample(int i) {
	return (example[i]);
}

//-----------eng get

int WordData::getNum() {
	return num;
}

void WordData::incNum() {
	if (num<MAX_WORDS) {
		num++;
	}
}

QString WordData::getEntry(int i) {
	QString ret;
	QString gender;

	if (!(getGender(i)).isNull()) {
		gender=" ("+getGender(i)+")";
	}
	ret="<I>"+getTipus(i)+gender+"</I><BR>";
	ret+=getDefinition(i);

	if (!(getCatexamp(i)).isNull()) {
		ret+="<BR>"+getCatexamp(i);
	}

	if (!(getEngexamp(i)).isNull()) {
		ret+="<BR>"+getEngexamp(i);
	}

	if (!(getExample(i)).isNull()) {
		ret+="<BR>"+getExample(i);
	}

	return ret;
}
