/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the accessibility project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "accessibleactionadaptor.h"
#include "accessibleobject.h"

#include <qaction.h>
#include <qaccessible.h>

AccessibleActionAdaptor::AccessibleActionAdaptor(QObject *parent)
    : QDBusAbstractAdaptor(parent)
{
    setAutoRelaySignals(true);
}

AccessibleActionAdaptor::~AccessibleActionAdaptor()
{
}

static inline QAccessibleInterface *accessibleInterface(QObject *parent)
{
    return static_cast<AccessibleObject *>(parent)->accessibleInterface();
}

int AccessibleActionAdaptor::nActions()
{
    return accessibleInterface(parent())->userActionCount(0);
}

QString AccessibleActionAdaptor::description(int actionIndex)
{
    // handle method call org.freedesktop.accessibleValue.description
    return accessibleInterface(parent())->actionText(actionIndex + 1, QAccessible::Description, 0);
}

bool AccessibleActionAdaptor::doAction(int actionIndex)
{
    // handle method call org.freedesktop.accessibleValue.doAction
    return accessibleInterface(parent())->doAction(actionIndex + 1, 0);
}

QStringList AccessibleActionAdaptor::keyBinding(int actionIndex)
{
    // handle method call org.freedesktop.accessibleValue.keyBinding
    return QStringList(accessibleInterface(parent())->actionText(actionIndex + 1,
                QAccessible::Accelerator, 0));
}

QString AccessibleActionAdaptor::name(int actionIndex)
{
    return accessibleInterface(parent())->actionText(actionIndex + 1, QAccessible::Name, 0);
}

QString AccessibleActionAdaptor::localizedName(int actionIndex)
{
    // TODO - localize them. The text is already localized, so currently there is no
    // unlocalized action name support
    return name(actionIndex);
}

