/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the <your project> project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef ACCESSIBLEAPPLICATION_H
#define ACCESSIBLEAPPLICATION_H

#include "accessibleobject.h"

class QDBusMessage;

class AccessibleApplication: public AccessibleObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.accessibleApplication")

public:
    AccessibleApplication();
    void exportAll(AccessibleObject *obj = 0);

public slots:
    void initAccessibility();
    QString toolkitName() const;
    QString toolkitVersion() const;
    QString appName() const;
    QString appVersion() const;
    QString hitTest(int x, int y);
    void pingReceived(const QDBusMessage &sender);

signals:
    void focusChanged(const QString &);
    void objectShown(const QDBusObjectPath &);

protected:
    bool eventFilter(QObject *obj, QEvent *event);
    QObjectList clientChildren() const;

private slots:
    void focusChanged(QWidget *old, QWidget *now);
};

#endif
