Copyright (C) 2007 Sebastien Guillot

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License

as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of

MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software

Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include "MainForm.h"
#include <QtGui>
#include <QtNetwork>
#include <QHttp>
#include "ui_FormId.h"
#include "ui_FormResult.h"
#include "ui_FormCarnet.h"
#include "ui_FormApropos.h"

QString VERSION="0.1";

/* Constructeur de la classe MainForm */
MainForm::MainForm()
{
	//construit la fiche
	setupUi(this);
	bar =new QProgressBar();
	bar->setGeometry(0,0,100,16);
	bar->setMaximumSize(100,16);
	bar->setTextVisible(false);
	AnnulEnvoi=new QPushButton (QIcon(QString::fromUtf8(":/images/images/winux/stop_16.png")),"Annuler");
	AnnulEnvoi->setGeometry(0,0,AnnulEnvoi->width(),16);
	AnnulEnvoi->setMaximumSize(AnnulEnvoi->width(),16);
	statBar->addPermanentWidget(bar);
	statBar->addPermanentWidget(AnnulEnvoi);
	AnnulEnvoi->setVisible(false);
	connect(AnnulEnvoi,SIGNAL( clicked() ),this,SLOT(AnnulerEnvoi()));
	setWindowTitle("qFreeFax "+VERSION);
	#ifdef Q_OS_MAC
	actionQuitter->setIcon(QIcon(QString::fromUtf8(":/images/images/mac/stop_32.png")));
	actionChanger_les_Identifiants->setIcon(QIcon(QString::fromUtf8(":/images/images/mac/properties_document_32.png")));
	actionEffacer_les_identifiants->setIcon(QIcon(QString::fromUtf8(":/images/images/mac/delete_32.png")));
	actionEnvoyer_le_Fax->setIcon(QIcon(QString::fromUtf8(":/images/images/mac/mail_b_32.png")));
	actionRafraichir_l_image->setIcon(QIcon(QString::fromUtf8(":/images/images/mac/refresh_document_32.png")));
	actionS_lectionner_le_fichier_envoyer->setIcon(QIcon(QString::fromUtf8(":/images/images/mac/search_32.png")));
	actionOuvrir_le_carnet_d_adresse->setIcon(QIcon(QString::fromUtf8(":/images/images/mac/favorites_32.png")));
	setUnifiedTitleAndToolBarOnMac(true);
	// ajoute un alias dans Bibliothque/PDF Services 
	QProcess process;
	if (!QFile::exists("/Library/PDF Services/Envoyer avec qFreeFax")){
		process.startDetached("ln", QStringList() << tr("%1/qFreeFax.app/Contents/MacOS/qFreeFax").arg(QDir::currentPath()) << "/Library/PDF Services/Envoyer avec qFreeFax");
	
	}	

	#endif

		

	QRect rect(0, 0, this->width(), this->height());
    rect.moveCenter(QApplication::desktop()->screenGeometry(QApplication::desktop()->primaryScreen()).center());
    this->setGeometry(rect);

	// verification des identifiants
	QSettings settings("qFreeFaxCorp", "qFreeFax");
	if (!settings.contains("id")){
		ChangerIdentifants();
	}
	else{
		id=settings.value("id").toString();
		pass=settings.value("pass").toString();
	}
	
	id_session="";
	//chargement de l'image
	AfficheImage();
	
	setAcceptDrops(true);
	
	LectureCarnet();
	

	//vrification des mises  jour
	if (!settings.contains("majAuto")){
		settings.setValue("majAuto",true);
	}
	if (settings.value("majAuto").toBool()){
		actionRecherche_automatique_des_mises_jour->setChecked(true);
		verif_maj();
	}
	
}

void MainForm::on_actionModifier_les_informations_de_votre_ligne_fax_triggered()
{
	QDesktopServices::openUrl(tr("http://adsl.free.fr/admin/tel/chfax_01.pl??id=%1&idt=%2").arg(id_session,idt));
}

void MainForm::on_actionRecherche_automatique_des_mises_jour_triggered()
{
	QSettings settings("qFreeFaxCorp", "qFreeFax");
	if(!actionRecherche_automatique_des_mises_jour->isChecked()){
			actionRecherche_automatique_des_mises_jour->setChecked(false);
			settings.setValue("majAuto",false);
			
	}
	else{
			actionRecherche_automatique_des_mises_jour->setChecked(true);
			settings.setValue("majAuto",true);
	}
}

void MainForm::on_actionQuitter_triggered()
{
	close();
}

void MainForm::on_actionChanger_les_Identifiants_triggered()
{
	ChangerIdentifants();
}

void MainForm::on_actionEffacer_les_identifiants_triggered()
{
	QSettings settings("qFreeFaxCorp", "qFreeFax");
	settings.remove("");
	QMessageBox::information(this, tr("qFreeFax"),
                          tr("Vos identifiants ont ts effacs."),
                          QMessageBox::Ok); 
}

void MainForm::on_BtnRafraichir_clicked()
{
	AfficheImage();
}

void MainForm::on_BtnParcourir_clicked()
{
	QString nomfic=QFileDialog::getOpenFileName(this,tr("Slectionner le Fichier pdf  envoyer"), QDir::homePath(), tr("Fichier PDF (*.pdf)"));
	setNomfic(nomfic);
}

void MainForm::on_actionA_propos_de_triggered()
{
	QDialog a(this);
	Ui::FormApropos ui;

	ui.setupUi(&a);
	ui.lblVersion->setText("Version "+VERSION);
	#ifdef Q_OS_MAC
	ui.lblTapp_3->setTextFormat(ui.lblTapp_3.text().replace("8.25","13");
	#endif
	a.exec();
}
void MainForm::on_BtnCarnet_clicked()
{
	QDialog a(this);
	Ui::FormCarnet ui;

	ui.setupUi(&a);
	//a.setWindowFlags(Qt::Dialog | Qt::WindowSystemMenuHint);
	int intLargeurFenetre = a.frameGeometry().width();
	int intHauteurFenetre = a.frameGeometry().height();
	a.setGeometry((int)(QApplication::desktop()->width()/QApplication::desktop()->numScreens() - intLargeurFenetre) / 2, (int)(QApplication::desktop()->height() - intHauteurFenetre ) / 2, intLargeurFenetre, intHauteurFenetre);
	
	//remplissage du tableau avec le contenu du carnet
		
	QDomElement docElem = AdBook.documentElement();

	QDomNode n = docElem.firstChild();
	int lig=0;
	while(!n.isNull()) {
	 QDomElement e = n.toElement(); 
	 if(!e.isNull()) {
		/*QDomElement nom = e.firstChildElement("nom");
		QDomElement numero = e.firstChildElement("numero");
		*/
		ui.twCarnet->setRowCount(lig+1);
		//QTableWidgetItem *newNom = new QTableWidgetItem(nom.text().trimmed());
		QTableWidgetItem *newNom = new QTableWidgetItem(e.attribute("nom","Pas de Nom"));
		
		ui.twCarnet->setItem(lig, 0, newNom); 
		//QTableWidgetItem *newNumero = new QTableWidgetItem(numero.text().trimmed());
		QTableWidgetItem *newNumero = new QTableWidgetItem(e.attribute("numero",""));
		ui.twCarnet->setItem(lig, 1, newNumero);
		lig++; 
	 }
	 n = n.nextSibling();
	}
	
	ui.twCarnet->setColumnWidth ( 0, 250);
	ui.twCarnet->horizontalHeader()->setStretchLastSection( true );
	twBook=ui.twCarnet;
	leNom=ui.leNom;
	leNumero=ui.leNumero;
	connect(ui.twCarnet,SIGNAL( cellChanged ( int , int ) ),this,SLOT(cellChanged ( int , int )));
	connect(ui.BtnAjouter,SIGNAL( clicked() ),this,SLOT(AjouterDestinataire()));
	
	if (a.exec() == QDialog::Accepted) {
		QTableWidgetItem *item;
		//QMessageBox::information(this, tr("qFreeFax"),tr("%1").arg(twBook->currentRow());
		
		item=twBook->item(twBook->currentRow(),1);
		if (item) leDest->setText(item->text());
		
	}
}

void MainForm::AfficheImage()
{
	QString messerr;
	QHttp httpim("adsl.free.fr",80);
	
	if(getid(&id_session,&idt,&messerr)){
		bar->setValue(0);
		bar->setVisible(true);
		lblImage->setText("Chargement en cours....");		
		connect(&httpim, SIGNAL(done(bool)), this, SLOT(finClientHttp(bool)));
		connect(&httpim, SIGNAL(dataSendProgress(int,int)), this, SLOT(dataSendProgress(int,int))); // au cas o le chargement serait long.
		
		QHttpRequestHeader header("GET", tr("/admin/tel/captcha.pl?id_client=%1").arg(id_session));
		header.setValue("Host", "adsl.free.fr");
		
		QByteArray searchstring;
		QBuffer *response;
		response = new QBuffer();
		endRequest = false;
		errorRequest = false;
		timeout = false;
		bool ok=false;
		
		if (httpim.request(header, searchstring, response)) {
			timer.start(10000, this);
			while (!endRequest) {
				QCoreApplication::processEvents();
			}
			timer.stop();
			
			if (!timeout) {
				if (!errorRequest) {
					if (httpim.lastResponse().statusCode() == 200) {
						ok=true;
						QPixmap *pix=new QPixmap();
						
						if(pix->loadFromData(response->data())){
							lblImage->setPixmap(*pix);

						}
						else{
							lblImage->setText("Erreur de conversion");
						}
						
										
					}
					else{
						QMessageBox::information(this, tr("qFreeFax"),httpim.lastResponse().toString(),QMessageBox::Ok);
						
					}
				}
			}
			if (!ok) lblImage->setText("Erreur de chargement.");
			statBar->clearMessage();
		}
	}
	else{
		lblImage->setText(messerr);
	}
	timerReload.start(100000, this);
	bar->setVisible(false);
}



bool MainForm::ChangerIdentifants() {
	QSettings settings("qFreeFaxCorp", "qFreeFax");
	QDialog a(this);
	Ui::FormId ui;

	ui.setupUi(&a);
	//a.setWindowFlags(Qt::Dialog | Qt::WindowSystemMenuHint);
	int intLargeurFenetre = a.frameGeometry().width();
	int intHauteurFenetre = a.frameGeometry().height();
	a.setGeometry((int)(QApplication::desktop()->width()/QApplication::desktop()->numScreens() - intLargeurFenetre) / 2, (int)(QApplication::desktop()->height() - intHauteurFenetre ) / 2, intLargeurFenetre, intHauteurFenetre);
	
	ui.id->setText(id);
	ui.pass->setText(pass);
	if (a.exec() == QDialog::Accepted) {
		
		if (ui.cbSave->checkState ()==Qt::Checked){
			settings.setValue("id", ui.id->text());
			settings.setValue("pass", ui.pass->text());
		}
		id=ui.id->text();
		pass=ui.pass->text();
		return true;
    }
	else {
		return false;
	}
	a.close();
}


bool MainForm::getid(QString *id_session,QString *idt,QString *ErrorId){
	QBuffer *response;
	QRegExp rx("id=([A-Z|a-z|0-9|_|.]{1,})&");
	QRegExp rx2("idt=([A-Z|a-z|0-9|_|.]{1,})\r");
	bool erreurlog=false;
	
	//rcupration du lien
	statBar->clearMessage ();
	statBar->showMessage("Connection  subscribe.free.fr/login/login.pl...");
	QHttp loginpage("subscribe.free.fr",80);
	
	connect(&loginpage, SIGNAL(done(bool)), this, SLOT(finClientHttp(bool)));
	
	QHttpRequestHeader headerlog("POST", "/login/login.pl");
	headerlog.setValue("Host", "subscribe.free.fr");
	headerlog.setContentType("application/x-www-form-urlencoded");
	
	QString ident=id;
	
	if (!ident.contains("@freeadsl")) ident+="@freeadsl";
	
	QUrl login2(ident);
	QUrl pass2(pass);
	QByteArray searchstring2;
	searchstring2.append(tr("login="));
	searchstring2.append(login2.toEncoded());
	searchstring2.append(tr("&pass="));
	searchstring2.append(pass2.toEncoded());

	response = new QBuffer();
	endRequest = false;
	errorRequest = false;
	timeout = false;
	if (loginpage.request(headerlog, searchstring2, response)) {
		timer.start(40000, this);
		while (!endRequest) {
			QCoreApplication::processEvents();
		}
		timer.stop();
		if (!timeout) {
			if (!errorRequest) {
				
				if (loginpage.lastResponse().toString().contains("error")){
					erreurlog=true;	
					*ErrorId=QString("Erreur. Identifiants incorrects.");											
				}
				else{
							
					rx.indexIn(loginpage.lastResponse().toString());
					rx2.indexIn(loginpage.lastResponse().toString());
					*id_session=rx.cap(1);
					*idt=rx2.cap(1);
					erreurlog=false;
				}						
			}
			else {
					erreurlog=true;
	 				*ErrorId=loginpage.errorString();
			}
		}
		else{
			erreurlog=true;	
			*ErrorId=QString("Erreur. Timeout de Connexion.");
		}
	}
	loginpage.close();
	loginpage.disconnect();
	statBar->clearMessage ();
	
	statBar->showMessage("Connection  adsl.free.fr/admin/tel/sendfax.pl...");
	QHttp sendfax("adsl.free.fr",80);

	connect(&sendfax, SIGNAL(done(bool)), this, SLOT(finClientHttp(bool)));
	
	QHttpRequestHeader header2("GET", tr("/admin/tel/sendfax.pl?id=%1&idt=%2").arg(*id_session,*idt));
	header2.setValue("Host", "adsl.free.fr");
	QByteArray searchstring;
	response = new QBuffer();
	endRequest = false;
	errorRequest = false;
	timeout = false;
	if (sendfax.request(header2, searchstring, response)) {
		timer.start(10000, this);
		while (!endRequest) {
			QCoreApplication::processEvents();
		}
		timer.stop();
		if (!timeout) {
			if (!errorRequest) {
				if (sendfax.lastResponse().statusCode() == 200) {
					//QMessageBox::information(this, tr("qFreeFax"),response->data());
				}
			}
		}
	}
	statBar->clearMessage ();

	if (erreurlog) return false;
	else return true;

}

/* Evnement de Fin de Requte Http*/
void MainForm::finClientHttp(bool error) {
	endRequest = true;
	errorRequest = error;
}

void MainForm::timerEvent(QTimerEvent *event) {
	if (event->timerId()==timer.timerId()){

		timeout = true;
		endRequest = true;
	}
	if  (event->timerId()==timerReload.timerId()){
		AfficheImage();
		leCap->setText("");
	}
}

void MainForm::dataSendProgress ( int done, int total ){

	statBar->clearMessage ();
	statBar->showMessage(tr("Tlchargement %1 sur %2 octets...").arg(QString::number(done),QString::number(total)));
	bar->setMinimum(0);
	bar->setMaximum(total);
	bar->setValue(done);

	

}

void MainForm::dataUploadProgress ( int done, int total ){

	statBar->clearMessage ();
	statBar->showMessage(tr("Envoi %1 sur %2 octets (%3%)...").arg(QString::number(done),QString::number(total),QString::number((done*100)/total)));
	bar->setMinimum(0);
	bar->setMaximum(total);
	bar->setValue(done);

}

void MainForm::dragEnterEvent(QDragEnterEvent *event)
 {
     const QMimeData *mimeData = event->mimeData();
	 if (mimeData->hasUrls()) {
         QList<QUrl> urlList = mimeData->urls();
         QString text;
		 if(urlList.at(0).path().endsWith(".pdf")) event->acceptProposedAction();
		 
	 }
     
     
 }

 void MainForm::dragMoveEvent(QDragMoveEvent *event)
 {
     const QMimeData *mimeData = event->mimeData();
	 if (mimeData->hasUrls()) {
         QList<QUrl> urlList = mimeData->urls();
         QString text;
		 if(urlList.at(0).path().endsWith(".pdf")) event->acceptProposedAction();
		 
	 }
 }

 void MainForm::dropEvent(QDropEvent *event)
 {
     
	 const QMimeData *mimeData = event->mimeData();
	 if (mimeData->hasUrls()) {
         QList<QUrl> urlList = mimeData->urls();
         QString text;
         if(urlList.at(0).path().endsWith(".pdf")) setNomfic(urlList.at(0).path()); //ne prends que le premier fichier
	 }
     
     event->acceptProposedAction();
 }

 void MainForm::dragLeaveEvent(QDragLeaveEvent *event)
 {
     //clear();
     event->accept();
 }

 void MainForm::setNomfic(QString Nomfic)
 {
	#if defined(Q_OS_WIN32)
		Nomfic.replace("/","\\");
		if (Nomfic.startsWith("\\")) Nomfic.remove(0,1);
	#endif
	leNomFic->setText(Nomfic); 	
 }

void MainForm::on_btnEnvoyer_clicked()
{
	QBuffer *response;
	QFileInfo path(leNomFic->text());
    QString fileName1 = path.fileName();
    QFile *userfile = new QFile(leNomFic->text());
    timerReload.stop();
	
	if (leDest->text()==""){
		QMessageBox::information(this, tr("qFreeFax"),tr("Vous devez entrer un destinataire."));
		leDest->setFocus();
		return;
	}
	if (leCap->text()==""){
		QMessageBox::information(this, tr("qFreeFax"),tr("Vous devez entrer le nombre de l'image."));
		leCap->setFocus();
		return;
	}

	if ( !userfile->open(QIODevice::ReadOnly) )
    {
        QMessageBox::information(this, tr("qFreeFax"),
                                 tr("Impossible d'ouvrir le fichier %1: %2.")
                                 .arg(leNomFic->text()).arg(userfile->errorString()));
		return;
                                 
    }
    
    QHttpRequestHeader header("POST", tr("/admin/tel/send_fax_valid.pl"), 1, 1);
    header.setValue("Host", "adsl.free.fr");
    header.setValue("Content-Type", "multipart/form-data; boundary=--------051207130240468");
    header.setValue("Cache-Control", "no-cache");
    header.setValue("Accept","*/*");
    
    QByteArray byt(leNomFic->text().toUtf8());
    QByteArray bytes;
    bytes.append("----------051207130240468\r\n");
    bytes.append("content-disposition: ");
    bytes.append("form-data; name=\"dest\"\r\n");
    bytes.append("\r\n");
    bytes.append(leDest->text());
	bytes.append("\r\n");
	bytes.append("----------051207130240468\r\n");
    bytes.append("content-disposition: ");
    bytes.append("form-data; name=\"masque\"\r\n");
    bytes.append("\r\n");
	if( rbOui->isChecked()) bytes.append("Y\r\n");
	else bytes.append("N\r\n");
	bytes.append("----------051207130240468\r\n");
    bytes.append("content-disposition: ");
    bytes.append("form-data; name=\"cap\"\r\n");
    bytes.append("\r\n");
	bytes.append(leCap->text());
	bytes.append("\r\n");
    bytes.append("----------051207130240468\r\n");
    bytes.append("content-disposition: ");
    bytes.append("form-data; name=\"uploaded_file\"; filename=\"" + byt+ "\"\r\n");
	bytes.append("Content-Transfer-Encoding: binary\r\n");
    bytes.append("\r\n");
    bytes.append(userfile->readAll());
    userfile->close(); // the file is opened earlier in the code
    bytes.append("\r\n");
	bytes.append("----------051207130240468\r\n");
    bytes.append("content-disposition: ");
    bytes.append("form-data; name=\"id\"\r\n");
    bytes.append("\r\n");
    bytes.append(id_session);
	bytes.append("\r\n");
	bytes.append("----------051207130240468\r\n");
    bytes.append("content-disposition: ");
    bytes.append("form-data; name=\"idt\"\r\n");
    bytes.append("\r\n");
    bytes.append(idt);
	bytes.append("\r\n");
    bytes.append("----------051207130240468--");
    bytes.append("\r\n");
	int contentLength = bytes.length();
    header.setContentLength(contentLength);
    
	
	statBar->showMessage("Envoi en cours...");		
	connect(&http, SIGNAL(done(bool)), this, SLOT(finClientHttp(bool)));
	connect(&http, SIGNAL(dataSendProgress(int,int)), this, SLOT(dataUploadProgress(int,int))); // au cas o l'envoi serait long.
	connect(&http, SIGNAL(requestFinished (int,bool)), this, SLOT(requestFinished (int,bool))); 
	toggleControls(true);
	response = new QBuffer();
	endRequest = false;
	errorRequest = false; 
	EnvoiAnnule=false;
    http.setHost("adsl.free.fr");

    AnnulEnvoi->setVisible(true);
    bar->setValue(0);
	bar->setVisible(true);
	if (http.request(header, bytes, response)) {
		timer.start(1200000, this);
		while (!endRequest) {
			QCoreApplication::processEvents();
		}
		timer.stop();
		if (!timeout) {
			if (!errorRequest) {
				if (http.lastResponse().statusCode() == 200) {
						//QMessageBox::information(this, tr("qFreeFax"),http.lastResponse().toString());
						QRegExp rx("<form method=\"POST\" action=\"send_fax_valid.pl\" enctype=\"application/x-www-form-urlencoded\">(.*)</form>");
						rx.indexIn(response->data());
						//QMessageBox::information(this, tr("qFreeFax"),rx.cap(1));
						QDialog a(this);
						Ui::FormResult ui;

						ui.setupUi(&a);
						//a.setWindowFlags(Qt::Dialog | Qt::WindowSystemMenuHint);
						int intLargeurFenetre = a.frameGeometry().width();
						int intHauteurFenetre = a.frameGeometry().height();
						
						ui.lblResult->setText(rx.cap(1));
						ui.lblResult->adjustSize();
						a.adjustSize();
						a.setGeometry((int)(QApplication::desktop()->width()/QApplication::desktop()->numScreens() - intLargeurFenetre) / 2, (int)(QApplication::desktop()->height() - intHauteurFenetre ) / 2, intLargeurFenetre, intHauteurFenetre);
						
						a.exec();
						a.close();
						
				}
				else{
					//QMessageBox::information(this, tr("qFreeFax"),http.lastResponse().toString());
					QMessageBox::information(this, tr("qFreeFax"),tr("Une Erreur est survenue lors de l'envoi des Informations"));
					
				}
				
			}
		}
	}
	if(EnvoiAnnule) QMessageBox::critical(NULL, tr("Envoi Annul"), tr("L'envoi du Fax a t interrompu."));
	AnnulEnvoi->setVisible(false);
	bar->setVisible(false);
	statBar->clearMessage();
	AfficheImage();
	leCap->setText("");
	toggleControls(false);
}

void MainForm::LectureCarnet()
{
	
	
	QFile fcarnet(QDir::homePath() + "/qFreeFaxAddressBook.xml");	
	
	if (QFile::exists(QDir::homePath() + "/qFreeFaxAddressBook.xml")){
		if (!fcarnet.open(QIODevice::ReadOnly))
			return;
			QTextStream in(&fcarnet);
			in.setCodec("LATIN-1");
			
			if (!AdBook.setContent(in.readAll())) {
			fcarnet.close();
			return;
		 }
		 fcarnet.close();
			
	}
	else{
		QDomElement root=AdBook.createElement("AdBlock");
		AdBook.appendChild(root);
	}
	
}


void MainForm::cellChanged ( int ligne, int colonne)
{
	QTableWidgetItem *item;
	
	item=twBook->item(ligne,colonne);
	//QMessageBox::information(this, tr("qFreeFax"),item->text());

	QDomElement docElem = AdBook.documentElement();

	QDomNode n = docElem.firstChild();
	
	for (int x=0;x<ligne;x++){
		n = n.nextSibling();
	}
	if (!n.isNull()){
		QDomElement e = n.toElement(); 
		if(!e.isNull()) {
			if (colonne==0){
				/*QDomElement nom = e.firstChildElement("nom");
				nom.setText(item->text());*/
				e.setAttribute("nom",item->text());
			
			}
			else {
				/*QDomElement numero = e.firstChildElement("numero");
				numero.setText(item->text());*/
				e.setAttribute("numero",item->text());
			}
			SauverCarnet();
			
		}
	}
	
}
void MainForm::AjouterDestinataire()
{
	if (leNom->text()==""){
		QMessageBox::information(NULL, tr("qFreeFax"),tr("Vous devez entrer un nom pour ce destinataire"));
		//leNom->setFocus();
		return;
	}
	if (leNumero->text()==""){
		QMessageBox::information(NULL, tr("qFreeFax"),tr("Vous devez entrer un numro pour ce destinataire"));
		//leNumero->setFocus();
		return;
	}
	QDomElement docElem = AdBook.documentElement();
	QDomElement newItem= AdBook.createElement("item");
	newItem.setAttribute("nom",leNom->text());
	newItem.setAttribute("numero",leNumero->text());
	docElem.appendChild(newItem);
	twBook->setRowCount(twBook->rowCount()+1);
	QTableWidgetItem *newNom = new QTableWidgetItem(leNom->text());
	twBook->setItem(twBook->rowCount()-1, 0, newNom); 
	QTableWidgetItem *newNumero = new QTableWidgetItem(leNumero->text());
	twBook->setItem(twBook->rowCount()-1, 1, newNumero);
	SauverCarnet();
	leNom->setText("");
	leNumero->setText("");


	
}
void MainForm::SauverCarnet()
{
		QFile fcarnet(QDir::homePath() + "/qFreeFaxAddressBook.xml");
		if (!fcarnet.open(QIODevice::WriteOnly)) {
			QMessageBox::critical(NULL, tr("Erreur critique"), tr("Impossible d'enregistrer le carnet d'adresse."));
			
		}
		else{
			//fcarnet.write(AdBook.toString().toLatin1().toAscii(),AdBook.toString().length());
			fcarnet.write(AdBook.toString().toLatin1());
		}
		fcarnet.close();
}

void MainForm::requestFinished ( int id, bool error )
{
	//if (error) QMessageBox::critical(NULL, tr("Envoi Annul"), tr("L'envoi du Fax a t interrompu."));
	if (error) EnvoiAnnule=true;
}

void MainForm::AnnulerEnvoi()
{
	QMessageBox msgBox(QMessageBox::Question, tr("qFreeFax"),
                        tr("Etes-vous sr de vouloir annuler l'envoi du Fax?"), 0, this);
     msgBox.addButton(tr("&Oui"), QMessageBox::AcceptRole);
     msgBox.addButton(tr("&Non"), QMessageBox::RejectRole);
     if (msgBox.exec() == QMessageBox::AcceptRole) http.abort();
	
	
	/*	
	int ret = QMessageBox::question(this, tr("qFreeFax"),
                   tr("Etes-vous sr de vouloir annuler l'enoi du Fax?"),
                   QMessageBox::Yes | QMessageBox::No); 	
	
	if (ret==QMessageBox::Yes) http.abort();
	*/

	//if(QMessageBox::query( tr("qFreeFax"), tr("Etes-vous sr de vouloir annuler l'enoi du Fax?"), tr("Oui"),tr("Non"))) http.abort();
}

void MainForm::toggleControls(bool etat)
{
	BtnQuit->setDisabled(etat);
	actionQuitter->setDisabled(etat);
	btnEnvoyer->setDisabled(etat);
	actionEnvoyer_le_Fax->setDisabled(etat);
	BtnRafraichir->setDisabled(etat);
	actionRafraichir_l_image->setDisabled(etat);

}

/* Verification des mise  jour de qFreeFax */
void MainForm::verif_maj(){
	
	QSettings settings("qFreeFaxCorp", "qFreeFax");
	QUrl urlfp("http://qfreefax.sourceforge.net/version.xml");
		
	QHttp aideurl(urlfp.host(),80);
			
	connect(&aideurl, SIGNAL(done(bool)), this, SLOT(finClientHttp(bool)));
	
	QHttpRequestHeader header("GET", urlfp.path());
	header.setValue("Host", urlfp.host());
	
	QByteArray searchstring;
	QBuffer *response;
	response = new QBuffer();
	endRequest = false;
	errorRequest = false;
	timeout = false;
	bool ok=false;
	
	if (aideurl.request(header, searchstring, response)) {
		timer.start(2000, this);
		while (!endRequest) {
			QCoreApplication::processEvents();
		}
		timer.stop();
		
		if (!timeout) {
			if (!errorRequest) {
				if (aideurl.lastResponse().statusCode() == 200) {
					ok=true;
					QRegExp rx("<version>(.*)</version>");
					rx.indexIn(response->data());
					QString new_version=rx.cap(1);
					statBar->clearMessage ();
					if (VERSION!=new_version){
						switch(QMessageBox::information(this, "qFreeFax",
								"Une nouvelle version est disponible\n" 
								"Souhaitez-vous consulter la page de tlchargement?",
								"&Oui",
								"&Non",
								"Ne &plus demander", 0,1 )) { 

							case 0: // OUI
								{
									QRegExp rx2("<url>(.*)</url>");
									rx2.indexIn(response->data());
									QDesktopServices::openUrl(rx2.cap(1));
								}
								break;
							case 1: // Non

								break;

							case 2: // Ne plus demander
								settings.setValue("majAuto",false);
								actionRecherche_automatique_des_mises_jour->setChecked(false);
								break;
						}
					}
				}
			}
		}
	}
	
						

}
