//
// C++ Interface: qgscustomprojectiondialog
//
// Description: 
//
//
// Author: Tim Sutton tim@linfiniti.com, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef QGSCUSTOMPROJECTIONDIALOG_H
#define QGSCUSTOMPROJECTIONDIALOG_H

#include "ui_qgscustomprojectiondialogbase.h"
class QDir;

/**
The custom projection widget is used to define the projection family, ellipsoid and paremters needed by proj4 to assemble a customised projection definition. The resulting projection will be store in an sqlite backend.

@author Tim Sutton
*/
class QgsCustomProjectionDialog : public QDialog, private Ui::QgsCustomProjectionDialogBase
{
Q_OBJECT
public:
    QgsCustomProjectionDialog(QWidget *parent = 0, Qt::WFlags fl = 0);
    ~QgsCustomProjectionDialog();
    //a recursive function to make a directory and its ancestors
public slots:    
    void on_pbnCalculate_clicked();
    void on_pbnClose_clicked();
    void on_pbnDelete_clicked();
    //
    // Database navigation controles
    //
    long getRecordCount();
    void on_pbnFirst_clicked();
    void on_pbnPrevious_clicked();
    void on_pbnNext_clicked();
    void on_pbnLast_clicked();
    void on_pbnNew_clicked();
    void on_pbnSave_clicked();

    //
    // Contol population
    //
    /* These two methods will be deprecated
    void getProjList();
    void getEllipsoidList();
    */
    QString getProjectionFamilyName(QString theProjectionFamilyAcronym);
    QString getEllipsoidName(QString theEllipsoidAcronym);
    QString getProjectionFamilyAcronym(QString theProjectionFamilyName);
    QString getEllipsoidAcronym(QString theEllipsoidName);
private: 
    QString getProjFromParameters();
    QString getEllipseFromParameters();
    
        
    QString mCurrentRecordId;
    long mCurrentRecordLong;
    //the record previous to starting an insert operation
    //so that we can return to it if the record insert is aborted
    long mLastRecordLong;
    long mRecordCountLong;
    const QString stringSQLSafe(const QString theSQL);

};

#endif
