/*
 * QCameraInterpolationTool.h
 * $Id: 
 *
 * Copyright (C) 2001 Thomas Woerner, Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */



#ifndef _QCAMERAINTERPOLATION_TOOL_H
#define _QCAMERAINTERPOLATION_TOOL_H


// Qt
///////
#include <QGLExaminerViewer.h>
#include <qdialog.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlineedit.h>

// Own
////////
#include "CCameraPathInterpolator.h"
#include "QCameraPathDrag.h"
#include "QCameraPathDropSite.h"
#include "QCameraKeyPathDrag.h"
#include "QCameraKeyPathDropSite.h"
#include "QIconOptions.h"
#include "QSceneTreeNode.h"


/** This class provides a GUI to create camera paths.
  *
  * @author Thomas Woerner, Michael Meissner, Markus Janich
  *
  * [tw] 2001/04/29 initial version
  */
class QCameraInterpolationTool : public QDialog, public QSceneTreeDrawable
{
   Q_OBJECT
    
   public:
      ////////////////////
      // PUBLIC METHODS //
      ////////////////////
    
      /** Constructs new tool (GUI). */
      QCameraInterpolationTool(QGLViewer *pQGLViewer, QWidget* parent=NULL, const char* name=NULL, 
                               bool modal=FALSE, WFlags fl=0);
      /** Destructs (default). */
      ~QCameraInterpolationTool() {}

      /** Updates the bounding box. */
      void updateBoundingBox();
    
      /** Draws the camera path into the current OpenGL context. */
      virtual void draw();

      /** Returns the interpolated camera path.
	* \par NOTE: The list returned is a full duplicate.
	*            So if you free the list make a *clear(1)-call first ! */ 
      CList<CCamera> &getCameraPath() {
	return *m_CameraList.getFullDuplicate();
      };

   signals:
      /////////////
      // SIGNALS //
      /////////////

      /** Signal redraw. */
      void sigRedraw();

      /** This signal is emitted whenever the
	* CameraPath has changed. The new path 
	* is passed with the argument. */
      void sigCameraPathChanged(const CList<CCamera> &cCameraPath);


   public slots:
      //////////////////
      // PUBLIC SLOTS //
      //////////////////

      /** Slot for load key path. */
      void sltKeyLoad();

      /** Slot for save key path. */
      void sltKeySave();

      /** Slot for save path. */
      void sltSave();

      /** Slot for save path as key path. */
      void sltShapeSave();

      /** Slot for interpolate. */
      void sltInterpolate();

      /** Slot for undo. */
      void sltUndo();

      /** Slot for show option dialog. */
      void sltShowOptions();

      /** Slot for arrow size. */
      void sltArrowSize(double);

      /** Slot for frustum size. */
      void sltFrustumSize(double);

      /** Sets the camera path. */
      void sltSetCameraPath(const CList<CCamera> &list);

      /** Sets the camera key path. */
      void sltSetCameraKeyPath(const CList<CCameraKeyPathPoint> &path);


   protected:
      ///////////////////////
      // PROTECTED METHODS //
      ///////////////////////

      /** Creates a display list for a pointer. */
      void makeArrowDispList();

      /** Creates a display list for the camera path. */
      void makePathDispList();

      /** Method to handle drag 'n drop. */
      void dragEnterEvent(QDragEnterEvent*); 
 
      /** Method to handle drag 'n drop. */
      void dragLeaveEvent(QDragLeaveEvent*) { return; }

      /** Method to handle drag 'n drop. */
      void dropEvent(QDropEvent*);  
          
   private:
      /////////////////////
      // PRIVATE METHODS //
      /////////////////////
    
      QComboBox *m_pAlgoCombo;
      QComboBox *m_pPathCombo;
      QLineEdit *m_pKeysLine;
      QLineEdit *m_pFramesLine;
      QPushButton *m_pInterpolateButton;
      QPushButton *m_pUndoButton;
      QCameraKeyPathDropSite *m_pKeyDropSite;
      QCameraPathDropSite    *m_pDropSite;

      QIconOptions *m_pOptions;

      float m_rfIconSize;
      float m_rfFrustumSize;
      GLuint m_glPathDispList;
      GLuint m_glArrowDispList;

      QGLViewer *m_pQGLViewer;

      CList<CCameraKeyPathPoint> m_KeyPathList;
      CList<CCameraKeyPathPoint> m_ShapePathList;

      // CCamera list for drop site
      CList<CCamera> m_CameraList;
};

#endif /* QINTERPOLATION_TOOL_H */
