//////////////////////////////////////////////////////////////////////////
//
//  Filename    : GLDrawable.h
//  Class       : GLDrawable
//
//  Author(s)   : Markus Janich
//
//  Description : Class GLDrawable
//  Purpose     : Abstract class of a drawable able to be rendered in OpenGL
//
//  Date        : Dezember 2000
//
//  Updates     :    who    | date   | what
//                ----------+--------+-------------------------------------
//                          |        |
//
////////////////////////////////////////////////////////////////////////////


#ifndef _GLDRAWABLE_H
#define _GLDRAWABLE_H

// OpenGL
////////////
#include <qgl.h>


// Own
///////


// Forward declarations
/////////////////////////



/**
  * This is a pure abstract class which defines an
  * interface of a drawable object.
  *
  * @author Markus Janich
  */

class GLDrawable {

   public:

      /** Default constructor. */
      GLDrawable();

      /** Virtual destructor. */
      virtual ~GLDrawable();


      /**
        * Must be implemented by the inherited class.
        * This method should draw the object to the current
	* OpenGL context and  gets called with the GL model matrix
	* set up for the local reference frame of the node. You
	* ought to leave the GL state as it comes in (usually).
	* glPush* and glPop* are your friends.
	*/
      virtual void draw() = 0;


   protected:

   private:

};

#endif // _GLDRAWABLE_H
