/*
 * QCameraPathDrag.h
 * $Id: 
 *
 * Copyright (C) 2001 Thomas Woerner, Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

#ifndef _QCAMERAPATHDRAG_H
#define _QCAMERAPATHDRAG_H


// Qt
///////
#include <qdragobject.h>

// QGLViewer
//////////////
#include <CCamera.h>

// Own
////////
#include "CList.h"



/// Dragobject for camera paths
/** @author Thomas Woerner, Markus Janich
  *
  * [tw] 2001/05/08 initial version
  */
class QCameraPathDrag: public QStoredDrag {
public:

  /** Default constructor. */
  QCameraPathDrag(CList<CCamera> &list, QWidget *parent=0,
		  const char *name=0);
  /** Destructor. */
  ~QCameraPathDrag() { }

  /* static method to test whether it can be decoded. */
  static bool canDecode(QDragMoveEvent *event);

  /* static method to decode a camera list. */
  static bool decode(QDropEvent *event, CList<CCamera> &list);
};


#endif // _QCAMERAPATHDRAG_H
