/*
* stonehandler.h
*/

#ifndef STONEHANDLER_H
#define STONEHANDLER_H

#include <qintdict.h>
#include <qvaluelist.h>
#include "defines.h"
#include "matrix.h"
#include "stone.h"
#include <qptrlist.h>

class Group;
class BoardHandler;

class StoneHandler
{
public:
	StoneHandler(BoardHandler *bh);
	~StoneHandler();
	void clearData();
	void toggleWorking(bool toggle) { workingOnNewMove = toggle; }
//  bool addStone(Stone *stone, bool toAdd=true, bool toCheck=true);  
	bool addStone(Stone *stone, bool toAdd=true, bool toCheck=true, Matrix *m=NULL); //SL added eb 8
	bool removeStone(int x, int y, bool hide=false);
	int hasStone(int x, int y);
	Stone* getStoneAt(int x, int y) { return stones->find(Matrix::coordsToKey(x, y)); }
	QIntDict<Stone>* getAllStones() const { return stones; }
	bool updateAll(Matrix *m, bool toDraw=true);
	void checkAllPositions();
	bool removeDeadGroup(int x, int y, int &caps, StoneColor &col, bool &dead);
	bool markSekiGroup(int x, int y, int &caps, StoneColor &col, bool &seki);
	void removeDeadMarks();
	void updateDeadMarks(int &black, int &white);
	bool checkFalseEye(Matrix *m, int x, int y, int col);
	int numStones() const { return stones->count(); } // TODO: For debugging only currently.
	// Needed later?
#ifndef NO_DEBUG
	void debug();
#endif
	
protected:
//  bool checkPosition(Stone *stone);
	bool checkPosition(Stone *stone,Matrix *m);       //SL added eb 8
	Group* assembleGroup(Stone *stone,Matrix *m);     //SL added eb 8
//  Group* assembleGroup(Stone *stone);
	Group* checkNeighbour(int x, int y, StoneColor color, Group *group,Matrix *m);
  	Group* checkNeighbour(int x, int y, StoneColor color, Group *group);
	int countLiberties(Group *group, Matrix *m);      //SL added eb 8
	int countLibertiesOnMatrix(Group *group, Matrix *m);
	void checkNeighbourLiberty(int x, int y, QValueList<int> &libCounted, int &liberties, Matrix *m);
	void checkNeighbourLibertyOnMatrix(int x, int y, QValueList<int> &libCounted, int &liberties, Matrix *m);
	
private:
	QIntDict<Stone> *stones;
	QPtrList<Group> *groups;
	bool workingOnNewMove;
	BoardHandler *boardHandler;
};

#endif
