/***************************************************************************
 *   Copyright (C) 2007 by Κωνσταντίνος Σμάνης   *
 *   kon.smanis@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation                                              *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301 USA                                             *
 ***************************************************************************/

#ifndef QGRUBEDITOR_H
#define QGRUBEDITOR_H

#include "ui_qgrubeditor.h"

#include "about.h"
#include "backuprestore.h"
#include "encrypt.h"
#include "input.h"
#include "preview.h"
#include "settings.h"
#include "splashcreator.h"

#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QTranslator>
#include <QTreeWidgetItem>
#include <QMessageBox>
#include <QLineEdit>
#include <QPushButton>
#include <QMenu>
#include <QFileInfo>
#include <QCompleter>
#include <QDirModel>
#include <QRegExp>
#include <QBrush>
#include <QColor>
#include <QActionGroup>
#include <QClipboard>
#include <QWhatsThis>

#include "lib/filetransactions.h"
#include "config.h"

class QGRUBEditor : public QMainWindow, private Ui::QGRUBEditor
{
Q_OBJECT
public:
	QGRUBEditor( QWidget *parent = 0 );
	~QGRUBEditor();
//EVENTS
protected:
	void contextMenuEvent( QContextMenuEvent *event );
	void closeEvent( QCloseEvent * );
private slots:
	void contextMenuToolbar();
	void contextMenuEntry();

	void rowChanged( const int row );
	void osIndexChanged( const int row );
	void rootIndexChanged( const int row );
	void rootIndexChanged_2( const int row );
	void entryIndexChanged( const int row );
//FUNCTIONS
private:
	//no-gui
	void customObjects();
	void customActions();
	void customToolbars();
	void customMenus();

	void makeConnections();
	void makeGRUBSettingsConnections( const bool activate );
	void applySettings();

	int colorConversion( const QString color );
	QString colorConversion( const int color );
	QString findPathByPartition( QString fullPath );
	QString findPartitionByPath( QString fullPath );
	//gui-related
	void showInput( const int row = 0 );

	void addClear();
	void editClear();
//OBJECTS
	FileTransactions *file;
	Config *config;
	GRUBSettings GRUBSETTINGS;
	QVector<GRUBItem> GRUBVECTOR;
	QVector<Device> DEVICEVECTOR;

	QLineEdit *lineEdit_menulst;
	QPushButton *pushButton_browse_menulst;
	QCompleter *completer;
	QTreeWidgetItem *treeWidgetItem;
	//menus
	QMenu *globalContextMenu;

	QMenu *toolbarContextMenu;
	QMenu *menuIconSize;
	QMenu *menuToolbuttonStyle;

	QMenu *entryContextMenu;
private slots:
//ACTIONS
	void toggleMenu();
	void updateToolbarSettings();
	void setDefault();
	void setFallback();

	void reload();
	void browse_menulst();

	void actionview_input();
	void actionadd_entry();
	void actionedit_entry();
	void actioncopy_entry();
	void actionremove_entry();
	void actionmove_to_top();
	void actionmove_up();
	void actionmove_down();
	void actionmove_to_bottom();
	void scan( const int row = 0 );
	void actionbackup_file();
	void actionrestore_file();
	void actiondelete_backup();
	void actionencrypt_password();
	void actioncreate_grub_splash_image();
	void actionsettings();
	void actionwhat_s_this();
	void actionabout_qgrubeditor();
//GUI
//Settings
	//menulst
	void updateMenulst();
	//hidden menu
	void checkBox_hiddenMenuToggled( const bool state );
	//timeout
	void enableTimeout( const bool state );
	void updateTimeout( const int value );
	//default
	void enableDefault( const bool state );
	void updateDefault( const int value );
	void enableSavedefault( const bool state );
	//fallback
	void enableFallback( const bool state );
	void updateFallback( const int value );
	//password
	void enablePassword( const bool state );
	void updatePassword();
	void encryptPassword();
	//colors
	void enableHighlight( const bool state );
	void updateColors();
	//splash image
	void enableSplash( const bool state );
	void updateSplash();
	void createSplashImage();
	void preview();
	void browse_splash();
//Entries
	//Add Page
	void add_browse_kernel();
	void add_browse_initrd();

	void add_OK();
	void add_cancel();
	void add_apply();

	//Edit Page
	void edit_browse_kernel();
	void edit_browse_initrd();

	void edit_OK();
	void edit_cancel();
	void edit_apply();
};

#endif
