/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#include "IMap.h"
#include "IProjection.h"

IMap::IMap(QObject * parent)
: QObject(parent)
, x_off(0.0)
, y_off(0.0)
, scale(1.0)
, easyDraw(false)
, needRedraw(false)
, showCityNames(true)
, showPOIs(true)
, showStreetNames(true)
{

}


IMap::~IMap()
{

}


void IMap::setEasyDraw(bool f)
{
    easyDraw = f;
    needRedraw = true;
}


void IMap::resize(const QSize& s)
{

    size = s;
    rect.setSize(size);
    calcWorldRect();

    scaleIcon.setTopLeft(QPoint(s.width() - 200, s.height() - 50));
    scaleIcon.setBottomRight(QPoint(s.width() - 100, s.height() - 47));
    scaleTextRect.setTopLeft(QPoint(s.width() - 200, s.height() - 65));
    scaleTextRect.setBottomRight(QPoint(s.width() - 100, s.height() - 52));

    pixBottom   = QPixmap(s);

    needRedraw = true;
}


void IMap::convertPt2Deg(double& u, double& v)
{

    XY pt;
    pt.u = x_off + u * scale;
    pt.v = y_off - v * scale;
    pt = pj_inv(pt,*gpProj);
    u = pt.u * RAD_TO_DEG;
    v = pt.v * RAD_TO_DEG;
}


void IMap::convertPt2Rad(double& u, double& v)
{
    XY pt;
    pt.u = x_off + u * scale;
    pt.v = y_off - v * scale;
    pt = pj_inv(pt,*gpProj);
    u = pt.u;
    v = pt.v;
}


void IMap::convertPt2M(double& u, double& v)
{
    u = x_off + u * scale;
    v = y_off - v * scale;
}


void IMap::move(const QPoint& old, const QPoint& next)
{

    XY pt1,pt2;

    pt1.u = old.x() * scale;
    pt1.v = old.y() * scale;

    pt2.u = next.x() * scale;
    pt2.v = next.y() * scale;

    x_off += pt1.u - pt2.u;
    y_off -= pt1.v - pt2.v;

    calcWorldRect();

    needRedraw = true;
}


void IMap::draw(QPainter& p,bool buffered)
{
    if(buffered) {
        if(needRedraw) {
            drawBackground();
        }
        p.drawPixmap(0,0,pixBottom);
    }
    else {
        drawBackground(&p);
    }

    p.setPen(Qt::white);
    p.setBrush(Qt::black);
    p.drawRect(scaleIcon);

    p.setPen(Qt::black);
    p.setBrush(Qt::black);
    p.drawText(scaleTextRect,Qt::AlignCenter,scaleText);

    needRedraw = false;
}
