/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "friendsutils.h"

#include <QtQuick/QQuickView>

#include <glib-object.h>

FriendsUtilsQml::FriendsUtilsQml(QObject *parent) :
    QObject(parent),
    m_utils(0)
{
    m_utils = friends_utils_new();
}

FriendsUtilsQml::~FriendsUtilsQml()
{
    g_object_unref(m_utils);
}

QString FriendsUtilsQml::getAvatarPath(const QString& url)
{
    QByteArray byte_array = url.toUtf8();
    gchar* avatar_path = friends_utils_get_avatar_path(m_utils, byte_array.data());
    return QString::fromUtf8(avatar_path);
}

QString FriendsUtilsQml::createTimeString(const QString& time)
{
    QByteArray byte_array = time.toUtf8();
    gchar* time_string = friends_utils_create_time_string(m_utils, byte_array.data());
    return QString::fromUtf8(time_string);
}
