/***************************************************************************
 *   Copyright (C) 2008 by Ilya Kotov                                      *
 *   forkotov02@hotmail.ru                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <bs2b/bs2b.h>
#include "ui_settingsdialog.h"

/**
	@author Ilya Kotov <forkotov02@hotmail.ru>
*/
class SettingsDialog : public QDialog
{
Q_OBJECT
public:
    SettingsDialog(QWidget *parent = 0);

    ~SettingsDialog();

public slots:
    virtual void accept();
    virtual void reject();

private slots:
    void on_freqSlider_valueChanged (int value);
    void on_feedSlider_valueChanged (int value);
    void on_defaultButton_pressed();
    void on_cmButton_pressed ();
    void on_jmButton_pressed ();

private:
    Ui::SettingsDialog ui;
    uint32_t m_level;

};

#endif
