/***************************************************************************
 *   Copyright (C) 2008 by Ilya Kotov                                      *
 *   forkotov02@hotmail.ru                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef POPUPWIDGET_H
#define POPUPWIDGET_H

#include <QWidget>
#include <QFrame>

class QTimer;
class QLabel;

/**
    @author Ilya Kotov <forkotov02@hotmail.ru>
*/
class PopupWidget : public QFrame
{
    Q_OBJECT
public:
    PopupWidget(QWidget *parent = 0);

    ~PopupWidget();

    enum Position
    {
        TOPLEFT = 0,
        TOP,
        TOPRIGHT,
        RIGHT,
        BOTTOMRIGHT,
        BOTTOM,
        BOTTOMLEFT,
        LEFT,
        CENTER
    };

    void showMetaData();
    void showVolume(int);

protected:
    virtual void mousePressEvent (QMouseEvent *);

private:
    void updatePosition();
    QTimer *m_timer;
    QLabel *m_label1;
    QLabel *m_label2;
    uint m_pos;

};

#endif
