
#include "misc.h"
#include "global.h"

#include "./icon/x1.xpm" 
#include "./icon/x2.xpm" 

#include <qbrush.h>
#include <qdrawutil.h>
#include <qfontmetrics.h>
#include <qwindowsstyle.h>
#include <qbutton.h>


CheckMenu::CheckMenu(QWidget *parent)
          : QPopupMenu(parent)
{}


CrossBox::CrossBox(const char *text, QWidget *parent)
         : QCheckBox(text, parent)
{}

void CrossBox::drawButton(QPainter *p)
{ 
	// only do this if we're in Motif mode
	/* not work qt3
	  if(style() == MotifStyle) {
		int y = height() / 2 - 6;
		QColorGroup g = colorGroup();
		QBrush fill(isDown() ? g.background() : g.base());
		qDrawShadePanel(p, 0, y, 12, 13, g, TRUE, 1, &fill);
		if(isChecked()) {
			p->drawLine(2, y + 2, 9, y + 9);
			p->drawLine(2, y + 3, 9, y + 10);
			p->drawLine(2, y + 9, 9, y + 2);
			p->drawLine(2, y + 10, 9, y + 3);
		}
		drawButtonLabel(p);
	} else */ 
	{
		// otherwise, behave like QCheckBox
		QCheckBox::drawButton(p);
	}
}

TFrame::TFrame(QWidget *parent):QFrame(parent)
{
	//setFixedWidth(70);	
//	setMinimumWidth (100);
}

void TFrame::drawContents( QPainter *p ) 
{	
	p->setPen(0x888888); // less visually obtrusive than black
//	p->drawLine(x, c / 2, x + c / 2, c / 2);

}

/*
//void SearchBox::event_cursor_moved(QMouseEvent *e)
{
	move(e->x(),e->y());
	//printf("xxxxxxxxxxxxxk\n");
}

*/

QPixmap *x1,*x2;
XButton::XButton(QWidget *parent):QButton(parent)
{
	//setFixedWidth(70);	
//	setMinimumWidth (100);
	
	x1=new QPixmap( (const char**)x1_xpm);
	x2=new QPixmap( (const char**)x2_xpm);
	int w=x1->width();
	setGeometry(0,0,w,w);
}


void XButton::resizeEvent(QResizeEvent *p)
{
	int i,h;
	i=height()%2;

	if(i!=0)
		h=height()+1;
	else h=height();	
	setFixedSize(h,h);
}

void XButton::drawButton(QPainter *p)
{ 
	int w,h,m;

	if(isDown())
		p->drawPixmap(0,0,*x2);	
	else	p->drawPixmap(0,0,*x1);

	return;
	/* DEL
	QPen pen;
	QColorGroup g = colorGroup();
	//QBrush fill(isDown() ? g.background() : g.foreground());
	QBrush fill(isDown() ? g.foreground() : g.background());
	QRect rec=rect();
	p->fillRect ( rec, fill ) ;
	pen.setColor(isDown() ? g.background(): g.foreground());
	pen.setWidth(2);
	pen.setWidth(1);
	p->setPen(isDown() ? g.base():  g.background() ,2 );
	p->setPen(pen);
	m=0; 
	p->drawLine(m,m,w-m,h-m);p->drawLine(m,h-m,w-m,m); */
}


SearchBox::SearchBox(QWidget *parent):QLineEdit(parent)
{
	left_time=0;
	setMinimumWidth (100);
	xb=new XButton(this);
	
	connect(xb, SIGNAL(clicked()), SLOT(event_xbutton_clicked()));
		
}

void SearchBox::event_xbutton_clicked()
{
	//printf("event_cursor_moved\n");
	clear();
	qps->forced_update();
}
void SearchBox::event_cursor_moved(QMouseEvent *e)
{
	move(e->x(),e->y());
	//printf("xxxxxxxxxxxxxk\n");
}

void SearchBox::resizeEvent(QResizeEvent *p)
{
	int w,h,margin;
	w=width();
	h=height();

	margin=(h - xb->width())/2;
	xb->move(w-h+margin-1,margin);
	
	return;	
	margin=h/2;
	xb->move(w-h+margin/2,margin/2);
	xb->setFixedSize(h-margin,h-margin);
}

void SearchBox::keyPressEvent ( QKeyEvent * e )
{
	
	if(e->key()==Qt::Key_Escape )
	{
		xb->setDown(true);
		event_xbutton_clicked();		
		xb->setDown(false);
		return;

	}

	if(e->key()==Qt::Key_Delete)
	{
		qps->sig_term();
		QLineEdit::keyPressEvent ( e );
		return;
	}
	
	QLineEdit::keyPressEvent ( e );
	qps->forced_update(); // better ?
	
}

void SearchBox::timerEvent( QTimerEvent *e )
{

 //       qDebug( "timer event, id %d", e->timerId() );
}
    
// Location: bottom
StatusBar::StatusBar(QWidget *parent)  : QStatusBar(parent)
{
	button = new QToolButton(this);//QButton *button = new QButton(this);
	button->setTextLabel ("") ;
	button->setUsesTextLabel ( true );
	button->setAutoRaise(true); 
	button->setFixedHeight(sizeHint().height()); 

//	button2 = new QToolButton(this);//QButton *button = new QButton(this);
//	button2->setTextLabel ("") ;
//	button2->setUsesTextLabel ( true );
//	button2->setAutoRaise(true); 
//	button2->setFixedHeight(sizeHint().height()); 

	button3 = new QToolButton(this);//QButton *button = new QButton(this);
	button3->setTextLabel ("") ;
	button3->setUsesTextLabel ( true );
	button3->setAutoRaise(true); 
	button3->setFixedHeight(sizeHint().height()); 
}

void StatusBar::refresh()
{

}

extern	int num_opened_files;
void StatusBar::update(int total_n)
{
	QString str;
	int 	x=0;
	///button->setPaletteBackgroundColor (colorGroup().background());
	button->setTextLabel ("Total Process : " + str.setNum(total_n) ) ;
	button->setFixedWidth (button->sizeHint().width()); 
	x+=button->sizeHint().width(); 

//	button2->setTextLabel ("Network Process(testing): "+ str.setNum(Procinfo::num_network_process));
//	button2->move( x + 2,0);
//	button2->setFixedWidth (button2->sizeHint().width()); 
//	x+=button2->sizeHint().width(); 
	
	button3->setTextLabel ("Opened files : "+ str.setNum(num_opened_files));
	button3->move(x + 2,0);
	button3->setFixedWidth (button3->sizeHint().width()); 
}


// Location : 
ControlBar::ControlBar(QWidget *parent)  : QFrame(parent)
{
	int h;
	
	h=default_font_height+3;
//	setFrameStyle(Panel | Raised);
	setFrameStyle(Panel ); // better ? (by hyun)
	
	
	b_linear = new QRadioButton("Linear", this);


	b_linear->setFixedSize(b_linear->sizeHint().width(), h);
	b_linear->setFocusPolicy(QWidget::NoFocus);
	connect(b_linear, SIGNAL(clicked()), SLOT(linear_clicked()));

	b_tree = new QRadioButton("Tree", this);
	b_tree->setFixedSize(b_tree->sizeHint().width(), h);
	b_tree->setFocusPolicy(QWidget::NoFocus);
	connect(b_tree, SIGNAL(clicked()), SLOT(tree_clicked()));
	
	
	if(flag_thread_ok){
		check_thread=new QCheckBox ("Thread",this);
		check_thread->setFixedSize(check_thread->sizeHint().width(), h);
		check_thread->setFocusPolicy(QWidget::NoFocus);
		check_thread->setGeometry(
				b_linear->width() + b_tree->width()+20,0,check_thread->sizeHint().width(),h);

		connect(check_thread, SIGNAL(clicked()), SLOT(show_thread_clicked()));
		check_thread->setChecked ( flag_show_thread) ;
	}

	search_box=new SearchBox(this);
	search_box->setFixedSize(check_thread->sizeHint().width(),h);
	search_box->setFrameShadow(QFrame::Plain);
	search_box->setFrameShape (QFrame::Box ) ;
	search_box->setLineWidth( 1 );

	connect(search_box, SIGNAL(textChanged ( const QString & ) ), SLOT(event_search_box_changed()));
	
	setFixedHeight(h + 2);
}


void ControlBar::setMode(bool treemode) // just.. interface function
{
	b_linear->setChecked(!treemode);
	b_tree->setChecked(treemode);
}

void ControlBar::linear_clicked()
{
	setMode(FALSE); 
	emit modeChange(FALSE);
}

void ControlBar::tree_clicked()
{
	setMode(TRUE);
	emit modeChange(TRUE);
}

void ControlBar::show_thread_clicked()
{
	flag_show_thread=check_thread->isChecked ();
	emit update();
}

void ControlBar::event_search_box_changed()
{
	//printf("search_box changed!\n");
}

void ControlBar::event_command_pressed()
{
	//printf("command!\n");
}

void ControlBar::update_bar()
{
	resize(width()-1,height());
	resize(width()+1,height());
}

void ControlBar::resizeEvent(QResizeEvent *r)
{
	int i,w,height,h;
	int x;


	h= r->size().height();

	x=8;
	b_linear->move(x, 0);
	
	x+= b_linear->x() + b_linear->width();
	b_tree->move( x , 0);


	x+= b_tree->width() + 20;
	check_thread->move(x,0);

	x+= check_thread->width() + 15;
	search_box->move(x, 0);
	search_box->setFixedWidth(250);
	//search_box->setFixedWidth(width()- b_update->width()-x -15);
	
	w=0;
	for(i=0;i< commands.size();i++)
	{
		QToolButton *b;
		if(commands[i].toolbar==true)
		{
			b=commands[i].toolbutton;		
			b->setFixedSize(b->sizeHint().width(), h);
			w+=b->width();
			b->move(width() -w, 0);
			b->show();
		}
		else 
			if(commands[i].toolbutton!=NULL)
				commands[i].toolbutton->hide();
	}

}



QPalette  GlobalPallete()
{
  	QColorGroup active;
	//void QPalette::setActive ( const QColorGroup & g ); 
	//const QColorGroup & QPalette::active () cons;
	if(1)
	{
		//active=qps->palette().active();
		//active.setColor (QColorGroup::Button,
		//	active.color (QColorGroup::Background));
				//active=colorGroup();
		//qps->palette().setActive(active);
		//active=colorGroup();
		//QPalette p=QPalette( active,  disabled,active );
		//return p; 
	}
	
	int base_red=204,
	    base_green=212,
	    base_blue=203;


	
	active.setColor (QColorGroup::Foreground, QColor(0,0,0 ));  // text
	active.setColor (QColorGroup::Button, QColor(base_red,base_green,base_blue )); // background 
	active.setColor (QColorGroup::Light, QColor(255,255,255 )); 
	active.setColor (QColorGroup::Midlight, QColor(base_red*6/7,base_green*6/7,base_blue*6/7 )); 
	//active.setColor (QColorGroup::Mid, QColor(base_red*4/5,base_green*4/5,base_blue*4/5 ));  //???
	active.setColor (QColorGroup::Mid, QColor(base_red*4/5,0,0 ));  //???
	active.setColor (QColorGroup::Dark, QColor(90,90,80 )); 
	//active.setColor (QColorGroup::Dark, QColor(10,10,10 )); 
	active.setColor (QColorGroup::Shadow, QColor(70,70,80 ));  
//	active.setColor (QColorGroup::Text, QColor(0,0,0 )); 
	active.setColor (QColorGroup::BrightText, QColor(255,0,0 )); //??? 
	active.setColor (QColorGroup::ButtonText, QColor(0,0,0 ));  //text
	active.setColor (QColorGroup::Text, QColor(0,0,0));  //text
	active.setColor (QColorGroup::Base, QColor(255,255,255)); 
	active.setColor (QColorGroup::Background, QColor(base_red,base_green,base_blue )); 
//	active.setColor (QColorGroup::Shadow, QColor(100,0,0 )); 
	active.setColor (QColorGroup::Highlight, QColor(250,250,0 )); // Yellow : Selected Color
	active.setColor (QColorGroup::HighlightedText, QColor(100,0,0 )); 
	active.setColor (QColorGroup::Link, QColor(0,0,130 ));  //blue
//	active.setColor (QColorGroup::LinkVisited, QColor(100,0,0 )); 

  	QColorGroup disabled(active);
	disabled.setColor (QColorGroup::Foreground, QColor(200,200,200 ));  // text
	disabled.setColor (QColorGroup::BrightText, QColor(200,200,200 )); 
	disabled.setColor (QColorGroup::ButtonText, QColor(200,200,200 ));  //text
	disabled.setColor (QColorGroup::Dark, QColor(200,200,200 ));  
	disabled.setColor (QColorGroup::Shadow, QColor(150,150,150 ));  
	disabled.setColor (QColorGroup::Text, QColor(255,255,255));  //text
	disabled.setColor (QColorGroup::Text, QColor(170,170,170));  //text

#ifdef SOLARIS

#endif
	QPalette p=QPalette( active,  disabled,active );
	return p; 

}



