#ifndef MISC_H
#define MISC_H


#include <qwidget.h>
#include <qcheckbox.h>
#include <qpainter.h>
#include <qframe.h> 
#include <qpopupmenu.h>
#include <qpainter.h>
#include <qlineedit.h>
#include <qstatusbar.h>
#include <qtoolbutton.h>
#include <qcheckbox.h>
#include <qradiobutton.h> 

class CrossBox : public QCheckBox
{
public:
    CrossBox(const char *text, QWidget *parent);

protected:
    virtual void drawButton(QPainter *paint);
};

class CheckMenu : public QPopupMenu
{
public:
    CheckMenu(QWidget *parent = 0);

};


class TFrame : public QFrame
{
	Q_OBJECT
	public:
		TFrame(QWidget *parent);
	protected slots:
//    		void refresh();
//  		void update(int n);
//		QToolButton *button,*button2,*button3;
//		void event_cursor_moved(QMouseEvent *e);
	protected :
		virtual void drawContents ( QPainter * ) ;
};



class XButton : public QButton
{
	Q_OBJECT
	public:
		XButton(QWidget *parent);
	protected slots:
//    		void refresh();
//  		void update(int n);
//		QToolButton *button,*button2,*button3;
//		void event_cursor_moved(QMouseEvent *e);
	protected :
		virtual void drawButton ( QPainter * ) ;
		void resizeEvent(QResizeEvent *p);
};

class SearchBox : public QLineEdit
{
	Q_OBJECT
	public:
		SearchBox(QWidget *parent);
		void event_cursor_moved(QMouseEvent *e);
	protected slots:
		void event_xbutton_clicked();
//    		void refresh();
//  		void update(int n);
//		QToolButton *button,*button2,*button3;
	protected:
		void keyPressEvent ( QKeyEvent * e );
		void resizeEvent(QResizeEvent *);
 		void timerEvent( QTimerEvent * );
		int left_time;
};

class StatusBar : public QStatusBar
{
	Q_OBJECT
	public:
		StatusBar(QWidget *parent);
    		void refresh();
    		void update(int n);
		QToolButton *button,*button2,*button3;

};


class ControlBar : public QFrame
{
	Q_OBJECT
	public:
		ControlBar(QWidget *parent);
		//QPushButton *updateButton() { return b_update; }
		void setMode(bool treemode);
		void update_bar();
	
	signals:
		void modeChange(bool treemode);
		void update();

	protected slots:
		void linear_clicked();
		void tree_clicked();
		void show_thread_clicked();
		void event_search_box_changed();
		void event_command_pressed();
		
	protected:
		void resizeEvent(QResizeEvent *);

	private:
		QRadioButton *b_tree, *b_linear, *b_treeT;
		QCheckBox    *check_thread;
//	 	QToolButton	*b_update;
};

QPalette  GlobalPallete();

#endif	// MISC_H
