/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#define SCAN_BLOCK_DONE  0
#define SCAN_BLOCK_FAIL  1
#define SCAN_BLOCK_LAST  2

#ifndef __SCAN_POINTERS_
#define __SCAN_POINTERS_

#include <qpx_mmc.h>

typedef int (*test_start)(drive_info*);
typedef int (*test_end)(drive_info*);

typedef struct {
	int  (*cx_start)(drive_info*);
	int  (*cx_one_interval)(drive_info*, int*, int*, int*, int*, int*, int*, int*, int*);
				// .. LBA, BLER, E11, E21, E31, E12, E22, E32
	int  (*cx_end)(drive_info*);

	int  (*jb_cd_start)(drive_info*);
	int  (*jb_cd_one_interval)(drive_info*, int*, int*, short int*, int); // .. LBA, Jitter, Beta, len
	int  (*jb_cd_end)(drive_info*);

	int  (*pie_start)(drive_info*);
	int  (*pie_8_ecc_blocks)(drive_info*, int*, int*, int*); // .. LBA, pie, pof
	int  (*pie_end)(drive_info*);

	int  (*pif_start)(drive_info*);
	int  (*pif_1_ecc_block)(drive_info*, int*, int*); // .. LBA, pif
	int  (*pif_end)(drive_info*);

	int  (*pie_poe_start)(drive_info*);
	int  (*pie_poe_8_ecc_blocks)(drive_info*, int*, int*, int*, int*); // .. LBA, pie, poe, pof
	int  (*pie_poe_end)(drive_info*);

	int  (*pie_pif_start)(drive_info*);
	int  (*pie_pif_8_ecc_blocks)(drive_info*, int*, int*, int*, int*); // .. LBA, pie, pif, pof
	int  (*pie_pif_end)(drive_info*);

	int  (*jb_dvd_start)(drive_info*);
	int  (*jb_dvd_16_ecc_blocks)(drive_info*, int*, int*, short int*); // .. LBA, Jitter, Beta
	int  (*jb_dvd_end)(drive_info*);
} scan_commands;

#endif //__SCAN_POINTERS_
