/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 *
 */

//#include <stdio.h>
//#include <string.h>
//#include <stdlib.h>

#include <unistd.h>
//#include <sys/time.h>

#include <qevent.h>
#include <qthread.h>

//#include "transport.hxx"
#include <qpx_mmc.h>
#include <qpx_transport.h>
#include <scan_events.h>

#include "watcher.h"

watcher_thread::watcher_thread(QObject* p)
{
	parent = p;
}

watcher_thread::~watcher_thread()
{
}

void watcher_thread::init(unsigned char i, drive_info* drv)
{
	drive = drv;
	idx   = i;
}

void watcher_thread::run()
{
	if (!drive) return;
	for (;;) {
		get_media_status(drive);
		switch (drive->parms.event) {
			case EVENT_MEDIA_NEW:
				printf("Watcher: [%s] %s %s: new media\n", drive->device, drive->ven, drive->dev);
				emit_media_new();
				break;
			case EVENT_MEDIA_REMOVED:
				printf("Watcher: [%s] %s %s: media removed\n", drive->device, drive->ven, drive->dev);
				emit_media_removed();
				break;
		}
		sleep(1);
	}
}

void watcher_thread::emit_media_new()
{
	QCustomEvent*	event = new QCustomEvent(event_media_new);
	event->setData(&idx);
	postEvent(parent, event);
}

void watcher_thread::emit_media_removed()
{
	QCustomEvent*	event = new QCustomEvent(event_media_removed);
	event->setData(&idx);
	postEvent(parent, event);
}
