//depot/qt/2.3/tools/qvfb/skin.cpp#2 - edit change 67695 (text)
#include <qbitmap.h>
#include <qpixmap.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qimage.h>
#include "skin.h"
#include "qvfb.h"
#include "qvfbview.h"


Skin::Skin( QVFb *p, const QString &skinFile, int &viewW, int &viewH ) : 
     QWidget(p), view(0), buttonPressed(FALSE), buttonIndex(0), skinValid(FALSE), 
     numberOfAreas(0), areas(0)
{
    parent = p;

    QFileInfo fi(skinFile);
    QString prefix;
    QString fn;
    if ( fi.isDir() ) {
	prefix = skinFile + "/";
	fn = prefix + fi.baseName() + ".skin";
    } else if (fi.isFile()){
	fn = skinFile;
    }else if (!skinFile.isNull()){
	qDebug("Skin file \"%s\" not found", skinFile.latin1());	
	return;
    }

    QFile f( fn );
    f.open( IO_ReadOnly );
    QTextStream ts( &f );
    ts >> skinImageUpFileName;
    ts >> skinImageDownFileName;
    ts >> viewX1;
    ts >> viewY1;
    ts >> viewW;
    ts >> viewH;
    ts >> numberOfAreas;
//  Debug the skin file parsing
//  printf("read: -%s- -%i- -%i- -%i-\n", skinImage.latin1(), viewX1, viewY1, numberOfAreas );
    areas = new ButtonAreas[numberOfAreas];

    skinImageUpFileName = prefix + skinImageUpFileName;
    skinImageDownFileName = prefix + skinImageDownFileName;
qDebug("%s %s",skinImageUpFileName.latin1(),skinImageDownFileName.latin1());

    for (int i = 0; i < numberOfAreas; i++) {
	ts >> areas[i].name;
	ts >> areas[i].keyCode;
	ts >> areas[i].x1;
	ts >> areas[i].y1;
	ts >> areas[i].x2;
	ts >> areas[i].y2;
	if ( areas[i].name[0] == '"' && areas[i].name.right(1) == "\"" )
	    areas[i].name = areas[i].name.mid(1,areas[i].name.length()-2);
	if ( areas[i].name.length() == 1 )
	    areas[i].text = areas[i].name;
//	Debug the skin file parsing
//	printf("read: -%s- -%i- -%i- -%i- -%i- -%i-\n", areas[i].name.latin1(),
//	    areas[i].keyCode, areas[i].x1, areas[i].y1, areas[i].x2, areas[i].y2 );
    }

    QImage iup(skinImageUpFileName);
    //int conv = OrderedAlphaDither;
    int conv = -1;
    skinImageUp.convertFromImage(iup,conv);
    QImage idown(skinImageDownFileName);
    skinImageDown.convertFromImage(idown,conv);

    setFixedSize( skinImageUp.size() );
    QBitmap mask = skinImageUp.mask()
	? *skinImageUp.mask() : skinImageUp.createHeuristicMask();
    parent->setMask( mask );
    parent->setFixedSize( skinImageUp.size() );
    skinValid = TRUE;
}


Skin::~Skin( )
{
}


void Skin::setView( QVFbView *v )
{
    view = v;
    view->move( viewX1, viewY1 );
}


void Skin::paintEvent( QPaintEvent * )
{
    QPainter p( this );
    p.drawPixmap( 0, 0, skinImageUp );
    if (buttonPressed == TRUE) {
	ButtonAreas *ba = &areas[buttonIndex];
	p.drawPixmap( ba->x1, ba->y1, skinImageDown, ba->x1, ba->y1, ba->x2 - ba->x1, ba->y2 - ba->y1 );
    }
}


void Skin::mousePressEvent( QMouseEvent *e )
{
    if (e->button() == RightButton) {
	parent->popupMenu();
    } else {
	buttonPressed = FALSE;

	for (int i = 0; i < numberOfAreas; i++) {
	    QPoint p1( areas[i].x1, areas[i].y1 );
	    QPoint p2( areas[i].x2, areas[i].y2 );
	    QRect r( p1, p2 );
	    if ( r.contains( e->pos() ) ) {
		buttonPressed = TRUE;
		buttonIndex = i;
		if (view)
		    view->skinKeyPressEvent( areas[buttonIndex].keyCode, areas[buttonIndex].text );
//		Debug message to be sure we are clicking the right areas
//		printf("%s clicked\n", areas[i].name);
		ButtonAreas *ba = &areas[buttonIndex];
		repaint( ba->x1, ba->y1, ba->x2 - ba->x1, ba->y2 - ba->y1, FALSE );
		continue;
	    }
	}
	
//	This is handy for finding the areas to define rectangles for new skins
//	printf("Clicked in %i,%i\n",  e->pos().x(),  e->pos().y());
	clickPos = e->pos();
    }
}


void Skin::mouseMoveEvent( QMouseEvent *e )
{
    if ( buttonPressed == FALSE ) {
	QPoint newpos =  e->globalPos() - clickPos;
	parent->move( newpos );
    }
}


void Skin::mouseReleaseEvent( QMouseEvent * )
{
    if ( buttonPressed ) {
	if (view)
	    view->skinKeyReleaseEvent( areas[buttonIndex].keyCode, areas[buttonIndex].text );
	buttonPressed = FALSE;
	ButtonAreas *ba = &areas[buttonIndex];
	repaint( ba->x1, ba->y1, ba->x2 - ba->x1, ba->y2 - ba->y1, FALSE );
    }
}


