# AssImp expects this to be defined on debug builds
CONFIG(debug, debug|release) : DEFINES+=_DEBUG
CONFIG += exceptions rtti

CONFIG -= precompile_header

win32:DEFINES+=_CRT_SECURE_NO_WARNINGS

qtConfig(system-zlib):!if(cross_compile:host_build): \
    QMAKE_USE_PRIVATE += zlib
else: \
    QT_PRIVATE += zlib-private

DEFINES += \
   ASSIMP_BUILD_NO_OWN_ZLIB \
   ASSIMP_BUILD_NO_COMPRESSED_IFC \
   ASSIMP_BUILD_NO_Q3BSP_IMPORTER \
   ASSIMP_BUILD_NO_C4D_IMPORTER \
   ASSIMP_BUILD_NO_3MF_IMPORTER \
   OPENDDL_STATIC_LIBARY \
   NOUNCRYPT

intel_icc: {
    # warning #310: old-style parameter list (anachronism)
    QMAKE_CFLAGS_WARN_ON += -wd310

    # warning #68: integer conversion resulted in a change of sign
    QMAKE_CFLAGS_WARN_ON += -wd68

    # warning #858: type qualifier on return type is meaningless
    QMAKE_CFLAGS_WARN_ON += -wd858

    QMAKE_CXXFLAGS_WARN_ON += $$QMAKE_CFLAGS_WARN_ON
} else:gcc|clang: {
    # Stop compiler complaining about ignored qualifiers on return types
    QMAKE_CFLAGS_WARN_ON += -Wno-ignored-qualifiers -Wno-unused-parameter -Wno-unused-variable -Wno-deprecated-declarations -Wno-unused-function
    QMAKE_CXXFLAGS_WARN_ON = $$QMAKE_CFLAGS_WARN_ON -Wno-reorder
} else:msvc {
    # Disabled Warnings:
    #   4100: 'identifier' : unreferenced formal parameter
    #   4189: 'identifier' : local variable is initialized but not referenced
    #   4267: coversion from 'size_t' to 'int', possible loss of data
    #   4996: Function call with parameters that may be unsafe
    #   4828: The file contains a character starting at offset 0x167b that
    #         is illegal in the current source character set (codepage 65001)
    QMAKE_CFLAGS_WARN_ON += -wd"4100" -wd"4189" -wd"4267" -wd"4996" -wd"4828"
    QMAKE_CXXFLAGS_WARN_ON = $$QMAKE_CFLAGS_WARN_ON
}

clang: {
    QMAKE_CFLAGS_WARN_ON += -Wno-unused-private-field
    QMAKE_CXXFLAGS_WARN_ON = $$QMAKE_CFLAGS_WARN_ON
}

CONFIG += warn_on

VPATH += \
        $$PWD \
        $$PWD/code \
        $$PWD/code/res \
        $$PWD/contrib/clipper \
        $$PWD/contrib/ConvertUTF \
        $$PWD/contrib/irrXML \
        $$PWD/contrib/unzip

INCLUDEPATH += \
        $$PWD \
        $$PWD/code \
        $$PWD/include \
        $$PWD/include/assimp/Compiler \
        $$PWD/contrib/clipper \
        $$PWD/contrib/ConvertUTF \
        $$PWD/contrib/irrXML \
        $$PWD/contrib/openddlparser/include \
        $$PWD/contrib/poly2tri/poly2tri \
        $$PWD/contrib/rapidjson/include \
        $$PWD/contrib/unzip

# Input
HEADERS += revision.h \
        code/3DSExporter.h \
        code/3DSHelper.h \
        code/3DSLoader.h \
        code/3MFXmlTags.h \
        code/ACLoader.h \
        code/ASELoader.h \
        code/ASEParser.h \
        code/AssbinExporter.h \
        code/AssbinLoader.h \
        code/AssxmlExporter.h \
        code/B3DImporter.h \
        code/BVHLoader.h \
        code/BaseImporter.h \
        code/BaseProcess.h \
        code/Bitmap.h \
        code/BlenderBMesh.h \
        code/BlenderDNA.h \
        code/BlenderIntermediate.h \
        code/BlenderLoader.h \
        code/BlenderModifier.h \
        code/BlenderScene.h \
        code/BlenderSceneGen.h \
        code/BlenderTessellator.h \
        code/BlobIOSystem.h \
        code/ByteSwapper.h \
        code/C4DImporter.h \
        code/CInterfaceIOWrapper.h \
        code/COBLoader.h \
        code/COBScene.h \
        code/CSMLoader.h \
        code/CalcTangentsProcess.h \
        code/ColladaExporter.h \
        code/ColladaHelper.h \
        code/ColladaLoader.h \
        code/ColladaParser.h \
        code/ComputeUVMappingProcess.h \
        code/ConvertToLHProcess.h \
        code/CreateAnimMesh.h \
        code/D3MFExporter.h \
        code/D3MFImporter.h \
        code/D3MFOpcPackage.h \
        code/DXFHelper.h \
        code/DXFLoader.h \
        code/DeboneProcess.h \
        code/DefaultProgressHandler.h \
        code/Exceptional.h \
        code/FBXCompileConfig.h \
        code/FBXConverter.h \
        code/FBXDocument.h \
        code/FBXDocumentUtil.h \
        code/FBXImportSettings.h \
        code/FBXImporter.h \
        code/FBXMeshGeometry.h \
        code/FBXParser.h \
        code/FBXProperties.h \
        code/FBXTokenizer.h \
        code/FBXUtil.h \
        code/FileLogStream.h \
        code/FileSystemFilter.h \
        code/FindDegenerates.h \
        code/FindInstancesProcess.h \
        code/FindInvalidDataProcess.h \
        code/FixNormalsStep.h \
        code/GenFaceNormalsProcess.h \
        code/GenVertexNormalsProcess.h \
        code/GenericProperty.h \
        code/HMPFileData.h \
        code/HMPLoader.h \
        code/HalfLifeFileData.h \
        code/Hash.h \
        code/IFCLoader.h \
        code/IFCReaderGen.h \
        code/IFCUtil.h \
        code/IFF.h \
        code/IOStreamBuffer.h \
        code/IRRLoader.h \
        code/IRRMeshLoader.h \
        code/IRRShared.h \
        code/Importer.h \
        code/ImproveCacheLocality.h \
        code/JoinVerticesProcess.h \
        code/LWOAnimation.h \
        code/LWOFileData.h \
        code/LWOLoader.h \
        code/LWSLoader.h \
        code/LimitBoneWeightsProcess.h \
        code/LineSplitter.h \
        code/LogAux.h \
        code/MD2FileData.h \
        code/MD2Loader.h \
        code/MD2NormalTable.h \
        code/MD3FileData.h \
        code/MD3Loader.h \
        code/MD4FileData.h \
        code/MD5Loader.h \
        code/MD5Parser.h \
        code/MDCFileData.h \
        code/MDCLoader.h \
        code/MDCNormalTable.h \
        code/MDLDefaultColorMap.h \
        code/MDLFileData.h \
        code/MDLLoader.h \
        code/MMDCpp14.h \
        code/MMDImporter.h \
        code/MMDPmdParser.h \
        code/MMDPmxParser.h \
        code/MMDVmdParser.h \
        code/MS3DLoader.h \
        code/Macros.h \
        code/MakeVerboseFormat.h \
        code/MaterialSystem.h \
        code/MathFunctions.h \
        code/MemoryIOWrapper.h \
        code/NDOLoader.h \
        code/NFFLoader.h \
        code/OFFLoader.h \
        code/ObjExporter.h \
        code/ObjFileData.h \
        code/ObjFileImporter.h \
        code/ObjFileMtlImporter.h \
        code/ObjFileParser.h \
        code/ObjTools.h \
        code/OgreBinarySerializer.h \
        code/OgreImporter.h \
        code/OgreParsingUtils.h \
        code/OgreStructs.h \
        code/OgreXmlSerializer.h \
        code/OpenGEXExporter.h \
        code/OpenGEXImporter.h \
        code/OpenGEXStructs.h \
        code/OptimizeGraph.h \
        code/OptimizeMeshes.h \
        code/ParsingUtils.h \
        code/PlyExporter.h \
        code/PlyLoader.h \
        code/PlyParser.h \
        code/PolyTools.h \
        code/PretransformVertices.h \
        code/ProcessHelper.h \
        code/Profiler.h \
        code/Q3BSPFileData.h \
        code/Q3BSPFileImporter.h \
        code/Q3BSPFileParser.h \
        code/Q3BSPZipArchive.h \
        code/Q3DLoader.h \
        code/RawLoader.h \
        code/RemoveComments.h \
        code/RemoveRedundantMaterials.h \
        code/RemoveVCProcess.h \
        code/SGSpatialSort.h \
        code/SIBImporter.h \
        code/SMDLoader.h \
        code/STEPFile.h \
        code/STEPFileEncoding.h \
        code/STEPFileReader.h \
        code/STLExporter.h \
        code/STLLoader.h \
        code/ScaleProcess.h \
        code/ScenePreprocessor.h \
        code/ScenePrivate.h \
        code/SkeletonMeshBuilder.h \
        code/SmoothingGroups.h \
        code/SortByPTypeProcess.h \
        code/SpatialSort.h \
        code/SplitByBoneCountProcess.h \
        code/SplitLargeMeshes.h \
        code/StandardShapes.h \
        code/StdOStreamLogStream.h \
        code/StepExporter.h \
        code/StreamReader.h \
        code/StreamWriter.h \
        code/StringComparison.h \
        code/StringUtils.h \
        code/Subdivision.h \
        code/TargetAnimation.h \
        code/TerragenLoader.h \
        code/TextureTransform.h \
        code/TinyFormatter.h \
        code/TriangulateProcess.h \
        code/UnrealLoader.h \
        code/ValidateDataStructure.h \
        code/Vertex.h \
        code/VertexTriangleAdjacency.h \
        code/Win32DebugLogStream.h \
        code/XFileExporter.h \
        code/XFileHelper.h \
        code/XFileImporter.h \
        code/XFileParser.h \
        code/XGLLoader.h \
        code/XMLTools.h \
        code/assbin_chunks.h \
        code/fast_atof.h \
        code/glTF2Asset.h \
        code/glTF2AssetWriter.h \
        code/glTF2Exporter.h \
        code/glTF2Importer.h \
        code/glTFAsset.h \
        code/glTFAssetWriter.h \
        code/glTFExporter.h \
        code/glTFImporter.h \
        code/irrXMLWrapper.h \
        code/qnan.h \
        code/res/resource.h \
        contrib/Open3DGC/o3dgcAdjacencyInfo.h \
        contrib/Open3DGC/o3dgcArithmeticCodec.h \
        contrib/Open3DGC/o3dgcBinaryStream.h \
        contrib/Open3DGC/o3dgcCommon.h \
        contrib/Open3DGC/o3dgcDVEncodeParams.h \
        contrib/Open3DGC/o3dgcDynamicVector.h \
        contrib/Open3DGC/o3dgcDynamicVectorDecoder.h \
        contrib/Open3DGC/o3dgcDynamicVectorEncoder.h \
        contrib/Open3DGC/o3dgcFIFO.h \
        contrib/Open3DGC/o3dgcIndexedFaceSet.h \
        contrib/Open3DGC/o3dgcSC3DMCDecoder.h \
        contrib/Open3DGC/o3dgcSC3DMCEncodeParams.h \
        contrib/Open3DGC/o3dgcSC3DMCEncoder.h \
        contrib/Open3DGC/o3dgcTimer.h \
        contrib/Open3DGC/o3dgcTriangleFans.h \
        contrib/Open3DGC/o3dgcTriangleListDecoder.h \
        contrib/Open3DGC/o3dgcTriangleListEncoder.h \
        contrib/Open3DGC/o3dgcVector.h \
        contrib/clipper/clipper.hpp \
        contrib/irrXML/CXMLReaderImpl.h \
        contrib/irrXML/heapsort.h \
        contrib/irrXML/irrArray.h \
        contrib/irrXML/irrString.h \
        contrib/irrXML/irrTypes.h \
        contrib/irrXML/irrXML.h \
        contrib/openddlparser/include/openddlparser/DDLNode.h \
        contrib/openddlparser/include/openddlparser/OpenDDLCommon.h \
        contrib/openddlparser/include/openddlparser/OpenDDLExport.h \
        contrib/openddlparser/include/openddlparser/OpenDDLParser.h \
        contrib/openddlparser/include/openddlparser/OpenDDLParserUtils.h \
        contrib/openddlparser/include/openddlparser/OpenDDLStream.h \
        contrib/openddlparser/include/openddlparser/Value.h \
        contrib/poly2tri/poly2tri/common/shapes.h \
        contrib/poly2tri/poly2tri/common/utils.h \
        contrib/poly2tri/poly2tri/poly2tri.h \
        contrib/poly2tri/poly2tri/sweep/advancing_front.h \
        contrib/poly2tri/poly2tri/sweep/cdt.h \
        contrib/poly2tri/poly2tri/sweep/sweep.h \
        contrib/poly2tri/poly2tri/sweep/sweep_context.h \
        contrib/rapidjson/include/rapidjson/allocators.h \
        contrib/rapidjson/include/rapidjson/document.h \
        contrib/rapidjson/include/rapidjson/encodedstream.h \
        contrib/rapidjson/include/rapidjson/encodings.h \
        contrib/rapidjson/include/rapidjson/error/en.h \
        contrib/rapidjson/include/rapidjson/error/error.h \
        contrib/rapidjson/include/rapidjson/filereadstream.h \
        contrib/rapidjson/include/rapidjson/filewritestream.h \
        contrib/rapidjson/include/rapidjson/fwd.h \
        contrib/rapidjson/include/rapidjson/internal/biginteger.h \
        contrib/rapidjson/include/rapidjson/internal/diyfp.h \
        contrib/rapidjson/include/rapidjson/internal/dtoa.h \
        contrib/rapidjson/include/rapidjson/internal/ieee754.h \
        contrib/rapidjson/include/rapidjson/internal/itoa.h \
        contrib/rapidjson/include/rapidjson/internal/meta.h \
        contrib/rapidjson/include/rapidjson/internal/pow10.h \
        contrib/rapidjson/include/rapidjson/internal/regex.h \
        contrib/rapidjson/include/rapidjson/internal/stack.h \
        contrib/rapidjson/include/rapidjson/internal/strfunc.h \
        contrib/rapidjson/include/rapidjson/internal/strtod.h \
        contrib/rapidjson/include/rapidjson/internal/swap.h \
        contrib/rapidjson/include/rapidjson/istreamwrapper.h \
        contrib/rapidjson/include/rapidjson/memorybuffer.h \
        contrib/rapidjson/include/rapidjson/memorystream.h \
        contrib/rapidjson/include/rapidjson/msinttypes/inttypes.h \
        contrib/rapidjson/include/rapidjson/msinttypes/stdint.h \
        contrib/rapidjson/include/rapidjson/ostreamwrapper.h \
        contrib/rapidjson/include/rapidjson/pointer.h \
        contrib/rapidjson/include/rapidjson/prettywriter.h \
        contrib/rapidjson/include/rapidjson/rapidjson.h \
        contrib/rapidjson/include/rapidjson/reader.h \
        contrib/rapidjson/include/rapidjson/schema.h \
        contrib/rapidjson/include/rapidjson/stream.h \
        contrib/rapidjson/include/rapidjson/stringbuffer.h \
        contrib/rapidjson/include/rapidjson/writer.h \
        contrib/unzip/crypt.h \
        contrib/unzip/ioapi.h \
        contrib/unzip/unzip.h \
        contrib/utf8cpp/source/utf8.h \
        contrib/utf8cpp/source/utf8/checked.h \
        contrib/utf8cpp/source/utf8/core.h \
        contrib/utf8cpp/source/utf8/unchecked.h \
        include/assimp/Compiler/poppack1.h \
        include/assimp/Compiler/pstdint.h \
        include/assimp/Compiler/pushpack1.h \
        include/assimp/DefaultIOStream.h \
        include/assimp/DefaultIOSystem.h \
        include/assimp/DefaultLogger.hpp \
        include/assimp/Defines.h \
        include/assimp/Exporter.hpp \
        include/assimp/IOStream.hpp \
        include/assimp/IOSystem.hpp \
        include/assimp/Importer.hpp \
        include/assimp/LogStream.hpp \
        include/assimp/Logger.hpp \
        include/assimp/NullLogger.hpp \
        include/assimp/ProgressHandler.hpp \
        include/assimp/SceneCombiner.h \
        include/assimp/ai_assert.h \
        include/assimp/anim.h \
        include/assimp/camera.h \
        include/assimp/cexport.h \
        include/assimp/cfileio.h \
        include/assimp/cimport.h \
        include/assimp/color4.h \
        include/assimp/config.h \
        include/assimp/defs.h \
        include/assimp/importerdesc.h \
        include/assimp/light.h \
        include/assimp/material.h \
        include/assimp/matrix3x3.h \
        include/assimp/matrix4x4.h \
        include/assimp/mesh.h \
        include/assimp/metadata.h \
        include/assimp/port/AndroidJNI/AndroidJNIIOSystem.h \
        include/assimp/postprocess.h \
        include/assimp/quaternion.h \
        include/assimp/scene.h \
        include/assimp/texture.h \
        include/assimp/types.h \
        include/assimp/vector2.h \
        include/assimp/vector3.h \
        include/assimp/version.h

SOURCES += \
        code/3DSConverter.cpp \
        code/3DSExporter.cpp \
        code/3DSLoader.cpp \
        code/ACLoader.cpp \
        code/AMFImporter.cpp \
        code/AMFImporter_Geometry.cpp \
        code/AMFImporter_Material.cpp \
        code/AMFImporter_Postprocess.cpp \
        code/ASELoader.cpp \
        code/ASEParser.cpp \
        code/AssbinExporter.cpp \
        code/AssbinLoader.cpp \
        code/Assimp.cpp \
        code/AssimpCExport.cpp \
        code/AssxmlExporter.cpp \
        code/B3DImporter.cpp \
        code/BVHLoader.cpp \
        code/BaseImporter.cpp \
        code/BaseProcess.cpp \
        code/Bitmap.cpp \
        code/BlenderBMesh.cpp \
        code/BlenderDNA.cpp \
        code/BlenderLoader.cpp \
        code/BlenderModifier.cpp \
        code/BlenderScene.cpp \
        code/BlenderTessellator.cpp \
        code/C4DImporter.cpp \
        code/CInterfaceIOWrapper.cpp \
        code/COBLoader.cpp \
        code/CSMLoader.cpp \
        code/CalcTangentsProcess.cpp \
        code/ColladaExporter.cpp \
        code/ColladaLoader.cpp \
        code/ColladaParser.cpp \
        code/ComputeUVMappingProcess.cpp \
        code/ConvertToLHProcess.cpp \
        code/CreateAnimMesh.cpp \
        code/D3MFExporter.cpp \
        code/D3MFImporter.cpp \
        code/D3MFOpcPackage.cpp \
        code/DXFLoader.cpp \
        code/DeboneProcess.cpp \
        code/DefaultIOStream.cpp \
        code/DefaultIOSystem.cpp \
        code/DefaultLogger.cpp \
        code/Exporter.cpp \
        code/FBXAnimation.cpp \
        code/FBXBinaryTokenizer.cpp \
        code/FBXConverter.cpp \
        code/FBXDeformer.cpp \
        code/FBXDocument.cpp \
        code/FBXDocumentUtil.cpp \
        code/FBXImporter.cpp \
        code/FBXMaterial.cpp \
        code/FBXMeshGeometry.cpp \
        code/FBXModel.cpp \
        code/FBXNodeAttribute.cpp \
        code/FBXParser.cpp \
        code/FBXProperties.cpp \
        code/FBXTokenizer.cpp \
        code/FBXUtil.cpp \
        code/FIReader.cpp \
        code/FindDegenerates.cpp \
        code/FindInstancesProcess.cpp \
        code/FindInvalidDataProcess.cpp \
        code/FixNormalsStep.cpp \
        code/GenFaceNormalsProcess.cpp \
        code/GenVertexNormalsProcess.cpp \
        code/HMPLoader.cpp \
        code/IFCBoolean.cpp \
        code/IFCCurve.cpp \
        code/IFCGeometry.cpp \
        code/IFCLoader.cpp \
        code/IFCMaterial.cpp \
        code/IFCOpenings.cpp \
        code/IFCProfile.cpp \
        code/IFCReaderGen1.cpp \
        code/IFCReaderGen2.cpp \
        code/IFCUtil.cpp \
        code/IRRLoader.cpp \
        code/IRRMeshLoader.cpp \
        code/IRRShared.cpp \
        code/Importer.cpp \
        code/ImporterRegistry.cpp \
        code/ImproveCacheLocality.cpp \
        code/JoinVerticesProcess.cpp \
        code/LWOAnimation.cpp \
        code/LWOBLoader.cpp \
        code/LWOLoader.cpp \
        code/LWOMaterial.cpp \
        code/LWSLoader.cpp \
        code/LimitBoneWeightsProcess.cpp \
        code/MD2Loader.cpp \
        code/MD3Loader.cpp \
        code/MD5Loader.cpp \
        code/MD5Parser.cpp \
        code/MDCLoader.cpp \
        code/MDLLoader.cpp \
        code/MDLMaterialLoader.cpp \
        code/MMDImporter.cpp \
        code/MMDPmxParser.cpp \
        code/MS3DLoader.cpp \
        code/MakeVerboseFormat.cpp \
        code/MaterialSystem.cpp \
        code/NDOLoader.cpp \
        code/NFFLoader.cpp \
        code/OFFLoader.cpp \
        code/ObjExporter.cpp \
        code/ObjFileImporter.cpp \
        code/ObjFileMtlImporter.cpp \
        code/ObjFileParser.cpp \
        code/OgreBinarySerializer.cpp \
        code/OgreImporter.cpp \
        code/OgreMaterial.cpp \
        code/OgreStructs.cpp \
        code/OgreXmlSerializer.cpp \
        code/OpenGEXExporter.cpp \
        code/OpenGEXImporter.cpp \
        code/OptimizeGraph.cpp \
        code/OptimizeMeshes.cpp \
        code/PlyExporter.cpp \
        code/PlyLoader.cpp \
        code/PlyParser.cpp \
        code/PostStepRegistry.cpp \
        code/PretransformVertices.cpp \
        code/ProcessHelper.cpp \
        code/Q3BSPFileImporter.cpp \
        code/Q3BSPFileParser.cpp \
        code/Q3BSPZipArchive.cpp \
        code/Q3DLoader.cpp \
        code/RawLoader.cpp \
        code/RemoveComments.cpp \
        code/RemoveRedundantMaterials.cpp \
        code/RemoveVCProcess.cpp \
        code/SGSpatialSort.cpp \
        code/SIBImporter.cpp \
        code/SMDLoader.cpp \
        code/STEPFileEncoding.cpp \
        code/STEPFileReader.cpp \
        code/STLExporter.cpp \
        code/STLLoader.cpp \
        code/ScaleProcess.cpp \
        code/SceneCombiner.cpp \
        code/ScenePreprocessor.cpp \
        code/SkeletonMeshBuilder.cpp \
        code/SortByPTypeProcess.cpp \
        code/SpatialSort.cpp \
        code/SplitByBoneCountProcess.cpp \
        code/SplitLargeMeshes.cpp \
        code/StandardShapes.cpp \
        code/StepExporter.cpp \
        code/Subdivision.cpp \
        code/TargetAnimation.cpp \
        code/TerragenLoader.cpp \
        code/TextureTransform.cpp \
        code/TriangulateProcess.cpp \
        code/UnrealLoader.cpp \
        code/ValidateDataStructure.cpp \
        code/Version.cpp \
        code/VertexTriangleAdjacency.cpp \
        code/X3DExporter.cpp \
        code/X3DImporter.cpp \
        code/X3DImporter_Geometry2D.cpp \
        code/X3DImporter_Geometry3D.cpp \
        code/X3DImporter_Group.cpp \
        code/X3DImporter_Light.cpp \
        code/X3DImporter_Metadata.cpp \
        code/X3DImporter_Networking.cpp \
        code/X3DImporter_Postprocess.cpp \
        code/X3DImporter_Rendering.cpp \
        code/X3DImporter_Shape.cpp \
        code/X3DImporter_Texturing.cpp \
        code/X3DVocabulary.cpp \
        code/XFileExporter.cpp \
        code/XFileImporter.cpp \
        code/XFileParser.cpp \
        code/XGLLoader.cpp \
        code/glTF2Exporter.cpp \
        code/glTF2Importer.cpp \
        code/glTFExporter.cpp \
        code/glTFImporter.cpp \
        code/scene.cpp \
        contrib/Open3DGC/o3dgcArithmeticCodec.cpp \
        contrib/Open3DGC/o3dgcDynamicVectorDecoder.cpp \
        contrib/Open3DGC/o3dgcDynamicVectorEncoder.cpp \
        contrib/Open3DGC/o3dgcTools.cpp \
        contrib/Open3DGC/o3dgcTriangleFans.cpp \
        contrib/clipper/clipper.cpp \
        contrib/irrXML/irrXML.cpp \
        contrib/openddlparser/code/DDLNode.cpp \
        contrib/openddlparser/code/OpenDDLCommon.cpp \
        contrib/openddlparser/code/OpenDDLExport.cpp \
        contrib/openddlparser/code/OpenDDLParser.cpp \
        contrib/openddlparser/code/OpenDDLStream.cpp \
        contrib/openddlparser/code/Value.cpp \
        contrib/poly2tri/poly2tri/common/shapes.cc \
        contrib/poly2tri/poly2tri/sweep/advancing_front.cc \
        contrib/poly2tri/poly2tri/sweep/cdt.cc \
        contrib/poly2tri/poly2tri/sweep/sweep.cc \
        contrib/poly2tri/poly2tri/sweep/sweep_context.cc \
        contrib/unzip/ioapi.c \
        contrib/unzip/unzip.c \
        contrib/zip/src/zip.c
