/****************************************************************************
**
** Copyright (C) 2006-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the example classes of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <QtGui>

#include "coloritem.h"

ColorItem::ColorItem()
    : color(rand() % 256, rand() % 256, rand() % 256)
{
    setToolTip(QString("QColor(%1, %2, %3)\n%4")
	       .arg(color.red()).arg(color.green()).arg(color.blue())
	       .arg("Click and drag this color onto the robot!"));
    setCursor(Qt::OpenHandCursor);
}

QRectF ColorItem::boundingRect() const
{
    return QRectF(-15.5, -15.5, 34, 34);
}

void ColorItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);
    painter->setPen(Qt::NoPen);
    painter->setBrush(Qt::darkGray);
    painter->drawEllipse(-12, -12, 30, 30);
    painter->setPen(QPen(Qt::black, 1));
    painter->setBrush(QBrush(color));
    painter->drawEllipse(-15, -15, 30, 30);
}

void ColorItem::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    if (event->button() != Qt::LeftButton) {
	event->ignore();
	return;
    }

    QDrag *drag = new QDrag(event->widget());
    QMimeData *mime = new QMimeData;
    drag->setMimeData(mime);

    static int n = 0;
    if (n++ > 2 && (rand() % 3) == 0) {
	QImage image(":/images/head.png");
	mime->setImageData(image);

	drag->setPixmap(QPixmap::fromImage(image).scaled(30, 40));
	drag->setHotSpot(QPoint(30, 40));
    } else {
	mime->setColorData(color);
	mime->setText(QString("#%1%2%3")
		      .arg(color.red(), 2, 16, QLatin1Char('0'))
		      .arg(color.green(), 2, 16, QLatin1Char('0'))
		      .arg(color.blue(), 2, 16, QLatin1Char('0')));

	QPixmap pixmap(34, 34);
	pixmap.fill(Qt::transparent);
	QPainter painter(&pixmap);
	painter.translate(15, 15);
	painter.setRenderHint(QPainter::Antialiasing);
	paint(&painter, 0, 0);
	painter.end();

	drag->setPixmap(pixmap);
	drag->setHotSpot(QPoint(15, 20));
    }

    drag->start();
}

