#ifndef _QEMBED_1804289383
#define _QEMBED_1804289383
#include <qimage.h>
#include <qdict.h>
static const QRgb back_data[] = {
    0x6400,0x6400,0x6300,0x6006400,0x3e006000,0xa0005d00,0xed006200,0xfb016600,0xfb016500,0xed006000,0xa0005600,0x3e005600,0x6005a00,0x5a00,
    0x5a00,0x5a00,0x6500,0x6400,0x1e006300,0xa1005f00,0xff006d00,0xff2c9b1a,0xff65c44d,0xff85d757,0xff88d859,0xff6cc651,0xff349b22,0xff026b00,
    0xa1005500,0x1e005a00,0x5a00,0x5a00,0x5f00,0x1c006200,0xc8005d00,0xff108500,0xff83d25d,0xffdaf8aa,0xfffefee8,0xfff6fde2,0xfff3fcde,0xfff8fee1,
    0xffe3fdb6,0xff97da6f,0xff1c8706,0xc8005400,0x1c005a00,0x5a00,0x7005c00,0xa0005a00,0xff148601,0xff9ae265,0xffd3f6a4,0xffcbf2a2,0xffa1dd6a,0xffb6de85,
    0xffd1edab,0xffc5ee99,0xffc6f09a,0xffd5f7a8,0xffa3e46b,0xff198504,0xa0005500,0x7005a00,0x3d005800,0xff016a00,0xff6acc38,0xffb1ed75,0xffa7e96c,0xff88d74a,
    0xffb0de81,0xfffbfcf8,0xfff8fcf3,0xffaee976,0xffa3e769,0xffa6e76c,0xffb3ee79,0xff86d64a,0xff0a6e02,0x3d005500,0xa0005700,0xff20970b,0xff88e642,0xff88e149,
    0xff6dd02e,0xffa9dc7a,0xfffefdfb,0xfffefefe,0xffc5f2a1,0xff83e144,0xff83e145,0xff85e145,0xff77da39,0xff65da2d,0xff149208,0xa0005800,0xed006100,0xff30b60f,
    0xff70de2f,0xff53ca1a,0xffa3dc77,0xfffefdfb,0xfffefefe,0xffb7e18d,0xff67c524,0xff65c526,0xff66c526,0xff4bb912,0xff1ab600,0xff00af00,0xff00a000,0xed006200,
    0xfe016600,0xff2fc308,0xff41cf0e,0xff8ed359,0xfffefdfc,0xfffefefe,0xfffdfdfd,0xffe9f5dd,0xffe4f2d8,0xffe7f2dc,0xffe6f2db,0xffddf0d3,0xff9ee191,0xff00a800,
    0xff00ac00,0xfe006500,0xfe016600,0xff17bd02,0xff19c500,0xff95dc65,0xfffefefe,0xfffdfdfd,0xfffdfdfd,0xffecf8e1,0xfff3f9e4,0xfff6fbe6,0xfff6fbe6,0xfff8fce8,
    0xffb6e9aa,0xff00a800,0xff00ac00,0xfe006500,0xed006200,0xff02aa00,0xff03bf00,0xff13c201,0xffb5eb95,0xfffefefe,0xfffefefe,0xffa8e475,0xff37c30e,0xff3dc619,
    0xff3dc619,0xff3ec619,0xff13b700,0xff00b200,0xff00a300,0xed006200,0xa0005900,0xff008d00,0xff01bf00,0xff00b500,0xff0db900,0xffb0e992,0xfffefefe,0xfff2fbe8,
    0xff59d140,0xff00b000,0xff00b100,0xff00b100,0xff00b200,0xff01bd00,0xff008d00,0xa0005a00,0x3d005700,0xff016c00,0xff0db200,0xff10bc00,0xff09b600,0xff1dbc02,
    0xffb7eb99,0xfffefefe,0xffe8f7d6,0xff22be02,0xff0bb800,0xff0eb900,0xff10bc00,0xff0db200,0xff016c00,0x3d005700,0x7005a00,0xa0005600,0xff0d8400,0xff26c204,
    0xff26c305,0xff1fbe02,0xff31c407,0xffb2e990,0xffabe78c,0xff24bf01,0xff23bf04,0xff26c305,0xff26c204,0xff0d8400,0xa0005600,0x7005a00,0x5a00,0x1c005a00,
    0xc8005600,0xff158703,0xff36be0a,0xff41d010,0xff3ac90d,0xff2fc405,0xff30c406,0xff3bc90e,0xff40d010,0xff36be0a,0xff158703,0xc8005600,0x1c005a00,0x5a00,
    0x5a00,0x5a00,0x1e005a00,0xa1005600,0xff0b6f01,0xff289808,0xff44bb10,0xff4fcb16,0xff4dc614,0xff44bb10,0xff289808,0xff0b6f01,0xa1005600,0x1e005a00,
    0x5a00,0x5a00,0x5a00,0x5a00,0x5a00,0x6005a00,0x3e005600,0xa0005a00,0xed056400,0xfb086902,0xfb076801,0xed056400,0xa0005a00,0x3e005600,
    0x6005a00,0x5a00,0x5a00,0x5a00
};

/* Generated by qembed */
static const QRgb forward_data[] = {
    0x6400,0x6400,0x6300,0x9006400,0x3e006000,0xa0005d00,0xed006200,0xfb016600,0xfb016500,0xed006000,0xa0005600,0x3e005600,0x9005a00,0x5a00,
    0x5a00,0x5a00,0x6500,0x6400,0x1e006300,0xaa005e00,0xff006f00,0xff2c9b1a,0xff65c44e,0xff85d757,0xff88d859,0xff6dc651,0xff349b22,0xff026c00,
    0xaa005500,0x1e005a00,0x5a00,0x5a00,0x5f00,0x1c006100,0xc8006100,0xff168903,0xff83d55d,0xffd8f9a9,0xfffbfee3,0xfff6fee1,0xfff2fddd,0xfff7fede,
    0xffe2fcb3,0xff96db6e,0xff1c8906,0xc8005900,0x1c005a00,0x5a00,0xa005b00,0xa9005a00,0xff148801,0xff9ee367,0xffd3f6a3,0xffc9f19e,0xffbeec8e,0xffb1d37c,
    0xffcae4a1,0xffc9f1a0,0xffc4f097,0xffd3f6a7,0xffa9e86f,0xff258d0b,0xa9005400,0xa005a00,0x3e005700,0xff016c00,0xff6acf38,0xffb0ed74,0xffa6e76c,0xffa7e86c,
    0xff97dc59,0xffecf5de,0xfffefefe,0xffe4f8d2,0xffaae872,0xffa2e767,0xffb3ee79,0xff87da4b,0xff0b7002,0x3e005500,0xa0005700,0xff20960b,0xff88e642,0xff88e14a,
    0xff84e145,0xff84e146,0xff7bdc3b,0xffb2ed86,0xfffefefb,0xfffefefe,0xffddf6c5,0xff89e049,0xff74d736,0xff67db2f,0xff16930a,0xa0005800,0xed006100,0xff30b60f,
    0xff6fde2f,0xff5bcb20,0xff66c526,0xff66c526,0xff67c627,0xff62c420,0xffa2d770,0xfffdfcf9,0xfffefefe,0xffcff0ae,0xff24b900,0xff00af00,0xff00a000,0xed006200,
    0xfe016600,0xff2fc308,0xff41d00e,0xff90ca5a,0xffe7f1dc,0xffe6f2db,0xffe6f2db,0xffe6f1da,0xffe6f2d8,0xfffdfdfc,0xfffdfdfd,0xfffefefe,0xffa1e293,0xff00a800,
    0xff00ac00,0xfe006500,0xfe016600,0xff17bd02,0xff1ac600,0xff90d663,0xfff7fce7,0xfff6fce6,0xfff6fce6,0xfff5fbe4,0xffebf7e1,0xfffdfdfc,0xfffdfdfd,0xfffefefe,
    0xffbdebb0,0xff00a800,0xff00ac00,0xfe006500,0xed006200,0xff02aa00,0xff03be00,0xff0cbf00,0xff3ecc19,0xff3ecb19,0xff3eca19,0xff30be10,0xff8bcc4f,0xfffdfdf9,
    0xfffefefe,0xffd6f1b8,0xff22bd09,0xff00b200,0xff00a300,0xed006200,0xa0005a00,0xff008d00,0xff00be00,0xff00b600,0xff00b200,0xff00b100,0xff00ab00,0xff34b51f,
    0xffe1eece,0xfffefefe,0xffcff0b0,0xff22c009,0xff00b100,0xff01bd00,0xff008d00,0xa0005a00,0x3e005600,0xff026e00,0xff0db300,0xff10bc00,0xff0eb800,0xff0db900,
    0xff11b300,0xffd6eec0,0xfffefefe,0xffd5f2b9,0xff33c30b,0xff07b600,0xff0fbc00,0xff0eb500,0xff026e00,0x3e005600,0xa005a00,0xa9005600,0xff0e8600,0xff26c204,
    0xff26c305,0xff24bf04,0xff1cbb00,0xff96e16e,0xffc3eda6,0xff48ca16,0xff1dbd00,0xff26c305,0xff26c204,0xff0e8600,0xa9005600,0xa005a00,0x5a00,0x1c005900,
    0xc8015c00,0xff168903,0xff38c00b,0xff40d010,0xff3cca0e,0xff31c407,0xff2fc304,0xff39c90d,0xff41d010,0xff38c00b,0xff168903,0xc8015c00,0x1c005900,0x5a00,
    0x5a00,0x5a00,0x1e005900,0xaa005600,0xff0d7302,0xff289808,0xff44bb10,0xff4fcb16,0xff4fcb16,0xff44bb10,0xff289808,0xff0d7302,0xaa005600,0x1e005900,
    0x5a00,0x5a00,0x5a00,0x5a00,0x5a00,0x9005a00,0x3e005600,0xa0005a00,0xed056400,0xfb086902,0xfb086902,0xed056400,0xa0005a00,0x3e005600,
    0x9005a00,0x5a00,0x5a00,0x5a00
};

static struct EmbedImage {
    int width, height, depth;
    const unsigned char *data;
    int numColors;
    const QRgb *colorTable;
    bool alpha;
    const char *name;
} embed_image_vec[] = {
    { 16, 16, 32, (const unsigned char*)back_data, 0, 0, true, "back" },
    { 16, 16, 32, (const unsigned char*)forward_data, 0, 0, true, "forward" },
    { 0, 0, 0, 0, 0, 0, 0, 0 }
};

static const QImage& qembed_findImage( const QString& name )
{
    static QDict<QImage> dict;
    QImage* img = dict.find( name );
    if ( !img ) {
	for ( int i = 0; embed_image_vec[i].data; i++ ) {
	    if ( strcmp(embed_image_vec[i].name, name.latin1()) == 0 ) {
		img = new QImage((uchar*)embed_image_vec[i].data,
			    embed_image_vec[i].width,
			    embed_image_vec[i].height,
			    embed_image_vec[i].depth,
			    (QRgb*)embed_image_vec[i].colorTable,
			    embed_image_vec[i].numColors,
			    QImage::BigEndian );
		if ( embed_image_vec[i].alpha )
		    img->setAlphaBuffer( true );
		dict.insert( name, img );
		break;
	    }
	}
	if ( !img ) {
	    static QImage dummy;
	    return dummy;
	}
    }
    return *img;
}

#endif
