/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FAKEVIDEORENDERERCONTROL_H
#define FAKEVIDEORENDERERCONTROL_H

#include <QVideoRendererControl>

class FakeCameraService;

class FakeVideoRendererControl : public QVideoRendererControl
{
Q_OBJECT
public:
    FakeVideoRendererControl(FakeCameraService *service, QObject *parent = 0);
    ~FakeVideoRendererControl();

    QAbstractVideoSurface *surface() const;
    void setSurface(QAbstractVideoSurface *surface);

    void stopViewfinder();

Q_SIGNALS:
    void surfaceChanged(QAbstractVideoSurface *surface);

private Q_SLOTS:
    void updateViewfinderFrame();

private:
    QAbstractVideoSurface *m_surface;
    FakeCameraService *m_service;
};

#endif
