/* game.c generated by valac 0.20.0, the Vala compiler
 * generated from game.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <math.h>
#include <float.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BLOCK (block_get_type ())
#define BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK, Block))
#define BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK, BlockClass))
#define IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK))
#define IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK))
#define BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK, BlockClass))

typedef struct _Block Block;
typedef struct _BlockClass BlockClass;
typedef struct _BlockPrivate BlockPrivate;
#define _block_unref0(var) ((var == NULL) ? NULL : (var = (block_unref (var), NULL)))
typedef struct _ParamSpecBlock ParamSpecBlock;

#define TYPE_SHAPE (shape_get_type ())
#define SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHAPE, Shape))
#define SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHAPE, ShapeClass))
#define IS_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHAPE))
#define IS_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHAPE))
#define SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHAPE, ShapeClass))

typedef struct _Shape Shape;
typedef struct _ShapeClass ShapeClass;
typedef struct _ShapePrivate ShapePrivate;
#define __g_list_free__block_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__block_unref0_ (var), NULL)))
#define _shape_unref0(var) ((var == NULL) ? NULL : (var = (shape_unref (var), NULL)))
typedef struct _ParamSpecShape ParamSpecShape;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _Block {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BlockPrivate * priv;
	gint x;
	gint y;
	gint color;
};

struct _BlockClass {
	GTypeClass parent_class;
	void (*finalize) (Block *self);
};

struct _ParamSpecBlock {
	GParamSpec parent_instance;
};

struct _Shape {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ShapePrivate * priv;
	gint x;
	gint y;
	gint rotation;
	gint type;
	GList* blocks;
};

struct _ShapeClass {
	GTypeClass parent_class;
	void (*finalize) (Shape *self);
};

struct _ParamSpecShape {
	GParamSpec parent_instance;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Shape* shape;
	Shape* next_shape;
	Block** blocks;
	gint blocks_length1;
	gint blocks_length2;
	gint n_lines_destroyed;
	gint score;
	gboolean game_over;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GamePrivate {
	gint starting_level;
	gboolean pick_difficult_blocks;
	gboolean fast_forward;
	guint drop_timeout;
	gboolean has_started;
	gboolean _paused;
};


static gpointer block_parent_class = NULL;
static gpointer shape_parent_class = NULL;
static gpointer game_parent_class = NULL;

#define NCOLORS 7
gpointer block_ref (gpointer instance);
void block_unref (gpointer instance);
GParamSpec* param_spec_block (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_block (GValue* value, gpointer v_object);
void value_take_block (GValue* value, gpointer v_object);
gpointer value_get_block (const GValue* value);
GType block_get_type (void) G_GNUC_CONST;
enum  {
	BLOCK_DUMMY_PROPERTY
};
Block* block_copy (Block* self);
Block* block_new (void);
Block* block_construct (GType object_type);
static void block_finalize (Block* obj);
gpointer shape_ref (gpointer instance);
void shape_unref (gpointer instance);
GParamSpec* param_spec_shape (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_shape (GValue* value, gpointer v_object);
void value_take_shape (GValue* value, gpointer v_object);
gpointer value_get_shape (const GValue* value);
GType shape_get_type (void) G_GNUC_CONST;
enum  {
	SHAPE_DUMMY_PROPERTY
};
static void _block_unref0_ (gpointer var);
static void _g_list_free__block_unref0_ (GList* self);
Shape* shape_copy (Shape* self);
Shape* shape_new (void);
Shape* shape_construct (GType object_type);
static void shape_finalize (Shape* obj);
GType game_get_type (void) G_GNUC_CONST;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_WIDTH,
	GAME_HEIGHT,
	GAME_LEVEL,
	GAME_PAUSED,
	GAME_SHADOW_Y
};
Game* game_new (gint lines, gint columns, gint starting_level, gint filled_lines, gint fill_prob, gboolean pick_difficult_blocks);
Game* game_construct (GType object_type, gint lines, gint columns, gint starting_level, gint filled_lines, gint fill_prob, gboolean pick_difficult_blocks);
gint game_get_height (Game* self);
gint game_get_width (Game* self);
static Shape* game_pick_random_shape (Game* self);
Game* game_copy (Game* self);
void game_start (Game* self);
static void game_add_shape (Game* self);
static void game_setup_drop_timer (Game* self);
gboolean game_move_left (Game* self);
static gboolean game_move_shape (Game* self, gint x_step, gint y_step, gint r_step);
gboolean game_move_right (Game* self);
gboolean game_rotate_left (Game* self);
gboolean game_rotate_right (Game* self);
void game_set_fast_forward (Game* self, gboolean enable);
void game_drop (Game* self);
static gboolean game_fall_timeout_cb (Game* self);
void game_stop (Game* self);
gint game_get_level (Game* self);
gboolean game_get_paused (Game* self);
static gboolean _game_fall_timeout_cb_gsource_func (gpointer self);
static void game_land_shape (Game* self);
static Shape* game_pick_difficult_shape (Game* self);
static Shape* game_make_shape (Game* self, gint type, gint rotation);
static void game_rotate_shape (Game* self, gint r_step);
void game_set_paused (Game* self, gboolean value);
gint game_get_shadow_y (Game* self);
static void g_cclosure_user_marshal_VOID__POINTER_INT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gint block_table[448] = {0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0};

Block* block_copy (Block* self) {
	Block* result = NULL;
	Block* _tmp0_;
	Block* b;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = block_new ();
	b = _tmp0_;
	_tmp1_ = self->x;
	b->x = _tmp1_;
	_tmp2_ = self->y;
	b->y = _tmp2_;
	_tmp3_ = self->color;
	b->color = _tmp3_;
	result = b;
	return result;
}


Block* block_construct (GType object_type) {
	Block* self = NULL;
	self = (Block*) g_type_create_instance (object_type);
	return self;
}


Block* block_new (void) {
	return block_construct (TYPE_BLOCK);
}


static void value_block_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_block_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		block_unref (value->data[0].v_pointer);
	}
}


static void value_block_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = block_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_block_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_block_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Block* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = block_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_block_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Block** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = block_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_block (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBlock* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BLOCK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_block (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BLOCK), NULL);
	return value->data[0].v_pointer;
}


void value_set_block (GValue* value, gpointer v_object) {
	Block* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BLOCK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BLOCK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		block_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		block_unref (old);
	}
}


void value_take_block (GValue* value, gpointer v_object) {
	Block* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BLOCK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BLOCK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		block_unref (old);
	}
}


static void block_class_init (BlockClass * klass) {
	block_parent_class = g_type_class_peek_parent (klass);
	BLOCK_CLASS (klass)->finalize = block_finalize;
}


static void block_instance_init (Block * self) {
	self->ref_count = 1;
}


static void block_finalize (Block* obj) {
	Block * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLOCK, Block);
}


GType block_get_type (void) {
	static volatile gsize block_type_id__volatile = 0;
	if (g_once_init_enter (&block_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_block_init, value_block_free_value, value_block_copy_value, value_block_peek_pointer, "p", value_block_collect_value, "p", value_block_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Block), 0, (GInstanceInitFunc) block_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType block_type_id;
		block_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Block", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&block_type_id__volatile, block_type_id);
	}
	return block_type_id__volatile;
}


gpointer block_ref (gpointer instance) {
	Block* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void block_unref (gpointer instance) {
	Block* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BLOCK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _block_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (block_unref (var), NULL));
}


static void _g_list_free__block_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _block_unref0_, NULL);
	g_list_free (self);
}


static gpointer _block_ref0 (gpointer self) {
	return self ? block_ref (self) : NULL;
}


Shape* shape_copy (Shape* self) {
	Shape* result = NULL;
	Shape* _tmp0_;
	Shape* s;
	Shape* _tmp1_;
	gint _tmp2_;
	Shape* _tmp3_;
	gint _tmp4_;
	Shape* _tmp5_;
	gint _tmp6_;
	Shape* _tmp7_;
	gint _tmp8_;
	GList* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = shape_new ();
	s = _tmp0_;
	_tmp1_ = s;
	_tmp2_ = self->x;
	_tmp1_->x = _tmp2_;
	_tmp3_ = s;
	_tmp4_ = self->y;
	_tmp3_->y = _tmp4_;
	_tmp5_ = s;
	_tmp6_ = self->rotation;
	_tmp5_->rotation = _tmp6_;
	_tmp7_ = s;
	_tmp8_ = self->type;
	_tmp7_->type = _tmp8_;
	_tmp9_ = self->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp9_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp10_;
			Block* b = NULL;
			_tmp10_ = _block_ref0 ((Block*) b_it->data);
			b = _tmp10_;
			{
				Shape* _tmp11_;
				Block* _tmp12_;
				Block* _tmp13_ = NULL;
				_tmp11_ = s;
				_tmp12_ = b;
				_tmp13_ = block_copy (_tmp12_);
				_tmp11_->blocks = g_list_append (_tmp11_->blocks, _tmp13_);
				_block_unref0 (b);
			}
		}
	}
	result = s;
	return result;
}


Shape* shape_construct (GType object_type) {
	Shape* self = NULL;
	self = (Shape*) g_type_create_instance (object_type);
	return self;
}


Shape* shape_new (void) {
	return shape_construct (TYPE_SHAPE);
}


static void value_shape_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_shape_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		shape_unref (value->data[0].v_pointer);
	}
}


static void value_shape_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = shape_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_shape_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_shape_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Shape* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = shape_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_shape_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Shape** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = shape_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_shape (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecShape* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SHAPE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_shape (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SHAPE), NULL);
	return value->data[0].v_pointer;
}


void value_set_shape (GValue* value, gpointer v_object) {
	Shape* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SHAPE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SHAPE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		shape_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		shape_unref (old);
	}
}


void value_take_shape (GValue* value, gpointer v_object) {
	Shape* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SHAPE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SHAPE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		shape_unref (old);
	}
}


static void shape_class_init (ShapeClass * klass) {
	shape_parent_class = g_type_class_peek_parent (klass);
	SHAPE_CLASS (klass)->finalize = shape_finalize;
}


static void shape_instance_init (Shape * self) {
	self->blocks = NULL;
	self->ref_count = 1;
}


static void shape_finalize (Shape* obj) {
	Shape * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHAPE, Shape);
	__g_list_free__block_unref0_0 (self->blocks);
}


GType shape_get_type (void) {
	static volatile gsize shape_type_id__volatile = 0;
	if (g_once_init_enter (&shape_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_shape_init, value_shape_free_value, value_shape_copy_value, value_shape_peek_pointer, "p", value_shape_collect_value, "p", value_shape_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ShapeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shape_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Shape), 0, (GInstanceInitFunc) shape_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType shape_type_id;
		shape_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Shape", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&shape_type_id__volatile, shape_type_id);
	}
	return shape_type_id__volatile;
}


gpointer shape_ref (gpointer instance) {
	Shape* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void shape_unref (gpointer instance) {
	Shape* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SHAPE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


Game* game_construct (GType object_type, gint lines, gint columns, gint starting_level, gint filled_lines, gint fill_prob, gboolean pick_difficult_blocks) {
	Game * self = NULL;
	gint _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Block** _tmp4_ = NULL;
	gboolean _tmp56_;
	self = (Game*) g_object_new (object_type, NULL);
	_tmp0_ = starting_level;
	self->priv->starting_level = _tmp0_;
	_tmp1_ = pick_difficult_blocks;
	self->priv->pick_difficult_blocks = _tmp1_;
	_tmp2_ = columns;
	_tmp3_ = lines;
	_tmp4_ = g_new0 (Block*, (_tmp2_ * _tmp3_) + 1);
	self->blocks = (_vala_array_free (self->blocks, self->blocks_length1 * self->blocks_length2, (GDestroyNotify) block_unref), NULL);
	self->blocks = _tmp4_;
	self->blocks_length1 = _tmp2_;
	self->blocks_length2 = _tmp3_;
	{
		gint y;
		y = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint32 _tmp13_ = 0;
				gint32 blank;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = y;
					y = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = y;
				_tmp9_ = game_get_height (self);
				_tmp10_ = _tmp9_;
				if (!(_tmp8_ < _tmp10_)) {
					break;
				}
				_tmp11_ = game_get_width (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_random_int_range ((gint32) 0, (gint32) _tmp12_);
				blank = _tmp13_;
				{
					gint x;
					x = 0;
					{
						gboolean _tmp14_;
						_tmp14_ = TRUE;
						while (TRUE) {
							gboolean _tmp15_;
							gint _tmp17_;
							gint _tmp18_;
							gint _tmp19_;
							gboolean _tmp20_ = FALSE;
							gboolean _tmp21_ = FALSE;
							gint _tmp22_;
							gint _tmp23_;
							gint _tmp24_;
							gint _tmp25_;
							gboolean _tmp28_;
							gboolean _tmp31_;
							_tmp15_ = _tmp14_;
							if (!_tmp15_) {
								gint _tmp16_;
								_tmp16_ = x;
								x = _tmp16_ + 1;
							}
							_tmp14_ = FALSE;
							_tmp17_ = x;
							_tmp18_ = game_get_width (self);
							_tmp19_ = _tmp18_;
							if (!(_tmp17_ < _tmp19_)) {
								break;
							}
							_tmp22_ = y;
							_tmp23_ = game_get_height (self);
							_tmp24_ = _tmp23_;
							_tmp25_ = filled_lines;
							if (_tmp22_ >= (_tmp24_ - _tmp25_)) {
								gint _tmp26_;
								gint32 _tmp27_;
								_tmp26_ = x;
								_tmp27_ = blank;
								_tmp21_ = _tmp26_ != ((gint) _tmp27_);
							} else {
								_tmp21_ = FALSE;
							}
							_tmp28_ = _tmp21_;
							if (_tmp28_) {
								gint32 _tmp29_ = 0;
								gint _tmp30_;
								_tmp29_ = g_random_int_range ((gint32) 0, (gint32) 10);
								_tmp30_ = fill_prob;
								_tmp20_ = _tmp29_ < ((gint32) _tmp30_);
							} else {
								_tmp20_ = FALSE;
							}
							_tmp31_ = _tmp20_;
							if (_tmp31_) {
								Block** _tmp32_;
								gint _tmp32__length1;
								gint _tmp32__length2;
								gint _tmp33_;
								gint _tmp34_;
								Block* _tmp35_;
								Block* _tmp36_;
								Block** _tmp37_;
								gint _tmp37__length1;
								gint _tmp37__length2;
								gint _tmp38_;
								gint _tmp39_;
								Block* _tmp40_;
								gint _tmp41_;
								Block** _tmp42_;
								gint _tmp42__length1;
								gint _tmp42__length2;
								gint _tmp43_;
								gint _tmp44_;
								Block* _tmp45_;
								gint _tmp46_;
								Block** _tmp47_;
								gint _tmp47__length1;
								gint _tmp47__length2;
								gint _tmp48_;
								gint _tmp49_;
								Block* _tmp50_;
								gint32 _tmp51_ = 0;
								_tmp32_ = self->blocks;
								_tmp32__length1 = self->blocks_length1;
								_tmp32__length2 = self->blocks_length2;
								_tmp33_ = x;
								_tmp34_ = y;
								_tmp35_ = block_new ();
								_block_unref0 (_tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_]);
								_tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_] = _tmp35_;
								_tmp36_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
								_tmp37_ = self->blocks;
								_tmp37__length1 = self->blocks_length1;
								_tmp37__length2 = self->blocks_length2;
								_tmp38_ = x;
								_tmp39_ = y;
								_tmp40_ = _tmp37_[(_tmp38_ * _tmp37__length2) + _tmp39_];
								_tmp41_ = x;
								_tmp40_->x = _tmp41_;
								_tmp42_ = self->blocks;
								_tmp42__length1 = self->blocks_length1;
								_tmp42__length2 = self->blocks_length2;
								_tmp43_ = x;
								_tmp44_ = y;
								_tmp45_ = _tmp42_[(_tmp43_ * _tmp42__length2) + _tmp44_];
								_tmp46_ = y;
								_tmp45_->y = _tmp46_;
								_tmp47_ = self->blocks;
								_tmp47__length1 = self->blocks_length1;
								_tmp47__length2 = self->blocks_length2;
								_tmp48_ = x;
								_tmp49_ = y;
								_tmp50_ = _tmp47_[(_tmp48_ * _tmp47__length2) + _tmp49_];
								_tmp51_ = g_random_int_range ((gint32) 0, (gint32) NCOLORS);
								_tmp50_->color = (gint) _tmp51_;
							} else {
								Block** _tmp52_;
								gint _tmp52__length1;
								gint _tmp52__length2;
								gint _tmp53_;
								gint _tmp54_;
								Block* _tmp55_;
								_tmp52_ = self->blocks;
								_tmp52__length1 = self->blocks_length1;
								_tmp52__length2 = self->blocks_length2;
								_tmp53_ = x;
								_tmp54_ = y;
								_block_unref0 (_tmp52_[(_tmp53_ * _tmp52__length2) + _tmp54_]);
								_tmp52_[(_tmp53_ * _tmp52__length2) + _tmp54_] = NULL;
								_tmp55_ = _tmp52_[(_tmp53_ * _tmp52__length2) + _tmp54_];
							}
						}
					}
				}
			}
		}
	}
	_tmp56_ = pick_difficult_blocks;
	if (!_tmp56_) {
		Shape* _tmp57_ = NULL;
		_tmp57_ = game_pick_random_shape (self);
		_shape_unref0 (self->next_shape);
		self->next_shape = _tmp57_;
	}
	return self;
}


Game* game_new (gint lines, gint columns, gint starting_level, gint filled_lines, gint fill_prob, gboolean pick_difficult_blocks) {
	return game_construct (TYPE_GAME, lines, columns, starting_level, filled_lines, fill_prob, pick_difficult_blocks);
}


Game* game_copy (Game* self) {
	Game* result = NULL;
	Game* _tmp0_;
	Game* g;
	Shape* _tmp1_;
	Shape* _tmp5_;
	Game* _tmp35_;
	gint _tmp36_;
	Game* _tmp37_;
	gint _tmp38_;
	Game* _tmp39_;
	gint _tmp40_;
	Game* _tmp41_;
	gboolean _tmp42_;
	Game* _tmp43_;
	gboolean _tmp44_;
	Game* _tmp45_;
	gboolean _tmp46_;
	Game* _tmp47_;
	gboolean _tmp48_;
	Game* _tmp49_;
	gboolean _tmp50_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = game_new (20, 14, 1, 0, 5, FALSE);
	g = _tmp0_;
	_tmp1_ = self->shape;
	if (_tmp1_ != NULL) {
		Game* _tmp2_;
		Shape* _tmp3_;
		Shape* _tmp4_ = NULL;
		_tmp2_ = g;
		_tmp3_ = self->shape;
		_tmp4_ = shape_copy (_tmp3_);
		_shape_unref0 (_tmp2_->shape);
		_tmp2_->shape = _tmp4_;
	}
	_tmp5_ = self->next_shape;
	if (_tmp5_ != NULL) {
		Game* _tmp6_;
		Shape* _tmp7_;
		Shape* _tmp8_ = NULL;
		_tmp6_ = g;
		_tmp7_ = self->next_shape;
		_tmp8_ = shape_copy (_tmp7_);
		_shape_unref0 (_tmp6_->next_shape);
		_tmp6_->next_shape = _tmp8_;
	}
	{
		gint x;
		x = 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = x;
					x = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = x;
				_tmp13_ = game_get_width (self);
				_tmp14_ = _tmp13_;
				if (!(_tmp12_ < _tmp14_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp15_;
						_tmp15_ = TRUE;
						while (TRUE) {
							gboolean _tmp16_;
							gint _tmp18_;
							gint _tmp19_;
							gint _tmp20_;
							Block** _tmp21_;
							gint _tmp21__length1;
							gint _tmp21__length2;
							gint _tmp22_;
							gint _tmp23_;
							Block* _tmp24_;
							_tmp16_ = _tmp15_;
							if (!_tmp16_) {
								gint _tmp17_;
								_tmp17_ = y;
								y = _tmp17_ + 1;
							}
							_tmp15_ = FALSE;
							_tmp18_ = y;
							_tmp19_ = game_get_height (self);
							_tmp20_ = _tmp19_;
							if (!(_tmp18_ < _tmp20_)) {
								break;
							}
							_tmp21_ = self->blocks;
							_tmp21__length1 = self->blocks_length1;
							_tmp21__length2 = self->blocks_length2;
							_tmp22_ = x;
							_tmp23_ = y;
							_tmp24_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
							if (_tmp24_ != NULL) {
								Game* _tmp25_;
								Block** _tmp26_;
								gint _tmp26__length1;
								gint _tmp26__length2;
								gint _tmp27_;
								gint _tmp28_;
								Block** _tmp29_;
								gint _tmp29__length1;
								gint _tmp29__length2;
								gint _tmp30_;
								gint _tmp31_;
								Block* _tmp32_;
								Block* _tmp33_ = NULL;
								Block* _tmp34_;
								_tmp25_ = g;
								_tmp26_ = _tmp25_->blocks;
								_tmp26__length1 = _tmp25_->blocks_length1;
								_tmp26__length2 = _tmp25_->blocks_length2;
								_tmp27_ = x;
								_tmp28_ = y;
								_tmp29_ = self->blocks;
								_tmp29__length1 = self->blocks_length1;
								_tmp29__length2 = self->blocks_length2;
								_tmp30_ = x;
								_tmp31_ = y;
								_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
								_tmp33_ = block_copy (_tmp32_);
								_block_unref0 (_tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_]);
								_tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_] = _tmp33_;
								_tmp34_ = _tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_];
							}
						}
					}
				}
			}
		}
	}
	_tmp35_ = g;
	_tmp36_ = self->n_lines_destroyed;
	_tmp35_->n_lines_destroyed = _tmp36_;
	_tmp37_ = g;
	_tmp38_ = self->score;
	_tmp37_->score = _tmp38_;
	_tmp39_ = g;
	_tmp40_ = self->priv->starting_level;
	_tmp39_->priv->starting_level = _tmp40_;
	_tmp41_ = g;
	_tmp42_ = self->priv->pick_difficult_blocks;
	_tmp41_->priv->pick_difficult_blocks = _tmp42_;
	_tmp43_ = g;
	_tmp44_ = self->priv->fast_forward;
	_tmp43_->priv->fast_forward = _tmp44_;
	_tmp45_ = g;
	_tmp46_ = self->priv->has_started;
	_tmp45_->priv->has_started = _tmp46_;
	_tmp47_ = g;
	_tmp48_ = self->priv->_paused;
	_tmp47_->priv->_paused = _tmp48_;
	_tmp49_ = g;
	_tmp50_ = self->game_over;
	_tmp49_->game_over = _tmp50_;
	result = g;
	return result;
}


void game_start (Game* self) {
	g_return_if_fail (self != NULL);
	self->priv->has_started = TRUE;
	game_add_shape (self);
	game_setup_drop_timer (self);
	g_signal_emit_by_name (self, "started");
}


gboolean game_move_left (Game* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_move_shape (self, -1, 0, 0);
	result = _tmp0_;
	return result;
}


gboolean game_move_right (Game* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_move_shape (self, 1, 0, 0);
	result = _tmp0_;
	return result;
}


gboolean game_rotate_left (Game* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_move_shape (self, 0, 0, -1);
	result = _tmp0_;
	return result;
}


gboolean game_rotate_right (Game* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_move_shape (self, 0, 0, 1);
	result = _tmp0_;
	return result;
}


void game_set_fast_forward (Game* self, gboolean enable) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fast_forward;
	_tmp1_ = enable;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = enable;
	self->priv->fast_forward = _tmp2_;
	game_setup_drop_timer (self);
}


void game_drop (Game* self) {
	Shape* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->shape;
	if (_tmp0_ == NULL) {
		return;
	}
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = game_move_shape (self, 0, 1, 0);
		if (!_tmp1_) {
			break;
		}
	}
	game_fall_timeout_cb (self);
}


void game_stop (Game* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->drop_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->drop_timeout;
		g_source_remove (_tmp1_);
	}
}


static gboolean _game_fall_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = game_fall_timeout_cb (self);
	return result;
}


static void game_setup_drop_timer (Game* self) {
	gint _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gint timestep;
	gint _tmp4_;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	guint _tmp7_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_get_level (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = pow (0.75, (gdouble) (_tmp1_ - 1));
	_tmp3_ = round (80 + (800.0 * _tmp2_));
	timestep = (gint) _tmp3_;
	_tmp4_ = timestep;
	_tmp5_ = MAX (10, _tmp4_);
	timestep = _tmp5_;
	_tmp6_ = self->priv->fast_forward;
	if (_tmp6_) {
		timestep = 80;
	}
	_tmp7_ = self->priv->drop_timeout;
	if (_tmp7_ != ((guint) 0)) {
		guint _tmp8_;
		_tmp8_ = self->priv->drop_timeout;
		g_source_remove (_tmp8_);
	}
	self->priv->drop_timeout = (guint) 0;
	_tmp9_ = game_get_paused (self);
	_tmp10_ = _tmp9_;
	if (!_tmp10_) {
		gint _tmp11_;
		guint _tmp12_ = 0U;
		_tmp11_ = timestep;
		_tmp12_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp11_, _game_fall_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->drop_timeout = _tmp12_;
	}
}


static gboolean game_fall_timeout_cb (Game* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_move_shape (self, 0, 1, 0);
	if (!_tmp0_) {
		game_land_shape (self);
		game_add_shape (self);
	}
	result = TRUE;
	return result;
}


static void game_add_shape (Game* self) {
	gboolean _tmp0_;
	Shape* _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pick_difficult_blocks;
	if (_tmp0_) {
		Shape* _tmp1_ = NULL;
		_tmp1_ = game_pick_difficult_shape (self);
		_shape_unref0 (self->shape);
		self->shape = _tmp1_;
	} else {
		Shape* _tmp2_;
		Shape* _tmp3_ = NULL;
		_tmp2_ = self->next_shape;
		self->next_shape = NULL;
		_shape_unref0 (self->shape);
		self->shape = _tmp2_;
		_tmp3_ = game_pick_random_shape (self);
		_shape_unref0 (self->next_shape);
		self->next_shape = _tmp3_;
	}
	_tmp4_ = self->shape;
	_tmp5_ = _tmp4_->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp5_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp6_;
			Block* b = NULL;
			_tmp6_ = _block_ref0 ((Block*) b_it->data);
			b = _tmp6_;
			{
				Shape* _tmp7_;
				gint _tmp8_;
				Block* _tmp9_;
				gint _tmp10_;
				gint x;
				Shape* _tmp11_;
				gint _tmp12_;
				Block* _tmp13_;
				gint _tmp14_;
				gint y;
				gboolean _tmp15_ = FALSE;
				gint _tmp16_;
				gboolean _tmp21_;
				_tmp7_ = self->shape;
				_tmp8_ = _tmp7_->x;
				_tmp9_ = b;
				_tmp10_ = _tmp9_->x;
				x = _tmp8_ + _tmp10_;
				_tmp11_ = self->shape;
				_tmp12_ = _tmp11_->y;
				_tmp13_ = b;
				_tmp14_ = _tmp13_->y;
				y = _tmp12_ + _tmp14_;
				_tmp16_ = y;
				if (_tmp16_ >= 0) {
					Block** _tmp17_;
					gint _tmp17__length1;
					gint _tmp17__length2;
					gint _tmp18_;
					gint _tmp19_;
					Block* _tmp20_;
					_tmp17_ = self->blocks;
					_tmp17__length1 = self->blocks_length1;
					_tmp17__length2 = self->blocks_length2;
					_tmp18_ = x;
					_tmp19_ = y;
					_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
					_tmp15_ = _tmp20_ != NULL;
				} else {
					_tmp15_ = FALSE;
				}
				_tmp21_ = _tmp15_;
				if (_tmp21_) {
					guint _tmp22_;
					_tmp22_ = self->priv->drop_timeout;
					if (_tmp22_ != ((guint) 0)) {
						guint _tmp23_;
						_tmp23_ = self->priv->drop_timeout;
						g_source_remove (_tmp23_);
					}
					self->priv->drop_timeout = (guint) 0;
					_shape_unref0 (self->shape);
					self->shape = NULL;
					self->game_over = TRUE;
					g_signal_emit_by_name (self, "complete");
					_block_unref0 (b);
					return;
				}
				_block_unref0 (b);
			}
		}
	}
	g_signal_emit_by_name (self, "shape-added");
}


static Shape* game_pick_random_shape (Game* self) {
	Shape* result = NULL;
	gint32 _tmp0_ = 0;
	gint32 _tmp1_ = 0;
	Shape* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_random_int_range ((gint32) 0, (gint32) NCOLORS);
	_tmp1_ = g_random_int_range ((gint32) 0, (gint32) 4);
	_tmp2_ = game_make_shape (self, (gint) _tmp0_, (gint) _tmp1_);
	result = _tmp2_;
	return result;
}


static Shape* game_pick_difficult_shape (Game* self) {
	Shape* result = NULL;
	gint* _tmp0_ = NULL;
	gint* metrics;
	gint metrics_length1;
	gint _metrics_size_;
	gint* _tmp78_ = NULL;
	gint* possible_types;
	gint possible_types_length1;
	gint _possible_types_size_;
	gint32 _tmp118_ = 0;
	gint32 rnd;
	gint32 _tmp119_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gint, NCOLORS);
	metrics = _tmp0_;
	metrics_length1 = NCOLORS;
	_metrics_size_ = metrics_length1;
	{
		gint type;
		type = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				gint _tmp7_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = type;
					type = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = type;
				if (!(_tmp4_ < NCOLORS)) {
					break;
				}
				_tmp5_ = metrics;
				_tmp5__length1 = metrics_length1;
				_tmp6_ = type;
				_tmp5_[_tmp6_] = -32000;
				_tmp7_ = _tmp5_[_tmp6_];
				{
					gint rotation;
					rotation = 0;
					{
						gboolean _tmp8_;
						_tmp8_ = TRUE;
						while (TRUE) {
							gboolean _tmp9_;
							gint _tmp11_;
							_tmp9_ = _tmp8_;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = rotation;
								rotation = _tmp10_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp11_ = rotation;
							if (!(_tmp11_ < 4)) {
								break;
							}
							{
								gint pos;
								pos = 0;
								{
									gboolean _tmp12_;
									_tmp12_ = TRUE;
									while (TRUE) {
										gboolean _tmp13_;
										gint _tmp15_;
										gint _tmp16_;
										gint _tmp17_;
										Game* _tmp18_ = NULL;
										Game* g;
										Game* _tmp19_;
										Game* _tmp20_;
										gint _tmp21_;
										gint _tmp22_;
										Shape* _tmp23_ = NULL;
										gboolean valid_position;
										gboolean _tmp33_;
										Game* _tmp34_;
										gint _tmp35_;
										gint orig_lines;
										Game* _tmp36_;
										Game* _tmp37_;
										gint _tmp38_;
										gint _tmp39_;
										gint metric;
										gint _tmp61_;
										gint* _tmp62_;
										gint _tmp62__length1;
										gint _tmp63_;
										gint _tmp64_;
										Game* _tmp69_;
										_tmp13_ = _tmp12_;
										if (!_tmp13_) {
											gint _tmp14_;
											_tmp14_ = pos;
											pos = _tmp14_ + 1;
										}
										_tmp12_ = FALSE;
										_tmp15_ = pos;
										_tmp16_ = game_get_width (self);
										_tmp17_ = _tmp16_;
										if (!(_tmp15_ < _tmp17_)) {
											break;
										}
										_tmp18_ = game_copy (self);
										g = _tmp18_;
										_tmp19_ = g;
										_tmp19_->priv->pick_difficult_blocks = FALSE;
										_tmp20_ = g;
										_tmp21_ = type;
										_tmp22_ = rotation;
										_tmp23_ = game_make_shape (self, _tmp21_, _tmp22_);
										_shape_unref0 (_tmp20_->shape);
										_tmp20_->shape = _tmp23_;
										valid_position = TRUE;
										while (TRUE) {
											Game* _tmp24_;
											gboolean _tmp25_ = FALSE;
											_tmp24_ = g;
											_tmp25_ = game_move_left (_tmp24_);
											if (!_tmp25_) {
												break;
											}
										}
										{
											gint x;
											x = 0;
											{
												gboolean _tmp26_;
												_tmp26_ = TRUE;
												while (TRUE) {
													gboolean _tmp27_;
													gint _tmp29_;
													gint _tmp30_;
													Game* _tmp31_;
													gboolean _tmp32_ = FALSE;
													_tmp27_ = _tmp26_;
													if (!_tmp27_) {
														gint _tmp28_;
														_tmp28_ = x;
														x = _tmp28_ + 1;
													}
													_tmp26_ = FALSE;
													_tmp29_ = x;
													_tmp30_ = pos;
													if (!(_tmp29_ < _tmp30_)) {
														break;
													}
													_tmp31_ = g;
													_tmp32_ = game_move_right (_tmp31_);
													if (!_tmp32_) {
														valid_position = FALSE;
														break;
													}
												}
											}
										}
										_tmp33_ = valid_position;
										if (!_tmp33_) {
											_g_object_unref0 (g);
											break;
										}
										_tmp34_ = g;
										_tmp35_ = _tmp34_->n_lines_destroyed;
										orig_lines = _tmp35_;
										_tmp36_ = g;
										game_drop (_tmp36_);
										_tmp37_ = g;
										_tmp38_ = _tmp37_->n_lines_destroyed;
										_tmp39_ = orig_lines;
										metric = (_tmp38_ - _tmp39_) * 5000;
										{
											gint x;
											x = 0;
											{
												gboolean _tmp40_;
												_tmp40_ = TRUE;
												while (TRUE) {
													gboolean _tmp41_;
													gint _tmp43_;
													gint _tmp44_;
													gint _tmp45_;
													gint y = 0;
													gint _tmp57_;
													gint _tmp58_;
													gint _tmp59_;
													gint _tmp60_;
													_tmp41_ = _tmp40_;
													if (!_tmp41_) {
														gint _tmp42_;
														_tmp42_ = x;
														x = _tmp42_ + 1;
													}
													_tmp40_ = FALSE;
													_tmp43_ = x;
													_tmp44_ = game_get_width (self);
													_tmp45_ = _tmp44_;
													if (!(_tmp43_ < _tmp45_)) {
														break;
													}
													{
														gboolean _tmp46_;
														y = 0;
														_tmp46_ = TRUE;
														while (TRUE) {
															gboolean _tmp47_;
															gint _tmp49_;
															gint _tmp50_;
															gint _tmp51_;
															Game* _tmp52_;
															Block** _tmp53_;
															gint _tmp53__length1;
															gint _tmp53__length2;
															gint _tmp54_;
															gint _tmp55_;
															Block* _tmp56_;
															_tmp47_ = _tmp46_;
															if (!_tmp47_) {
																gint _tmp48_;
																_tmp48_ = y;
																y = _tmp48_ + 1;
															}
															_tmp46_ = FALSE;
															_tmp49_ = y;
															_tmp50_ = game_get_height (self);
															_tmp51_ = _tmp50_;
															if (!(_tmp49_ < _tmp51_)) {
																break;
															}
															_tmp52_ = g;
															_tmp53_ = _tmp52_->blocks;
															_tmp53__length1 = _tmp52_->blocks_length1;
															_tmp53__length2 = _tmp52_->blocks_length2;
															_tmp54_ = x;
															_tmp55_ = y;
															_tmp56_ = _tmp53_[(_tmp54_ * _tmp53__length2) + _tmp55_];
															if (_tmp56_ != NULL) {
																break;
															}
														}
													}
													_tmp57_ = metric;
													_tmp58_ = game_get_height (self);
													_tmp59_ = _tmp58_;
													_tmp60_ = y;
													metric = _tmp57_ - (5 * (_tmp59_ - _tmp60_));
												}
											}
										}
										_tmp61_ = metric;
										_tmp62_ = metrics;
										_tmp62__length1 = metrics_length1;
										_tmp63_ = type;
										_tmp64_ = _tmp62_[_tmp63_];
										if (_tmp61_ > _tmp64_) {
											gint* _tmp65_;
											gint _tmp65__length1;
											gint _tmp66_;
											gint _tmp67_;
											gint _tmp68_;
											_tmp65_ = metrics;
											_tmp65__length1 = metrics_length1;
											_tmp66_ = type;
											_tmp67_ = metric;
											_tmp65_[_tmp66_] = _tmp67_;
											_tmp68_ = _tmp65_[_tmp66_];
										}
										_tmp69_ = g;
										game_stop (_tmp69_);
										_g_object_unref0 (g);
									}
								}
							}
						}
					}
				}
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp70_;
			_tmp70_ = TRUE;
			while (TRUE) {
				gboolean _tmp71_;
				gint _tmp73_;
				gint* _tmp74_;
				gint _tmp74__length1;
				gint _tmp75_;
				gint32 _tmp76_ = 0;
				gint _tmp77_;
				_tmp71_ = _tmp70_;
				if (!_tmp71_) {
					gint _tmp72_;
					_tmp72_ = i;
					i = _tmp72_ + 1;
				}
				_tmp70_ = FALSE;
				_tmp73_ = i;
				if (!(_tmp73_ < NCOLORS)) {
					break;
				}
				_tmp74_ = metrics;
				_tmp74__length1 = metrics_length1;
				_tmp75_ = i;
				_tmp76_ = g_random_int_range ((gint32) (-2), (gint32) 2);
				_tmp74_[_tmp75_] += (gint) _tmp76_;
				_tmp77_ = _tmp74_[_tmp75_];
			}
		}
	}
	_tmp78_ = g_new0 (gint, NCOLORS);
	possible_types = _tmp78_;
	possible_types_length1 = NCOLORS;
	_possible_types_size_ = possible_types_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp79_;
			_tmp79_ = TRUE;
			while (TRUE) {
				gboolean _tmp80_;
				gint _tmp82_;
				gint* _tmp83_;
				gint _tmp83__length1;
				gint _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				_tmp80_ = _tmp79_;
				if (!_tmp80_) {
					gint _tmp81_;
					_tmp81_ = i;
					i = _tmp81_ + 1;
				}
				_tmp79_ = FALSE;
				_tmp82_ = i;
				if (!(_tmp82_ < NCOLORS)) {
					break;
				}
				_tmp83_ = possible_types;
				_tmp83__length1 = possible_types_length1;
				_tmp84_ = i;
				_tmp85_ = i;
				_tmp83_[_tmp84_] = _tmp85_;
				_tmp86_ = _tmp83_[_tmp84_];
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp87_;
			_tmp87_ = TRUE;
			while (TRUE) {
				gboolean _tmp88_;
				gint _tmp90_;
				_tmp88_ = _tmp87_;
				if (!_tmp88_) {
					gint _tmp89_;
					_tmp89_ = i;
					i = _tmp89_ + 1;
				}
				_tmp87_ = FALSE;
				_tmp90_ = i;
				if (!(_tmp90_ < NCOLORS)) {
					break;
				}
				{
					gint j;
					j = 0;
					{
						gboolean _tmp91_;
						_tmp91_ = TRUE;
						while (TRUE) {
							gboolean _tmp92_;
							gint _tmp94_;
							gint* _tmp95_;
							gint _tmp95__length1;
							gint* _tmp96_;
							gint _tmp96__length1;
							gint _tmp97_;
							gint _tmp98_;
							gint _tmp99_;
							gint* _tmp100_;
							gint _tmp100__length1;
							gint* _tmp101_;
							gint _tmp101__length1;
							gint _tmp102_;
							gint _tmp103_;
							gint _tmp104_;
							_tmp92_ = _tmp91_;
							if (!_tmp92_) {
								gint _tmp93_;
								_tmp93_ = j;
								j = _tmp93_ + 1;
							}
							_tmp91_ = FALSE;
							_tmp94_ = j;
							if (!(_tmp94_ < (NCOLORS - 1))) {
								break;
							}
							_tmp95_ = metrics;
							_tmp95__length1 = metrics_length1;
							_tmp96_ = possible_types;
							_tmp96__length1 = possible_types_length1;
							_tmp97_ = j;
							_tmp98_ = _tmp96_[_tmp97_];
							_tmp99_ = _tmp95_[_tmp98_];
							_tmp100_ = metrics;
							_tmp100__length1 = metrics_length1;
							_tmp101_ = possible_types;
							_tmp101__length1 = possible_types_length1;
							_tmp102_ = j;
							_tmp103_ = _tmp101_[_tmp102_ + 1];
							_tmp104_ = _tmp100_[_tmp103_];
							if (_tmp99_ > _tmp104_) {
								gint* _tmp105_;
								gint _tmp105__length1;
								gint _tmp106_;
								gint _tmp107_;
								gint t;
								gint* _tmp108_;
								gint _tmp108__length1;
								gint _tmp109_;
								gint* _tmp110_;
								gint _tmp110__length1;
								gint _tmp111_;
								gint _tmp112_;
								gint _tmp113_;
								gint* _tmp114_;
								gint _tmp114__length1;
								gint _tmp115_;
								gint _tmp116_;
								gint _tmp117_;
								_tmp105_ = possible_types;
								_tmp105__length1 = possible_types_length1;
								_tmp106_ = j;
								_tmp107_ = _tmp105_[_tmp106_];
								t = _tmp107_;
								_tmp108_ = possible_types;
								_tmp108__length1 = possible_types_length1;
								_tmp109_ = j;
								_tmp110_ = possible_types;
								_tmp110__length1 = possible_types_length1;
								_tmp111_ = j;
								_tmp112_ = _tmp110_[_tmp111_ + 1];
								_tmp108_[_tmp109_] = _tmp112_;
								_tmp113_ = _tmp108_[_tmp109_];
								_tmp114_ = possible_types;
								_tmp114__length1 = possible_types_length1;
								_tmp115_ = j;
								_tmp116_ = t;
								_tmp114_[_tmp115_ + 1] = _tmp116_;
								_tmp117_ = _tmp114_[_tmp115_ + 1];
							}
						}
					}
				}
			}
		}
	}
	_tmp118_ = g_random_int_range ((gint32) 0, (gint32) 99);
	rnd = _tmp118_;
	_tmp119_ = rnd;
	if (_tmp119_ < ((gint32) 75)) {
		gint* _tmp120_;
		gint _tmp120__length1;
		gint _tmp121_;
		gint32 _tmp122_ = 0;
		Shape* _tmp123_ = NULL;
		_tmp120_ = possible_types;
		_tmp120__length1 = possible_types_length1;
		_tmp121_ = _tmp120_[0];
		_tmp122_ = g_random_int_range ((gint32) 0, (gint32) 4);
		_tmp123_ = game_make_shape (self, _tmp121_, (gint) _tmp122_);
		result = _tmp123_;
		possible_types = (g_free (possible_types), NULL);
		metrics = (g_free (metrics), NULL);
		return result;
	} else {
		gint32 _tmp124_;
		_tmp124_ = rnd;
		if (_tmp124_ < ((gint32) 92)) {
			gint* _tmp125_;
			gint _tmp125__length1;
			gint _tmp126_;
			gint32 _tmp127_ = 0;
			Shape* _tmp128_ = NULL;
			_tmp125_ = possible_types;
			_tmp125__length1 = possible_types_length1;
			_tmp126_ = _tmp125_[1];
			_tmp127_ = g_random_int_range ((gint32) 0, (gint32) 4);
			_tmp128_ = game_make_shape (self, _tmp126_, (gint) _tmp127_);
			result = _tmp128_;
			possible_types = (g_free (possible_types), NULL);
			metrics = (g_free (metrics), NULL);
			return result;
		} else {
			gint32 _tmp129_;
			_tmp129_ = rnd;
			if (_tmp129_ < ((gint32) 98)) {
				gint* _tmp130_;
				gint _tmp130__length1;
				gint _tmp131_;
				gint32 _tmp132_ = 0;
				Shape* _tmp133_ = NULL;
				_tmp130_ = possible_types;
				_tmp130__length1 = possible_types_length1;
				_tmp131_ = _tmp130_[2];
				_tmp132_ = g_random_int_range ((gint32) 0, (gint32) 4);
				_tmp133_ = game_make_shape (self, _tmp131_, (gint) _tmp132_);
				result = _tmp133_;
				possible_types = (g_free (possible_types), NULL);
				metrics = (g_free (metrics), NULL);
				return result;
			} else {
				gint* _tmp134_;
				gint _tmp134__length1;
				gint _tmp135_;
				gint32 _tmp136_ = 0;
				Shape* _tmp137_ = NULL;
				_tmp134_ = possible_types;
				_tmp134__length1 = possible_types_length1;
				_tmp135_ = _tmp134_[3];
				_tmp136_ = g_random_int_range ((gint32) 0, (gint32) 4);
				_tmp137_ = game_make_shape (self, _tmp135_, (gint) _tmp136_);
				result = _tmp137_;
				possible_types = (g_free (possible_types), NULL);
				metrics = (g_free (metrics), NULL);
				return result;
			}
		}
	}
	possible_types = (g_free (possible_types), NULL);
	metrics = (g_free (metrics), NULL);
}


static Shape* game_make_shape (Game* self, gint type, gint rotation) {
	Shape* result = NULL;
	Shape* _tmp0_;
	Shape* shape;
	Shape* _tmp1_;
	gint _tmp2_;
	Shape* _tmp3_;
	gint _tmp4_;
	Shape* _tmp5_;
	gint _tmp6_;
	Shape* _tmp7_;
	gint _tmp8_;
	gint offset;
	gint min_width;
	gint max_width;
	gint min_height;
	gint max_height;
	gint _tmp44_;
	gint _tmp45_;
	gint block_width;
	Shape* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	Shape* _tmp50_;
	gint _tmp51_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = shape_new ();
	shape = _tmp0_;
	_tmp1_ = shape;
	_tmp2_ = type;
	_tmp1_->type = _tmp2_;
	_tmp3_ = shape;
	_tmp4_ = rotation;
	_tmp3_->rotation = _tmp4_;
	_tmp5_ = shape;
	_tmp6_ = _tmp5_->type;
	_tmp7_ = shape;
	_tmp8_ = _tmp7_->rotation;
	offset = (_tmp6_ * 64) + (_tmp8_ * 16);
	min_width = 4;
	max_width = 0;
	min_height = 4;
	max_height = 0;
	{
		gint x;
		x = 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				gint _tmp12_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = x;
					x = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = x;
				if (!(_tmp12_ < 4)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp13_;
						_tmp13_ = TRUE;
						while (TRUE) {
							gboolean _tmp14_;
							gint _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							gint _tmp19_;
							gint _tmp20_;
							gint _tmp21_;
							gint _tmp22_;
							gint _tmp23_ = 0;
							gint _tmp24_;
							gint _tmp25_;
							gint _tmp26_ = 0;
							gint _tmp27_;
							gint _tmp28_;
							gint _tmp29_ = 0;
							gint _tmp30_;
							gint _tmp31_;
							gint _tmp32_ = 0;
							Block* _tmp33_;
							Block* b;
							Block* _tmp34_;
							Shape* _tmp35_;
							gint _tmp36_;
							Block* _tmp37_;
							gint _tmp38_;
							Block* _tmp39_;
							gint _tmp40_;
							Shape* _tmp41_;
							Block* _tmp42_;
							Block* _tmp43_;
							_tmp14_ = _tmp13_;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = y;
								y = _tmp15_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp16_ = y;
							if (!(_tmp16_ < 4)) {
								break;
							}
							_tmp17_ = offset;
							_tmp18_ = y;
							_tmp19_ = x;
							_tmp20_ = block_table[(_tmp17_ + (_tmp18_ * 4)) + _tmp19_];
							if (_tmp20_ == 0) {
								continue;
							}
							_tmp21_ = x;
							_tmp22_ = min_width;
							_tmp23_ = MIN (_tmp21_, _tmp22_);
							min_width = _tmp23_;
							_tmp24_ = x;
							_tmp25_ = max_width;
							_tmp26_ = MAX (_tmp24_ + 1, _tmp25_);
							max_width = _tmp26_;
							_tmp27_ = y;
							_tmp28_ = min_height;
							_tmp29_ = MIN (_tmp27_, _tmp28_);
							min_height = _tmp29_;
							_tmp30_ = y;
							_tmp31_ = max_height;
							_tmp32_ = MAX (_tmp30_ + 1, _tmp31_);
							max_height = _tmp32_;
							_tmp33_ = block_new ();
							b = _tmp33_;
							_tmp34_ = b;
							_tmp35_ = shape;
							_tmp36_ = _tmp35_->type;
							_tmp34_->color = _tmp36_;
							_tmp37_ = b;
							_tmp38_ = x;
							_tmp37_->x = _tmp38_;
							_tmp39_ = b;
							_tmp40_ = y;
							_tmp39_->y = _tmp40_;
							_tmp41_ = shape;
							_tmp42_ = b;
							_tmp43_ = _block_ref0 (_tmp42_);
							_tmp41_->blocks = g_list_append (_tmp41_->blocks, _tmp43_);
							_block_unref0 (b);
						}
					}
				}
			}
		}
	}
	_tmp44_ = max_width;
	_tmp45_ = min_width;
	block_width = _tmp44_ - _tmp45_;
	_tmp46_ = shape;
	_tmp47_ = game_get_width (self);
	_tmp48_ = _tmp47_;
	_tmp49_ = min_width;
	_tmp46_->x = ((_tmp48_ - block_width) / 2) - _tmp49_;
	_tmp50_ = shape;
	_tmp51_ = min_height;
	_tmp50_->y = -_tmp51_;
	result = shape;
	return result;
}


static void game_land_shape (Game* self) {
	Shape* _tmp0_;
	GList* _tmp1_;
	gint fall_distance;
	gint* _tmp21_ = NULL;
	gint* lines;
	gint lines_length1;
	gint _lines_size_;
	gint n_lines;
	gboolean base_line_destroyed;
	gint _tmp47_;
	gint _tmp48_ = 0;
	GList* line_blocks;
	gint _tmp111_;
	gint _tmp112_;
	gint old_level;
	gint _tmp113_;
	gint _tmp114_;
	gint _tmp115_;
	gboolean _tmp128_;
	gint _tmp132_;
	gint _tmp133_;
	gint _tmp134_;
	gint* _tmp135_;
	gint _tmp135__length1;
	GList* _tmp136_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->shape;
	_tmp1_ = _tmp0_->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp1_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp2_;
			Block* b = NULL;
			_tmp2_ = _block_ref0 ((Block*) b_it->data);
			b = _tmp2_;
			{
				Block* _tmp3_;
				Block* _tmp4_;
				gint _tmp5_;
				Shape* _tmp6_;
				gint _tmp7_;
				Block* _tmp8_;
				Block* _tmp9_;
				gint _tmp10_;
				Shape* _tmp11_;
				gint _tmp12_;
				Block** _tmp13_;
				gint _tmp13__length1;
				gint _tmp13__length2;
				Block* _tmp14_;
				gint _tmp15_;
				Block* _tmp16_;
				gint _tmp17_;
				Block* _tmp18_;
				Block* _tmp19_;
				Block* _tmp20_;
				_tmp3_ = b;
				_tmp4_ = b;
				_tmp5_ = _tmp4_->x;
				_tmp6_ = self->shape;
				_tmp7_ = _tmp6_->x;
				_tmp4_->x = _tmp5_ + _tmp7_;
				_tmp8_ = b;
				_tmp9_ = b;
				_tmp10_ = _tmp9_->y;
				_tmp11_ = self->shape;
				_tmp12_ = _tmp11_->y;
				_tmp9_->y = _tmp10_ + _tmp12_;
				_tmp13_ = self->blocks;
				_tmp13__length1 = self->blocks_length1;
				_tmp13__length2 = self->blocks_length2;
				_tmp14_ = b;
				_tmp15_ = _tmp14_->x;
				_tmp16_ = b;
				_tmp17_ = _tmp16_->y;
				_tmp18_ = b;
				_tmp19_ = _block_ref0 (_tmp18_);
				_block_unref0 (_tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_]);
				_tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_] = _tmp19_;
				_tmp20_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
				_block_unref0 (b);
			}
		}
	}
	fall_distance = 0;
	_tmp21_ = g_new0 (gint, 4);
	lines = _tmp21_;
	lines_length1 = 4;
	_lines_size_ = lines_length1;
	n_lines = 0;
	base_line_destroyed = FALSE;
	{
		gint _tmp22_;
		gint _tmp23_;
		gint y;
		_tmp22_ = game_get_height (self);
		_tmp23_ = _tmp22_;
		y = _tmp23_ - 1;
		{
			gboolean _tmp24_;
			_tmp24_ = TRUE;
			while (TRUE) {
				gboolean _tmp25_;
				gint _tmp27_;
				gboolean explode;
				gboolean _tmp38_;
				_tmp25_ = _tmp24_;
				if (!_tmp25_) {
					gint _tmp26_;
					_tmp26_ = y;
					y = _tmp26_ - 1;
				}
				_tmp24_ = FALSE;
				_tmp27_ = y;
				if (!(_tmp27_ >= 0)) {
					break;
				}
				explode = TRUE;
				{
					gint x;
					x = 0;
					{
						gboolean _tmp28_;
						_tmp28_ = TRUE;
						while (TRUE) {
							gboolean _tmp29_;
							gint _tmp31_;
							gint _tmp32_;
							gint _tmp33_;
							Block** _tmp34_;
							gint _tmp34__length1;
							gint _tmp34__length2;
							gint _tmp35_;
							gint _tmp36_;
							Block* _tmp37_;
							_tmp29_ = _tmp28_;
							if (!_tmp29_) {
								gint _tmp30_;
								_tmp30_ = x;
								x = _tmp30_ + 1;
							}
							_tmp28_ = FALSE;
							_tmp31_ = x;
							_tmp32_ = game_get_width (self);
							_tmp33_ = _tmp32_;
							if (!(_tmp31_ < _tmp33_)) {
								break;
							}
							_tmp34_ = self->blocks;
							_tmp34__length1 = self->blocks_length1;
							_tmp34__length2 = self->blocks_length2;
							_tmp35_ = x;
							_tmp36_ = y;
							_tmp37_ = _tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_];
							if (_tmp37_ == NULL) {
								explode = FALSE;
								break;
							}
						}
					}
				}
				_tmp38_ = explode;
				if (_tmp38_) {
					gint _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					gint* _tmp42_;
					gint _tmp42__length1;
					gint _tmp43_;
					gint _tmp44_;
					gint _tmp45_;
					gint _tmp46_;
					_tmp39_ = y;
					_tmp40_ = game_get_height (self);
					_tmp41_ = _tmp40_;
					if (_tmp39_ == (_tmp41_ - 1)) {
						base_line_destroyed = TRUE;
					}
					_tmp42_ = lines;
					_tmp42__length1 = lines_length1;
					_tmp43_ = n_lines;
					_tmp44_ = y;
					_tmp42_[_tmp43_] = _tmp44_;
					_tmp45_ = _tmp42_[_tmp43_];
					_tmp46_ = n_lines;
					n_lines = _tmp46_ + 1;
				}
			}
		}
	}
	_tmp47_ = n_lines;
	_tmp48_ = _tmp47_;
	lines = g_renew (gint, lines, _tmp47_);
	(_tmp48_ > lines_length1) ? memset (lines + lines_length1, 0, sizeof (gint) * (_tmp48_ - lines_length1)) : NULL;
	lines_length1 = _tmp48_;
	_lines_size_ = _tmp48_;
	line_blocks = NULL;
	{
		gint _tmp49_;
		gint _tmp50_;
		gint y;
		_tmp49_ = game_get_height (self);
		_tmp50_ = _tmp49_;
		y = _tmp50_ - 1;
		{
			gboolean _tmp51_;
			_tmp51_ = TRUE;
			while (TRUE) {
				gboolean _tmp52_;
				gint _tmp54_;
				gboolean explode;
				gboolean _tmp65_;
				_tmp52_ = _tmp51_;
				if (!_tmp52_) {
					gint _tmp53_;
					_tmp53_ = y;
					y = _tmp53_ - 1;
				}
				_tmp51_ = FALSE;
				_tmp54_ = y;
				if (!(_tmp54_ >= 0)) {
					break;
				}
				explode = TRUE;
				{
					gint x;
					x = 0;
					{
						gboolean _tmp55_;
						_tmp55_ = TRUE;
						while (TRUE) {
							gboolean _tmp56_;
							gint _tmp58_;
							gint _tmp59_;
							gint _tmp60_;
							Block** _tmp61_;
							gint _tmp61__length1;
							gint _tmp61__length2;
							gint _tmp62_;
							gint _tmp63_;
							Block* _tmp64_;
							_tmp56_ = _tmp55_;
							if (!_tmp56_) {
								gint _tmp57_;
								_tmp57_ = x;
								x = _tmp57_ + 1;
							}
							_tmp55_ = FALSE;
							_tmp58_ = x;
							_tmp59_ = game_get_width (self);
							_tmp60_ = _tmp59_;
							if (!(_tmp58_ < _tmp60_)) {
								break;
							}
							_tmp61_ = self->blocks;
							_tmp61__length1 = self->blocks_length1;
							_tmp61__length2 = self->blocks_length2;
							_tmp62_ = x;
							_tmp63_ = y;
							_tmp64_ = _tmp61_[(_tmp62_ * _tmp61__length2) + _tmp63_];
							if (_tmp64_ == NULL) {
								explode = FALSE;
								break;
							}
						}
					}
				}
				_tmp65_ = explode;
				if (_tmp65_) {
					gint _tmp81_;
					{
						gint x;
						x = 0;
						{
							gboolean _tmp66_;
							_tmp66_ = TRUE;
							while (TRUE) {
								gboolean _tmp67_;
								gint _tmp69_;
								gint _tmp70_;
								gint _tmp71_;
								Block** _tmp72_;
								gint _tmp72__length1;
								gint _tmp72__length2;
								gint _tmp73_;
								gint _tmp74_;
								Block* _tmp75_;
								Block* _tmp76_;
								Block** _tmp77_;
								gint _tmp77__length1;
								gint _tmp77__length2;
								gint _tmp78_;
								gint _tmp79_;
								Block* _tmp80_;
								_tmp67_ = _tmp66_;
								if (!_tmp67_) {
									gint _tmp68_;
									_tmp68_ = x;
									x = _tmp68_ + 1;
								}
								_tmp66_ = FALSE;
								_tmp69_ = x;
								_tmp70_ = game_get_width (self);
								_tmp71_ = _tmp70_;
								if (!(_tmp69_ < _tmp71_)) {
									break;
								}
								_tmp72_ = self->blocks;
								_tmp72__length1 = self->blocks_length1;
								_tmp72__length2 = self->blocks_length2;
								_tmp73_ = x;
								_tmp74_ = y;
								_tmp75_ = _tmp72_[(_tmp73_ * _tmp72__length2) + _tmp74_];
								_tmp76_ = _block_ref0 (_tmp75_);
								line_blocks = g_list_append (line_blocks, _tmp76_);
								_tmp77_ = self->blocks;
								_tmp77__length1 = self->blocks_length1;
								_tmp77__length2 = self->blocks_length2;
								_tmp78_ = x;
								_tmp79_ = y;
								_block_unref0 (_tmp77_[(_tmp78_ * _tmp77__length2) + _tmp79_]);
								_tmp77_[(_tmp78_ * _tmp77__length2) + _tmp79_] = NULL;
								_tmp80_ = _tmp77_[(_tmp78_ * _tmp77__length2) + _tmp79_];
							}
						}
					}
					_tmp81_ = fall_distance;
					fall_distance = _tmp81_ + 1;
				} else {
					gint _tmp82_;
					_tmp82_ = fall_distance;
					if (_tmp82_ > 0) {
						{
							gint x;
							x = 0;
							{
								gboolean _tmp83_;
								_tmp83_ = TRUE;
								while (TRUE) {
									gboolean _tmp84_;
									gint _tmp86_;
									gint _tmp87_;
									gint _tmp88_;
									Block** _tmp89_;
									gint _tmp89__length1;
									gint _tmp89__length2;
									gint _tmp90_;
									gint _tmp91_;
									Block* _tmp92_;
									Block* _tmp93_;
									Block* b;
									Block* _tmp94_;
									_tmp84_ = _tmp83_;
									if (!_tmp84_) {
										gint _tmp85_;
										_tmp85_ = x;
										x = _tmp85_ + 1;
									}
									_tmp83_ = FALSE;
									_tmp86_ = x;
									_tmp87_ = game_get_width (self);
									_tmp88_ = _tmp87_;
									if (!(_tmp86_ < _tmp88_)) {
										break;
									}
									_tmp89_ = self->blocks;
									_tmp89__length1 = self->blocks_length1;
									_tmp89__length2 = self->blocks_length2;
									_tmp90_ = x;
									_tmp91_ = y;
									_tmp92_ = _tmp89_[(_tmp90_ * _tmp89__length2) + _tmp91_];
									_tmp93_ = _block_ref0 (_tmp92_);
									b = _tmp93_;
									_tmp94_ = b;
									if (_tmp94_ != NULL) {
										Block* _tmp95_;
										Block* _tmp96_;
										gint _tmp97_;
										gint _tmp98_;
										Block** _tmp99_;
										gint _tmp99__length1;
										gint _tmp99__length2;
										Block* _tmp100_;
										gint _tmp101_;
										Block* _tmp102_;
										gint _tmp103_;
										Block* _tmp104_;
										Block* _tmp105_;
										Block* _tmp106_;
										Block** _tmp107_;
										gint _tmp107__length1;
										gint _tmp107__length2;
										gint _tmp108_;
										gint _tmp109_;
										Block* _tmp110_;
										_tmp95_ = b;
										_tmp96_ = b;
										_tmp97_ = _tmp96_->y;
										_tmp98_ = fall_distance;
										_tmp96_->y = _tmp97_ + _tmp98_;
										_tmp99_ = self->blocks;
										_tmp99__length1 = self->blocks_length1;
										_tmp99__length2 = self->blocks_length2;
										_tmp100_ = b;
										_tmp101_ = _tmp100_->x;
										_tmp102_ = b;
										_tmp103_ = _tmp102_->y;
										_tmp104_ = b;
										_tmp105_ = _block_ref0 (_tmp104_);
										_block_unref0 (_tmp99_[(_tmp101_ * _tmp99__length2) + _tmp103_]);
										_tmp99_[(_tmp101_ * _tmp99__length2) + _tmp103_] = _tmp105_;
										_tmp106_ = _tmp99_[(_tmp101_ * _tmp99__length2) + _tmp103_];
										_tmp107_ = self->blocks;
										_tmp107__length1 = self->blocks_length1;
										_tmp107__length2 = self->blocks_length2;
										_tmp108_ = x;
										_tmp109_ = y;
										_block_unref0 (_tmp107_[(_tmp108_ * _tmp107__length2) + _tmp109_]);
										_tmp107_[(_tmp108_ * _tmp107__length2) + _tmp109_] = NULL;
										_tmp110_ = _tmp107_[(_tmp108_ * _tmp107__length2) + _tmp109_];
									}
									_block_unref0 (b);
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp111_ = game_get_level (self);
	_tmp112_ = _tmp111_;
	old_level = _tmp112_;
	_tmp113_ = self->n_lines_destroyed;
	_tmp114_ = n_lines;
	self->n_lines_destroyed = _tmp113_ + _tmp114_;
	_tmp115_ = n_lines;
	switch (_tmp115_) {
		case 0:
		{
			break;
		}
		case 1:
		{
			gint _tmp116_;
			gint _tmp117_;
			gint _tmp118_;
			_tmp116_ = self->score;
			_tmp117_ = game_get_level (self);
			_tmp118_ = _tmp117_;
			self->score = _tmp116_ + (40 * _tmp118_);
			break;
		}
		case 2:
		{
			gint _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			_tmp119_ = self->score;
			_tmp120_ = game_get_level (self);
			_tmp121_ = _tmp120_;
			self->score = _tmp119_ + (100 * _tmp121_);
			break;
		}
		case 3:
		{
			gint _tmp122_;
			gint _tmp123_;
			gint _tmp124_;
			_tmp122_ = self->score;
			_tmp123_ = game_get_level (self);
			_tmp124_ = _tmp123_;
			self->score = _tmp122_ + (300 * _tmp124_);
			break;
		}
		case 4:
		{
			gint _tmp125_;
			gint _tmp126_;
			gint _tmp127_;
			_tmp125_ = self->score;
			_tmp126_ = game_get_level (self);
			_tmp127_ = _tmp126_;
			self->score = _tmp125_ + (1200 * _tmp127_);
			break;
		}
		default:
		break;
	}
	_tmp128_ = base_line_destroyed;
	if (_tmp128_) {
		gint _tmp129_;
		gint _tmp130_;
		gint _tmp131_;
		_tmp129_ = self->score;
		_tmp130_ = game_get_level (self);
		_tmp131_ = _tmp130_;
		self->score = _tmp129_ + (10000 * _tmp131_);
	}
	_tmp132_ = game_get_level (self);
	_tmp133_ = _tmp132_;
	_tmp134_ = old_level;
	if (_tmp133_ != _tmp134_) {
		game_setup_drop_timer (self);
	}
	_tmp135_ = lines;
	_tmp135__length1 = lines_length1;
	_tmp136_ = line_blocks;
	g_signal_emit_by_name (self, "shape-landed", _tmp135_, _tmp135__length1, _tmp136_);
	_shape_unref0 (self->shape);
	self->shape = NULL;
	__g_list_free__block_unref0_0 (line_blocks);
	lines = (g_free (lines), NULL);
}


static gboolean game_move_shape (Game* self, gint x_step, gint y_step, gint r_step) {
	gboolean result = FALSE;
	Shape* _tmp0_;
	gint _tmp1_;
	gboolean can_move;
	Shape* _tmp2_;
	GList* _tmp3_;
	gboolean _tmp32_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->shape;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = r_step;
	game_rotate_shape (self, _tmp1_);
	can_move = TRUE;
	_tmp2_ = self->shape;
	_tmp3_ = _tmp2_->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp3_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp4_;
			Block* b = NULL;
			_tmp4_ = _block_ref0 ((Block*) b_it->data);
			b = _tmp4_;
			{
				Shape* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				Block* _tmp8_;
				gint _tmp9_;
				gint x;
				Shape* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				Block* _tmp13_;
				gint _tmp14_;
				gint y;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				gint _tmp18_;
				gboolean _tmp22_;
				gboolean _tmp26_;
				gboolean _tmp31_;
				_tmp5_ = self->shape;
				_tmp6_ = _tmp5_->x;
				_tmp7_ = x_step;
				_tmp8_ = b;
				_tmp9_ = _tmp8_->x;
				x = (_tmp6_ + _tmp7_) + _tmp9_;
				_tmp10_ = self->shape;
				_tmp11_ = _tmp10_->y;
				_tmp12_ = y_step;
				_tmp13_ = b;
				_tmp14_ = _tmp13_->y;
				y = (_tmp11_ + _tmp12_) + _tmp14_;
				_tmp18_ = x;
				if (_tmp18_ < 0) {
					_tmp17_ = TRUE;
				} else {
					gint _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					_tmp19_ = x;
					_tmp20_ = game_get_width (self);
					_tmp21_ = _tmp20_;
					_tmp17_ = _tmp19_ >= _tmp21_;
				}
				_tmp22_ = _tmp17_;
				if (_tmp22_) {
					_tmp16_ = TRUE;
				} else {
					gint _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					_tmp23_ = y;
					_tmp24_ = game_get_height (self);
					_tmp25_ = _tmp24_;
					_tmp16_ = _tmp23_ >= _tmp25_;
				}
				_tmp26_ = _tmp16_;
				if (_tmp26_) {
					_tmp15_ = TRUE;
				} else {
					Block** _tmp27_;
					gint _tmp27__length1;
					gint _tmp27__length2;
					gint _tmp28_;
					gint _tmp29_;
					Block* _tmp30_;
					_tmp27_ = self->blocks;
					_tmp27__length1 = self->blocks_length1;
					_tmp27__length2 = self->blocks_length2;
					_tmp28_ = x;
					_tmp29_ = y;
					_tmp30_ = _tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_];
					_tmp15_ = _tmp30_ != NULL;
				}
				_tmp31_ = _tmp15_;
				if (_tmp31_) {
					can_move = FALSE;
					_block_unref0 (b);
					break;
				}
				_block_unref0 (b);
			}
		}
	}
	_tmp32_ = can_move;
	if (_tmp32_) {
		Shape* _tmp33_;
		Shape* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		Shape* _tmp37_;
		Shape* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		_tmp33_ = self->shape;
		_tmp34_ = self->shape;
		_tmp35_ = _tmp34_->x;
		_tmp36_ = x_step;
		_tmp34_->x = _tmp35_ + _tmp36_;
		_tmp37_ = self->shape;
		_tmp38_ = self->shape;
		_tmp39_ = _tmp38_->y;
		_tmp40_ = y_step;
		_tmp38_->y = _tmp39_ + _tmp40_;
		_tmp41_ = x_step;
		if (_tmp41_ != 0) {
			g_signal_emit_by_name (self, "shape-moved");
		} else {
			gint _tmp42_;
			_tmp42_ = y_step;
			if (_tmp42_ > 0) {
				g_signal_emit_by_name (self, "shape-dropped");
			} else {
				g_signal_emit_by_name (self, "shape-rotated");
			}
		}
	} else {
		gint _tmp43_;
		_tmp43_ = r_step;
		game_rotate_shape (self, -_tmp43_);
	}
	result = can_move;
	return result;
}


static void game_rotate_shape (Game* self, gint r_step) {
	Shape* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint r;
	gint _tmp3_;
	gint _tmp5_;
	gint _tmp7_;
	Shape* _tmp8_;
	gint _tmp9_;
	Shape* _tmp10_;
	gint _tmp11_;
	Shape* _tmp12_;
	GList* _tmp13_;
	GList* b;
	Shape* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint offset;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->shape;
	_tmp1_ = _tmp0_->rotation;
	_tmp2_ = r_step;
	r = _tmp1_ + _tmp2_;
	_tmp3_ = r;
	if (_tmp3_ < 0) {
		gint _tmp4_;
		_tmp4_ = r;
		r = _tmp4_ + 4;
	}
	_tmp5_ = r;
	if (_tmp5_ >= 4) {
		gint _tmp6_;
		_tmp6_ = r;
		r = _tmp6_ - 4;
	}
	_tmp7_ = r;
	_tmp8_ = self->shape;
	_tmp9_ = _tmp8_->rotation;
	if (_tmp7_ == _tmp9_) {
		return;
	}
	_tmp10_ = self->shape;
	_tmp11_ = r;
	_tmp10_->rotation = _tmp11_;
	_tmp12_ = self->shape;
	_tmp13_ = _tmp12_->blocks;
	b = _tmp13_;
	_tmp14_ = self->shape;
	_tmp15_ = _tmp14_->type;
	_tmp16_ = r;
	offset = (_tmp15_ * 64) + (_tmp16_ * 16);
	{
		gint x;
		x = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = x;
					x = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = x;
				if (!(_tmp20_ < 4)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp21_;
						_tmp21_ = TRUE;
						while (TRUE) {
							gboolean _tmp22_;
							gint _tmp24_;
							gint _tmp25_;
							gint _tmp26_;
							gint _tmp27_;
							gint _tmp28_;
							_tmp22_ = _tmp21_;
							if (!_tmp22_) {
								gint _tmp23_;
								_tmp23_ = y;
								y = _tmp23_ + 1;
							}
							_tmp21_ = FALSE;
							_tmp24_ = y;
							if (!(_tmp24_ < 4)) {
								break;
							}
							_tmp25_ = offset;
							_tmp26_ = y;
							_tmp27_ = x;
							_tmp28_ = block_table[(_tmp25_ + (_tmp26_ * 4)) + _tmp27_];
							if (_tmp28_ != 0) {
								GList* _tmp29_;
								gconstpointer _tmp30_;
								gint _tmp31_;
								GList* _tmp32_;
								gconstpointer _tmp33_;
								gint _tmp34_;
								GList* _tmp35_;
								GList* _tmp36_;
								_tmp29_ = b;
								_tmp30_ = _tmp29_->data;
								_tmp31_ = x;
								((Block*) _tmp30_)->x = _tmp31_;
								_tmp32_ = b;
								_tmp33_ = _tmp32_->data;
								_tmp34_ = y;
								((Block*) _tmp33_)->y = _tmp34_;
								_tmp35_ = b;
								_tmp36_ = _tmp35_->next;
								b = _tmp36_;
							}
						}
					}
				}
			}
		}
	}
}


gint game_get_width (Game* self) {
	gint result;
	Block** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->blocks;
	_tmp0__length1 = self->blocks_length1;
	_tmp0__length2 = self->blocks_length2;
	_tmp1_ = _tmp0__length1;
	result = _tmp1_;
	return result;
}


gint game_get_height (Game* self) {
	gint result;
	Block** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->blocks;
	_tmp0__length1 = self->blocks_length1;
	_tmp0__length2 = self->blocks_length2;
	_tmp1_ = _tmp0__length2;
	result = _tmp1_;
	return result;
}


gint game_get_level (Game* self) {
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->starting_level;
	_tmp1_ = self->n_lines_destroyed;
	result = _tmp0_ + (_tmp1_ / 10);
	return result;
}


gboolean game_get_paused (Game* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_paused;
	result = _tmp0_;
	return result;
}


void game_set_paused (Game* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_paused = _tmp0_;
	_tmp1_ = self->priv->has_started;
	if (_tmp1_) {
		game_setup_drop_timer (self);
	}
	g_signal_emit_by_name (self, "pause-changed");
	g_object_notify ((GObject *) self, "paused");
}


gint game_get_shadow_y (Game* self) {
	gint result;
	Shape* _tmp0_;
	gint d;
	Game* _tmp1_ = NULL;
	Game* g;
	Shape* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->shape;
	if (_tmp0_ == NULL) {
		result = 0;
		return result;
	}
	d = 0;
	_tmp1_ = game_copy (self);
	g = _tmp1_;
	while (TRUE) {
		Game* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gint _tmp4_;
		_tmp2_ = g;
		_tmp3_ = game_move_shape (_tmp2_, 0, 1, 0);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = d;
		d = _tmp4_ + 1;
	}
	_tmp5_ = self->shape;
	_tmp6_ = _tmp5_->y;
	_tmp7_ = d;
	result = _tmp6_ + _tmp7_;
	_g_object_unref0 (g);
	return result;
}


static void g_cclosure_user_marshal_VOID__POINTER_INT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT_POINTER) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_pointer (param_values + 3), data2);
}


static void game_class_init (GameClass * klass) {
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HEIGHT, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_LEVEL, g_param_spec_int ("level", "level", "level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_PAUSED, g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SHADOW_Y, g_param_spec_int ("shadow-y", "shadow-y", "shadow-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("started", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("shape_added", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("shape_moved", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("shape_dropped", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("shape_rotated", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("shape_landed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_POINTER, G_TYPE_NONE, 3, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_POINTER);
	g_signal_new ("pause_changed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void game_instance_init (Game * self) {
	self->priv = GAME_GET_PRIVATE (self);
	self->shape = NULL;
	self->next_shape = NULL;
	self->n_lines_destroyed = 0;
	self->score = 0;
	self->priv->starting_level = 1;
	self->priv->pick_difficult_blocks = FALSE;
	self->priv->fast_forward = FALSE;
	self->priv->drop_timeout = (guint) 0;
	self->priv->has_started = FALSE;
	self->priv->_paused = FALSE;
	self->game_over = FALSE;
}


static void game_finalize (GObject* obj) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	_shape_unref0 (self->shape);
	_shape_unref0 (self->next_shape);
	self->blocks = (_vala_array_free (self->blocks, self->blocks_length1 * self->blocks_length2, (GDestroyNotify) block_unref), NULL);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_WIDTH:
		g_value_set_int (value, game_get_width (self));
		break;
		case GAME_HEIGHT:
		g_value_set_int (value, game_get_height (self));
		break;
		case GAME_LEVEL:
		g_value_set_int (value, game_get_level (self));
		break;
		case GAME_PAUSED:
		g_value_set_boolean (value, game_get_paused (self));
		break;
		case GAME_SHADOW_Y:
		g_value_set_int (value, game_get_shadow_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_PAUSED:
		game_set_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



