/* QuesoGLC
 * A free implementation of the OpenGL Character Renderer (GLC)
 * Copyright (c) 2002-2005, Bertrand Coconnier
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: testrender.c,v 1.21 2006/09/01 22:24:14 bcoconni Exp $ */

/* Example of how to render text using the rendering styles defined in the
 * GLC specs.
 */

#include "GL/glc.h"
#include <stdio.h>
#if defined __APPLE__ && defined __MACH__
#include <GLUT/glut.h>
#else
#include <GL/glut.h>
#endif
#include <stdlib.h>

void display(void)
{
  GLfloat BitmapBoundingBox[8];

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glLoadIdentity();
  glcRenderStyle(GLC_LINE);
  glColor3f(0., 1., 0.);
  glTranslatef(100., 50., 0.);
  glRotatef(45., 0., 0., 1.);
  glScalef(90., 90., 0.);
  glcRenderChar('L');
  glcRenderString("ine");

  glLoadIdentity();
  glcRenderStyle(GLC_TEXTURE);
  glColor3f(0., 0., 1.);
  glTranslatef(30., 150., 0.);
  glScalef(90., 90., 0.);
  glcRenderChar('T');
  glcRenderString("exture");

  glLoadIdentity();
  glcRenderStyle(GLC_BITMAP);
  glColor3f(1., 0., 0.);
  glRasterPos2f(30., 200.);
  glcLoadIdentity();
  glcScale(90., 90.);
  glcRotate(-10.);
  glcRenderChar('B');
  glcRenderString("itmap");

  glcLoadIdentity();
  glcMeasureString(GL_FALSE, "Bitmap");
  glcGetStringMetric(GLC_BOUNDS, BitmapBoundingBox);
  glTranslatef(30., 200., 0.);
  glScalef(90., 90., 1.);
  glRotatef(-10., 0., 0., 1.);
  glBegin(GL_LINE_LOOP);
    glVertex2fv(&(BitmapBoundingBox[0]));
    glVertex2fv(&(BitmapBoundingBox[2]));
    glVertex2fv(&(BitmapBoundingBox[4]));
    glVertex2fv(&(BitmapBoundingBox[6]));
  glEnd();

  glLoadIdentity();
  glcRenderStyle(GLC_TRIANGLE);
  glColor3f(1., 1., 0.);
  glTranslatef(30., 50., 0.);
  glScalef(90., 90., 0.);
  glcRenderString("Tr");
  glcRenderStyle(GLC_LINE);
  glcRenderChar('i');
  glcRenderStyle(GLC_TRIANGLE);
  glcRenderString("angle");

  glFlush();
}

void reshape(int width, int height)
{
  glClearColor(0., 0., 0., 0.);
  glViewport(0, 0, width, height);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(-0.325, width - 0.325, -0.325, height - 0.325);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glFlush();
}

void keyboard(unsigned char key, int x, int y)
{
  switch(key) {
  case 27: /* Escape Key */
    printf("Textures : %d\n", glcGeti(GLC_TEXTURE_OBJECT_COUNT));
    printf("Display Lists : %d\n", glcGeti(GLC_LIST_OBJECT_COUNT));
    exit(0);
  default:
    break;
  }
}

int main(int argc, char **argv)
{
  int ctx = 0;
  int font = 0;

  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
  glutInitWindowSize(640, 480);
  glutCreateWindow("QuesoGLC");
  glutDisplayFunc(display);
  glutReshapeFunc(reshape);
  glutKeyboardFunc(keyboard);

  ctx = glcGenContext();
  glcContext(ctx);
#ifdef __WIN32__
  font = glcNewFontFromFamily(glcGenFontID(), "Courier New");
#else
  font = glcNewFontFromFamily(glcGenFontID(), "Courier");
#endif
  glcFont(font);
  glcFontFace(font, "Italic");

  glutMainLoop();
  return 0;
}
