/*
    icqAccount

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#ifndef ICQACCOUNT_H
#define ICQACCOUNT_H

#include <QtGui/QWidget>
#include <QGridLayout>
#include <QMenu>
#include <QAction>
#include <QTreeWidget>
#include <QTreeWidgetItem>
#include <QStackedWidget>
#include <QDebug>
#include <QSystemTrayIcon>
#include "../../../src/accountbutton.h"
#include "settings/icqsettings.h"
#include "settings/networksettings.h"
#include "settings/contactlistsettings.h"
#include "settings/messagingsettings.h"
#include "settings/statussettings.h"
#include "settings/historysettings.h"
#include "settings/eventssettings.h"
#include "settings/antispamsettings.h"
#include "settings/emoticonsettings.h"
#include "oscarprotocol.h"
#include "statusdialog.h"
#include "traymessage.h"
#include "customstatusdialog.h"


class icqAccount : public QObject
{
    Q_OBJECT

public:
    icqAccount(QObject *parent = 0);
    icqAccount(QSystemTrayIcon *, QTreeWidget *, QString, QObject *parent = 0);
    ~icqAccount();
    void createAccountButton(QGridLayout *, QWidget *, int);
    void createMenuAccount(QMenu *, QAction *);
    void removeMenuAccount(QMenu *);
    void removeAccountButton();
    QAction* getAction() { return accountAction; }
    QString getIcquin() { return icqUin; }
    void createSettings(QTreeWidget *, QStackedWidget *);
    void removeSettings();
    void loadAllSettings();
    void saveAllSettings();
    bool getChangeState() { return settingsChanged; }
    QIcon getCurrentIcon() { return *currentIcon; }
    void setTrayCurrent( bool curr ) { currentTrayStatus = curr; }
    void createTrayMenuStatus(QMenu *);
    void removeTrayMenuStatus(QMenu *);
    void setChooseStatusCheck( bool check) { chooseStatus->setChecked(check); }
    bool getAutoConnect();
    void autoconnecting();
    void removeContactList();
    bool deleteingAccount;
    void readMessageStack();
    oscarProtocol *getProtocol() { return thisIcqProtocol; }
    QString currentIconPath;
    
private slots:
	void icqSettingsChanged();
	void setOnlineStatus();
	void setOfflineStatus();
	void setFfcStatus();
	void setAwayStatus();
	void setNaStatus();
	void setOccupiedStatus();
	void setDndStatus();
	void setInvisibleStatus();
	
	void setLunchStatus();
	void setEvilStatus();
	void setDepressionStatus();
	void setAtHomeStatus();
	void setAtWorkStatus();
	
	void setStatusIcon(accountStatus);
	void emitChangeStatus();
	void systemMessage(const QString &);
	void userMessage(const QString &,const QString &,const QString &, userMessageType, bool);
	void gettingNewMessage() { emit getNewMessage();}
	void networkSettingsChanged();
	void addToEvent(bool f) { emit addToEventList(f);}
	void updateStatusMenu(bool);
	
	void setVisibleForAll();
	void setVisibleForVis();
	void setNotVisibleForInv();
	void setVisibleForContact();
	void setInvisibleForAll();
	
	void eventsSettingsChanged();
	void deleteTrayWindow(QObject *);
	void generalSettingsChanged();
	void customStatusTriggered();

signals:
	void changeSettingsApply();
	void statusChanged(QIcon*);
	void changeStatusInTrayMenu(const QString &);
	void getNewMessage();
	void readAllMessages();
	void addToEventList(bool);
	void updateTrayToolTip();
	
private:
	void createIcons();
	void createStatusMenu();
	void updateIconStatus();
	void loadAccountSettings();
	void saveAccountSettings();
	void createContacts();
	void trayUserMessage(const QString &,const QString &, const QString &);
	void traySystemMessage(const QString &);
	QString getIconPathForUin(const QString &);
	
	QString icqUin;
	accountButton *accountLineButton;
	QAction *accountAction;
	QTreeWidgetItem *icqGeneral;
	QTreeWidgetItem *icqNetwork;
	QTreeWidgetItem *icqCl;
	QTreeWidgetItem *msgSett;
	QTreeWidgetItem *statSett;
	QTreeWidgetItem *histSett;
	QTreeWidgetItem *eventSett;
	QTreeWidgetItem *antiSpamSett;
	QTreeWidgetItem *emoticSett;
	
	icqSettings *generalSettings;
	networkSettings *icqnetworkSettings;
	contactListSettings *clSettings;
	messagingSettings *msgSettings;
	statusSettings *statSettings;
	historySettings *histSettings;
	eventsSettings *evSettings;
	antiSpamSettings *antiSpSettings;
	emoticonSettings *emoticSettings;
	bool settingsChanged;
	bool menuExist;
	bool currentTrayStatus;
	bool statusTrayMenuExist;
	bool autoConnect;
	QMenu *statusMenu;
	QMenu *privacyStatus;
	QAction *onlineAction;
	QAction *offlineAction;
	QAction *ffcAction;
	QAction *awayAction;
	QAction *naAction;
	QAction *occupiedAction;
	QAction *dndAction;
	QAction *invisibleAction;
	QAction *lunchAction;
	QAction *evilAction;
	QAction *depressionAction;
	QAction *atHomeAction;
	QAction *atWorkAction;
	QAction *visibleForAll;
	QAction *visibleForVis;
	QAction *notVisibleForInv;
	QAction *visibleForContact;
	QAction *invisibleForAll;
	
	QAction *customStatus;
	
	QActionGroup *privacyGroup;
	QIcon *onlineIcon;
	QIcon *offlineIcon;
	QIcon *currentIcon;
	QIcon *ffcIcon;
	QIcon *awayIcon;
	QIcon *naIcon;
	QIcon *occupiedIcon;
	QIcon *dndIcon;
	QIcon *invisibleIcon;
	QIcon *connectingIcon;
	QIcon *lunchIcon;
	QIcon *evilIcon;
	QIcon *depressionIcon;
	QIcon *atHomeIcon;
	QIcon *atWorkIcon;
	
	oscarProtocol *thisIcqProtocol;
	QAction *chooseStatus;
	QTreeWidget *contactListTree;
	QSystemTrayIcon *trayIcon;
	bool showCustomStatus;
	
	bool showBalloon;
	int balloonTime;
	bool dontShowifNA;
	
	bool showTrayMessages;
	int trayMessageWidth;
	int trayMessageHeight;
	int trayMessageTime;
	int trayMessagePosition;
	int trayMessageStyle;
	int positionInStack;
	
	bool firsTrayMessageIsShown;
	QList<trayMessage *> trayMessagesList;
	QString configPath;
	
	unsigned clientIndex;
	unsigned protocolVersion;
	QString clientCap1;
	QString clientCap2;
	QString clientCap3;
	bool checkClientIdentification(unsigned, unsigned, const QString &,
			const QString &, const QString &);
	int currentXstatus;
//	pluginSystem *plugins;
};

#endif // ICQACCOUNT_H
