/*
    treeBuddyItem

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#ifndef TREEBUDDYITEM_H_
#define TREEBUDDYITEM_H_

#include <QtGui>
#include "tlv.h"
#include "buffer.h"
//#include "contactlist.h"
enum contactStatus { contactOnline, contactFfc, 
	contactAway, contactLunch, contactAtWork, contactAtHome, contactEvil,
	contactDepression, contactNa, contactOccupied, contactDnd, 
	contactInvisible, contactOffline};

class messageFormat;
class contactListTree;	

class treeBuddyItem : public QTreeWidgetItem
{
public:
	treeBuddyItem(QTreeWidgetItem *parent): QTreeWidgetItem(parent, 2){};
	treeBuddyItem(const QString &,QIcon ,contactListTree *, QTreeWidgetItem *parent);
	~treeBuddyItem();
	void readData(icqBuffer *, quint16);
	void oncoming(icqBuffer *, quint16);
	void buddyOffline();
	void setBuddyUin(const QString &);
	quint16 groupID;
	QString groupName;
	quint16 itemId;
	bool isOffline;
	contactStatus getStatus() { return status; }
	QString getName() { return buddyName; }
	QString getUin() { return buddyUin; }
	void setName(const QString& n) { buddyName = n; }
	QList<messageFormat *> messageList;
	QIcon statusIcon;
	bool messageIcon;
	void readMessage();
	contactListTree *par;
	bool UTF8;
	bool statusChanged;
	void updateBuddyText();
	
	bool operator< ( const QTreeWidgetItem  &other ) const  ;
	bool underline;
	bool notAutho;
	bool birth;
	QDate birthDay;
	void setCustomFont(const QString &, int, const QColor &);
	
	quint8 picFlags;
	
	QIcon *onlineIcon;
	QIcon *ffcIcon;
	QIcon *awayIcon;
	QIcon *naIcon;
	QIcon *occupiedIcon;
	QIcon *dndIcon;
	QIcon *invisibleIcon;
	QIcon *offlineIcon;
	QIcon *atHomeIcon;
	QIcon *atWorkIcon;
	QIcon *lunchIcon;
	QIcon *evilIcon;
	QIcon *depressionIcon;
	
	
	QByteArray avatarMd5Hash;
	
	void waitingForAuth(bool);
	bool authorizeMe;
	QString authMessage;
	
	QList<QByteArray> capabilitiesList;
	
	QString clientId;
	quint32 externalIP;
	quint32 internalIP;
	quint32 onlineTime;
	quint32 signonTime;
	quint32 regTime;
	
	bool fileTransferSupport;
	
	bool xStatusPresent;
private:
	void setCapabilities(QByteArray);
	bool isUtf8Cap(const QByteArray &);
	void takeOncomingTlv(tlv &);
	void takeTlv(tlv &);
	quint32 convertToInt32(const QByteArray &);
	quint16 byteArrayToInt16(const QByteArray &);
	quint8 byteArrayToInt8(const QByteArray &);
	void changeStatus(const QByteArray &);
	QString buddyUin;
	QString buddyName;
	contactStatus status;
	void readAvailableMessTlv(QByteArray);
	void createToolTip();
	QString iconPath;
	QString parentUin;

	void setExtIp(const QByteArray &);
	void setIntIp(const QByteArray &);
	void setOnlTime(const QByteArray &);
	void setSignOn(const QByteArray &);
	void setregTime(const QByteArray &);
};

#endif /*TREEBUDDYITEM_H_*/
