/*
    qutim

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#ifndef QUTIM_H
#define QUTIM_H

#include "qutimsettings.h"
#include "logindialog.h"
//#include "accountbutton.h"
//#include "../protocol/oscar/icq/icqaccount.h"
#include "../protocol/oscar/icq/treegroupitem.h"
#include "../protocol/oscar/icq/treebuddyitem.h"
#include <QtGui/QWidget>
#include <QSystemTrayIcon>
#include <QCloseEvent>
#include <QMenu>
#include <QDesktopWidget>
#include <QDebug>
#include <QSettings>
#include "ui_qutim.h"
#include "aboutinfo.h"


class eventEater : public QObject
{
	Q_OBJECT
public:
	eventEater(QWidget *parent = 0);
	~eventEater();
	bool changed;
protected:
	bool eventFilter(QObject *obj, QEvent *event);
};



class qutIM : public QWidget
{
    Q_OBJECT

public:
    qutIM(QWidget *parent = 0);
    ~qutIM();
    

private slots:
	void trayActivated(QSystemTrayIcon::ActivationReason);
	void appQuit();
	void qutimSettingsMenu();
	void reloadGeneralSettings();
	void addAccount(const QString &);
	void removeAccount(const QString &);
	void switchUser();
	void destroySettings();
	void updateTrayIcon(QIcon *);
	void setStatusFrom(const QString &); 
	void itemClicked(QTreeWidgetItem *, int);
	void itemDoubleClicked(QTreeWidgetItem *);
	void getNewMessage();
	void updateMessageIcon();
	void accountReadAllMessages();
	void getGroupList(QHash<quint16, treeGroupItem *>);
	void buddyChangeStatus(treeBuddyItem *, bool);
	void updateSorting();
	void reupdateList();
	void checkEventChanging();
	void addToEventList(bool);
	void updateTrayToolTip();
	void on_contactListTree_customContextMenuRequested ( const QPoint & );
	void on_infoButton_clicked();
	void infoWindowDestroyed(QObject *);
	
protected:
	void closeEvent(QCloseEvent *event);
	void focusOutEvent( QFocusEvent * event );
	void focusInEvent ( QFocusEvent * event ); 
    
private:
    Ui::qutIMClass ui;
    
    QAction *quitAction;
    QAction *settingsAction;
    QAction *switchUserAction;
    QMenu *trayMenu;
    QMenu *mainMenu;
    qutimSettings *settingsDialog;
    QList<icqAccount *> icqList;
    QList<icqAccount *> messageStack;
    QList<icqAccount *> updateEventList;
    bool createMenuAccounts;
    bool addToStatusTrayMenu;
    bool letMeQuit;
    bool unreadMessages;
    bool msgIcon;
    QMenu *currentStatusMenu;
    bool mergeAccounts;
    bool showGroups;
    bool hideEmptyGroups;
    bool hideSeparators;
    quint8 sorting;
    bool showOffline;
    bool autoHide;
    int hideSec;
  
    void mergeAccountsToList(bool);
    void createLoginDialog();
    void createTrayIcon();
    void createActions();
    void saveMainSettings();
    void loadMainSettings();
    void createContactList();
    void createAccountLine();
    void updateTrayStatus();
    QSystemTrayIcon *trayIcon;
    void statusFromFirstLog();
    void updateCurrentTrayStatusmenu(bool);
    QIcon tempIcon;
    void readMessages();
    void createGroups();
    void removeGroups();
    void showHideGroups(bool);
    void hideEmptyGr(bool);
    void hideOffline(bool);
    void setHideSeparators(bool);
    contactSeparator *onlineList;
    
    contactSeparator *offlineList;
    QTimer *timer;
    QHash<QString, treeGroupItem *> mergeGroupList;
    eventEater *eventObject;
    
    void createMainMenu();
    QMenu *addFindUsers;
    QMenu *sendMultiple;
    QMenu *privacyList;
    QMenu *serviceMessages;
    QMenu *changeMyDetails;
    QMenu *changeMyPassword;
    
    QString currentStyle;
    
    void loadStyle(const QString &);
    aboutInfo *infoWindow;
    bool aboutWindowOpen;
};

#endif // QUTIM_H
