$LOAD_PATH << '..' unless $LOAD_PATH.include? '..'

class CSS
  INHIBIT_PATTERN = %w(
@i
\\
javascript
vbscript
cookie
eval
expression
behavior
behaviour
binding
include-source
)

  def self.valid?(str)
    INHIBIT_PATTERN.each {|c|
      return false if str.include?(c)
    }
    return true
  end
end

if $0 == __FILE__
  require 'test/unit'
  $test = true
end

if defined?($test) && $test
  class TestCSS < Test::Unit::TestCase
    def ok(e, s)
      assert_equal e, CSS.valid?(s)
    end

    def test_all
      ok(true,  'h2 { color: red }')
      ok(false, "@import")
      ok(false, "\\important")
      ok(true,  '')
      ok(true,  'text-align:center;')
      ok(true,  'ok@style')
      ok(true,  'ok.style')
      ok(false, '@i')
    end
  end
end
