@rem Build the jit package under Windows
@rem The "if errorlevel 1" tests against any err level greater than or equal to 1

@rem don't forget to change version number both in DESCRIPTION and below
@set jitVersion=1.0-4
@set RVersion=2.9.0
@set RADIR=\a\r\ra
@set RADIR1=/a/r/ra
@set RDIR=\PROGRA~1\R\R-%RVersion%

@rem R needs a slightly different path to my standard path
@set | egrep -i "path=[^;]*Rtools" >NUL && goto :done @rem only do it if needed
@echo modifying path
@set path=c:\Rtools\bin;c:\Rtools\MinGW\bin;%PATH%
:done

@rem @rem ===clean===
@rem @C:/rtools/bin/make.exe -f Makefile.win clean

@rem @rem ===quick build (must run proper build once before this to set this up)===
@rem @C:\Rtools\bin\make.exe -f Makefile.win

@rem @rem ===proper build: install to R===
@rem cd %RDIR%\bin
@rem %RDIR%\bin\rcmd.exe INSTALL %RADIR1%/src/library/jit
@rem cd %RADIR%\src\library\jit\.#

@rem ===build for gzip file release===
"%RDIR%\bin\rcmd" BUILD --no-vignettes %RADIR1%/src/library/jit
mv ./jit_*.tar.gz %RADIR1%/library
ls -l %RADIR1%/library/jit_*.tar.gz

@rem ===install from release to RDIR===
@rem you should build the release gzip file above before doing this
cd %RDIR%\bin
rm -rf %RDIR%\library\jit
%RDIR%\bin\rcmd.exe INSTALL %RADIR1%/library/jit_%jitVersion%.tar.gz
cd %RADIR%\src\library\jit\.#

@rem ===check release with RDIR===
@rem you should build the gzip file and install the release before doing this
@rem note that R_CHECK_SUBDIRS_NOCASE is 0 because it seems to cause false positives
@rem results go into C:%RDIR%\bin\jit.Rcheck
cd %RDIR%\bin
@set _R_CHECK_USE_CODETOOLS_=1
@set _R_CHECK_ALL_NON_ISO_C_=1
@set _R_CHECK_RD_STYLE_=1
@set _R_CHECK_SUBDIRS_NOCASE_=0
%RDIR%\bin\rcmd.exe check %RADIR1%/library/jit_%jitVersion%.tar.gz
cd %RADIR%\src\library\jit\.#

@rem ===copy to Ra===
mcp -r \PROGRA~1\r\R-%RVersion%\library\jit \a\r\ra\library

@rem @echo ===convert jit.html etc. to web publishable form and copy to homepage===
@rem @sed "s#Rchm.css#R.css#" /a/r/ra/library/jit/html/jit.html >xtmp1
@rem                      @if errorlevel 1 goto error 
@rem @sed "s#../../base/html/#http://astrostatistics.psu.edu/datasets/R/html/base/html/#g" xtmp1 >xtmp2
@rem                      @if errorlevel 1 goto error 
@rem @sed "s#00Index.html#index.html#" xtmp2 > xtmp3
@rem                      @if errorlevel 1 goto error 
@rem @sed "s#<body>#<body bgcolor=\"\#e0e0e0\"><a><img src=\"ra.png\" alt=\"ra.png\" border=\"0\" align=\"right\"></a>#" xtmp3 > xtmp4
@rem                      @if errorlevel 1 goto error 
@rem @sed "s#<td align=\"right\">R Documentation</td>##" xtmp4 > xtmp5
@rem                      @if errorlevel 1 goto error 
@rem @dos2unix xtmp5
@rem                      @if errorlevel 1 goto error 
@rem @copy xtmp5 \a\homepage\ra\jit.html
@rem                      @if errorlevel 1 goto error 
@rem @rm -f xtmp1 xtmp2 xtmp3 xtmp4 xtmp5
@rem 
@rem @rem nojit.html
@rem @sed "s#Rchm.css#R.css#" /a/r/ra/library/jit/html/nojit.html >xtmp1
@rem                      @if errorlevel 1 goto error 
@rem @sed "s#../../base/html/#http://astrostatistics.psu.edu/datasets/R/html/base/html/#g" xtmp1 >xtmp2
@rem                      @if errorlevel 1 goto error 
@rem @sed "s#00Index.html#index.html#" xtmp2 > xtmp3
@rem                      @if errorlevel 1 goto error 
@rem @sed "s#<body>#<body bgcolor=\"\#e0e0e0\"><a><img src=\"ra.png\" alt=\"ra.png\" border=\"0\" align=\"right\"></a>#" xtmp3 > xtmp4
@rem                      @if errorlevel 1 goto error 
@rem @sed "s#<td align=\"right\">R Documentation</td>##" xtmp4 > xtmp5
@rem                      @if errorlevel 1 goto error 
@rem @dos2unix xtmp5
@rem                      @if errorlevel 1 goto error 
@rem @copy xtmp5 \a\homepage\ra\nojit.html
@rem                      @if errorlevel 1 goto error 
@rem @rm -f xtmp1 xtmp2 xtmp3 xtmp4 xtmp5
@rem 
@rem @rem isra.html
@rem @sed "s#Rchm.css#R.css#" /a/r/ra/library/jit/html/is.ra.html >xtmp1
@rem                      @if errorlevel 1 goto error 
@rem @sed "s#../../base/html/#http://astrostatistics.psu.edu/datasets/R/html/base/html/#g" xtmp1 >xtmp2
@rem                      @if errorlevel 1 goto error 
@rem @sed "s#00Index.html#index.html#" xtmp2 > xtmp3
@rem                      @if errorlevel 1 goto error 
@rem @sed "s#<body>#<body bgcolor=\"\#e0e0e0\"><a><img src=\"ra.png\" alt=\"ra.png\" border=\"0\" align=\"right\"></a>#" xtmp3 > xtmp4
@rem                      @if errorlevel 1 goto error 
@rem @sed "s#<td align=\"right\">R Documentation</td>##" xtmp4 > xtmp5
@rem                      @if errorlevel 1 goto error 
@rem @dos2unix xtmp5
@rem                      @if errorlevel 1 goto error 
@rem @copy xtmp5 \a\homepage\ra\is.ra.html
@rem                      @if errorlevel 1 goto error 
@rem @rm -f xtmp1 xtmp2 xtmp3 xtmp4 xtmp5

@goto done
:error
@echo ====ERROR====
:done
cd \a\r\ra\src\library\jit\.#
