% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{ballgown-class}
\alias{ballgown-class}
\alias{Ballgown}
\title{Ballgown}
\description{
S4 class for storing and manipulating expression data from assembled 
transcriptomes
}
\section{Slots}{

\describe{
\item{\code{expr}}{tables containing expression data for genomic features (introns, 
exons, transcripts)}

\item{\code{structure}}{genomic locations of features and their relationships to one 
another}

\item{\code{indexes}}{tables connecting components of the assembly and providing 
  other experimental 
information (e.g., phenotype data and locations of read alignment files)}

\item{\code{dirs}}{directories holding data created by \code{tablemaker}}

\item{\code{mergedDate}}{date the ballgown object was created}

\item{\code{meas}}{which expression measurement(s) the object contains in its data 
slot. Vector of one or more of "rcount", "ucount", "mrcount", "cov", 
"cov_sd", "mcov", "mcov_sd", or "FPKM", if Tablemaker output is used, or 
one of "TPM" or "FPKM" if RSEM output is used. Can also be "all" for all 
measurements. See vignette for details.}

\item{\code{RSEM}}{TRUE if object was made from RSEM output, FALSE if object was made
from Tablemaker/Cufflinks output.}
}}

\examples{
  data(bg)
  class(bg) #"ballgown"
  dim(bg@expr$exon)
  bg@structure$exon
  head(bg@indexes$t2g)
  head(bg@dirs)
  bg@mergedDate
  bg@meas
  bg@RSEM
}
\author{
Alyssa Frazee, Leonardo Collado-Torres, Jeff Leek
}
