% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ballgownrsem.R
\name{ballgownrsem}
\alias{ballgownrsem}
\title{load RSEM data into a ballgown object}
\usage{
ballgownrsem(dir = "", samples, gtf, UCSC = TRUE,
  tfield = "transcript_id", attrsep = "; ", bamout = "transcript",
  pData = NULL, verbose = TRUE, meas = "all", zipped = FALSE)
}
\arguments{
\item{dir}{output directory containing RSEM output for all samples (i.e. for
each run of rsem-calculate-expression)}

\item{samples}{vector of sample names (i.e., of the \code{sample_name}
arguments used in each RSEM run)}

\item{gtf}{path to GTF file of genes/transcripts used in your RSEM reference.
(where the reference location was denoted by the \code{reference_name} 
argument used in rsem-calculate-expression). RSEM references can be created
with or without a GTF file, but currently the ballgown reader requires the 
GTF file.}

\item{UCSC}{set to TRUE if \code{gtf} comes from UCSC: quotes will be
stripped from transcript identifiers if so.}

\item{tfield}{What keyword identifies transcripts in the "attributes" field
of \code{gtf}? Default \code{'transcript_id'}.}

\item{attrsep}{How are attributes separated in the "attributes" field of
\code{gtf}? Default \code{'; '} (semicolon-space).}

\item{bamout}{set to \code{'genome'} if \code{--output-genome-bam} was used
when running rsem-calculate-expression; set to \code{'none'} if 
\code{--no-bam-output} was used when running rsem-calculate-expression; 
otherwise use the default (\code{'transcript'}).}

\item{pData}{data frame of phenotype data, with rows corresponding to
\code{samples}. The first column of \code{pData} must be equal to 
\code{samples}, and rows must be in the same order as \code{samples}.}

\item{verbose}{If TRUE (as by default), status messages are printed during
data loading.}

\item{meas}{character vector containing either "all" or one of "FPKM" or 
"TPM". The resulting ballgown object will only contain the specified
expression measurement for the transcripts. "all" 
creates the full object.}

\item{zipped}{set to TRUE if all RSEM results files have been gzipped (end)
in ".gz").}
}
\value{
a ballgown object with the specified expression measurements and
  structure specified by GTF.
}
\description{
Loads results of rsem-calculate-expression into a ballgown
  object for easy visualization, processing, and statistical testing
}
\details{
Currently exon- and intron-level measurements are not available for
  RSEM-generated ballgown objects, but development is ongoing.
}
\examples{
dataDir = system.file('extdata', package='ballgown')
gtf = file.path(dataDir, 'hg19_genes_small.gtf.gz')
rsemobj = ballgownrsem(dir=dataDir, samples=c('tiny', 'tiny2'), gtf=gtf,
    bamout='none', zipped=TRUE)
rsemobj

}
\seealso{
\code{\link{ballgown}} for reading Cufflinks/Tablemaker output
}
