% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ballgown-expr-methods.R
\docType{methods}
\name{eexpr}
\alias{eexpr}
\alias{eexpr}
\alias{eexpr,ballgown-method}
\title{extract exon-level expression measurements from ballgown objects}
\usage{
eexpr(x, meas = "rcount")

\S4method{eexpr}{ballgown}(x, meas = "rcount")
}
\arguments{
\item{x}{a ballgown object}

\item{meas}{type of measurement to extract. Can be "rcount", "ucount", 
"mrcount", "cov", "mcov", or "all". Default "rcount".}
}
\value{
exon-by-sample matrix containing exon-level expression values
  (measured by \code{meas}). If \code{meas} is \code{"all"}, or 
  \code{x@RSEM} is TRUE, a data frame is returned, containing all
  measurements and location information.
}
\description{
extract exon-level expression measurements from ballgown objects
}
\examples{
data(bg)
exon_rcount_matrix = eexpr(bg)
exon_ucount_matrix = eexpr(bg, 'ucount')
exon_data_frame = eexpr(bg, 'all')
}
