% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cos_sim_matrix.R
\name{cos_sim_matrix}
\alias{cos_sim_matrix}
\title{Compute all pairwise cosine similarities between mutational profiles/signatures}
\usage{
cos_sim_matrix(mut_matrix1, mut_matrix2)
}
\arguments{
\item{mut_matrix1}{96 mutation count matrix (dimensions: 96 mutations X n samples)}

\item{mut_matrix2}{96 mutation count matrix (dimensions: 96 mutations X m samples)}
}
\value{
Matrix with pairwise cosine similarities (dimensions: n mutational profiles X m mutational profiles)
}
\description{
Computes all pairwise cosine similarities between the mutational profiles provided in the two mutation count matrices. 
The cosine similarity is a value between 0 (distinct) and 1 (identical) and indicates how much two vectors are alike.
}
\examples{
## You can download mutational signatures from the COSMIC database:
# sp_url = http://cancer.sanger.ac.uk/cancergenome/assets/signatures_probabilities.txt
# cancer_signatures = read.table(sp_url, sep = "\\t", header = T)

## We copied the file into our package for your convenience.
filename <- system.file("extdata/signatures_probabilities.txt",
                        package="MutationalPatterns")
cancer_signatures <- read.table(filename, sep = "\\t", header = TRUE)

## See the 'mut_matrix()' example for how we obtained the mutation matrix:
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
                   package="MutationalPatterns"))

## Match the order to MutationalPatterns standard of mutation matrix
order = match(row.names(mut_mat), cancer_signatures$Somatic.Mutation.Type)
## Reorder cancer signatures dataframe
cancer_signatures = cancer_signatures[order,]
## Use trinucletiode changes names as row.names
## row.names(cancer_signatures) = cancer_signatures$Somatic.Mutation.Type
## Keep only 96 contributions of the signatures in matrix
cancer_signatures = as.matrix(cancer_signatures[,4:33])
## Rename signatures to number only
colnames(cancer_signatures) = as.character(1:30)

## Calculate the cosine similarity between each COSMIC signature and each 96 mutational profile
cos_sim_matrix(mut_mat, cancer_signatures)

}
\seealso{
\code{\link{mut_matrix}},
\code{\link{fit_to_signatures}},
\code{\link{plot_cosine_heatmap}}
}
