% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mut_context.R
\name{mut_context}
\alias{mut_context}
\title{Retrieve context of base substitutions}
\usage{
mut_context(vcf, ref_genome)
}
\arguments{
\item{vcf}{A Granges object}

\item{ref_genome}{Reference genome}
}
\value{
Character vector with the context of the base substitutions
}
\description{
A function to extract the bases 3' upstream and 5' downstream of the base
substitutions from the reference genome
}
\examples{
## See the 'read_vcfs_as_granges()' example for how we obtained the
## following data:
vcfs <- readRDS(system.file("states/read_vcfs_as_granges_output.rds",
                package="MutationalPatterns"))

## Load the corresponding reference genome.
ref_genome <- "BSgenome.Hsapiens.UCSC.hg19"
library(ref_genome, character.only = TRUE)

mut_context <- mut_context(vcfs[[1]], ref_genome)

}
\seealso{
\code{\link{read_vcfs_as_granges}},
}
