% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutations_from_vcf.R
\name{mutations_from_vcf}
\alias{mutations_from_vcf}
\title{Retrieve base substitutions from vcf}
\usage{
mutations_from_vcf(vcf)
}
\arguments{
\item{vcf}{A CollapsedVCF object}
}
\value{
Character vector with base substitutions
}
\description{
A function to extract base substitutions of each position in vcf
}
\examples{
## See the 'read_vcfs_as_granges()' example for how we obtained the
## following data:
vcfs <- readRDS(system.file("states/read_vcfs_as_granges_output.rds",
                package="MutationalPatterns"))

muts = mutations_from_vcf(vcfs[[1]])

}
\seealso{
\code{\link{read_vcfs_as_granges}}
}
