% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cosine_heatmap.R
\name{plot_cosine_heatmap}
\alias{plot_cosine_heatmap}
\title{Plot cosine similarity heatmap}
\usage{
plot_cosine_heatmap(cos_sim_matrix, col_order, cluster_rows = TRUE,
  method = "complete", plot_values = FALSE)
}
\arguments{
\item{cos_sim_matrix}{Matrix with pairwise cosine similarities.
Result from \code{\link{cos_sim_matrix}}}

\item{col_order}{Character vector with the desired order of the columns names for plotting. Optional.}

\item{cluster_rows}{Hierarchically cluster rows based on eucledian distance. Default = TRUE.}

\item{method}{The agglomeration method to be used for hierarchical clustering. This should be one of 
"ward.D", "ward.D2", "single", "complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) 
or "centroid" (= UPGMC). Default = "complete".}

\item{plot_values}{Plot cosine similarity values in heatmap. Default = FALSE.}
}
\value{
Heatmap with cosine similarities
}
\description{
Plot pairwise cosine similarities in a heatmap.
}
\examples{

## See the 'mut_matrix()' example for how we obtained the mutation matrix:
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
                    package="MutationalPatterns"))

## You can download the signatures from the COSMIC:
# http://cancer.sanger.ac.uk/cancergenome/assets/signatures_probabilities.txt

## We copied the file into our package for your convenience.
filename <- system.file("extdata/signatures_probabilities.txt",
                        package="MutationalPatterns")
cancer_signatures <- read.table(filename, sep = "\\t", header = TRUE)

## Match the order to MutationalPatterns standard of mutation matrix
order = match(row.names(mut_mat), cancer_signatures$Somatic.Mutation.Type)
## Reorder cancer signatures dataframe
cancer_signatures = cancer_signatures[order,]
## Use trinucletiode changes names as row.names
## row.names(cancer_signatures) = cancer_signatures$Somatic.Mutation.Type
## Keep only 96 contributions of the signatures in matrix
cancer_signatures = as.matrix(cancer_signatures[,4:33])
## Rename signatures to number only
colnames(cancer_signatures) = as.character(1:30)

## Calculate the cosine similarity between each signature and each 96 mutational profile
cos_matrix = cos_sim_matrix(mut_mat, cancer_signatures)

## Cluster signatures based on cosine similarity 
sig_hclust = cluster_signatures(cancer_signatures)
col_order = colnames(cancer_signatures)[sig_hclust$order]

## Plot the cosine similarity between each signature and each sample with hierarchical 
## sample clustering and signatures order based on similarity

plot_cosine_heatmap(cos_matrix, col_order, cluster_rows = TRUE, method = "complete")

}
\seealso{
\code{\link{mut_matrix}},
\code{\link{cos_sim_matrix}},
\code{\link{cluster_signatures}}
}
