% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_signature_strand_bias.R
\name{plot_signature_strand_bias}
\alias{plot_signature_strand_bias}
\title{Plot signature strand bias}
\usage{
plot_signature_strand_bias(signatures_strand_bias)
}
\arguments{
\item{signatures_strand_bias}{Signature matrix with 192 features}
}
\value{
Barplot
}
\description{
Plot strand bias per mutation type for each signature.
}
\examples{
## See the 'mut_matrix()' example for how we obtained the following
## mutation matrix.
mut_mat_s <- readRDS(system.file("states/mut_mat_s_data.rds",
                                    package="MutationalPatterns"))

## Extracting signatures can be computationally intensive, so
## we use pre-computed data generated with the following command:
# nmf_res_strand <- extract_signatures(mut_mat_s, rank = 2)

nmf_res_strand <- readRDS(system.file("states/nmf_res_strand_data.rds",
                                        package="MutationalPatterns"))

## Provide column names for the plot.
colnames(nmf_res_strand$signatures) = c("Signature A", "Signature B")

plot_signature_strand_bias(nmf_res_strand$signatures) 

}
\seealso{
\code{link{extract_signatures}},
\code{link{mut_matrix()}}
}
