% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strand_occurrences.R
\name{strand_occurrences}
\alias{strand_occurrences}
\title{Count occurrences per base substitution type and strand}
\usage{
strand_occurrences(mut_mat_s, by)
}
\arguments{
\item{mut_mat_s}{192 feature mutation count matrix, result from
'mut_matrix_stranded()'}

\item{by}{Character vector with grouping info, optional}
}
\value{
A data.frame with the total number of mutations and relative
contribution within group per base substitution type and strand
}
\description{
For each base substitution type and strand the total number
of mutations and the relative contribution within a group is returned.
}
\examples{
## See the 'mut_matrix_stranded()' example for how we obtained the
## following mutation matrix.
mut_mat_s <- readRDS(system.file("states/mut_mat_s_data.rds",
                                    package="MutationalPatterns"))

## Load a reference genome.
ref_genome <- "BSgenome.Hsapiens.UCSC.hg19"
library(ref_genome, character.only = TRUE)

tissue <- c("colon", "colon", "colon",
            "intestine", "intestine", "intestine",
            "liver", "liver", "liver")

strand_counts = strand_occurrences(mut_mat_s, by=tissue)

}
\seealso{
\code{\link{mut_matrix_stranded}},
\code{\link{plot_strand}},
\code{\link{plot_strand_bias}}
}
